/**
 * Copyright (c) 2013 RCP Vision (http://www.rcp-vision.com) and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 * Lorenzo Bettini - initial API and implementation
 */
package org.eclipse.emf.parsley.dsl.jvmmodel;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import java.beans.Introspector;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.parsley.dsl.model.Module;
import org.eclipse.emf.parsley.dsl.model.PartSpecification;
import org.eclipse.emf.parsley.dsl.model.PartsSpecifications;
import org.eclipse.emf.parsley.generator.common.EmfParsleyProjectFilesGenerator;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.xbase.lib.Extension;

/**
 * @author Lorenzo Bettini
 */
@SuppressWarnings("all")
public class EmfParsleyDslGeneratorUtils {
  @Inject
  @Extension
  private IQualifiedNameProvider _iQualifiedNameProvider;
  
  @Inject
  private EmfParsleyProjectFilesGenerator projectFilesGenerator;
  
  public String getPropertyNameForGetterSetterMethod(final String opName) {
    boolean _and = false;
    boolean _and_1 = false;
    boolean _startsWith = opName.startsWith("get");
    if (!_startsWith) {
      _and_1 = false;
    } else {
      int _length = opName.length();
      boolean _greaterThan = (_length > 3);
      _and_1 = _greaterThan;
    }
    if (!_and_1) {
      _and = false;
    } else {
      char _charAt = opName.charAt(3);
      boolean _isUpperCase = Character.isUpperCase(_charAt);
      _and = _isUpperCase;
    }
    if (_and) {
      String _substring = opName.substring(3);
      return Introspector.decapitalize(_substring);
    }
    boolean _and_2 = false;
    boolean _and_3 = false;
    boolean _startsWith_1 = opName.startsWith("is");
    if (!_startsWith_1) {
      _and_3 = false;
    } else {
      int _length_1 = opName.length();
      boolean _greaterThan_1 = (_length_1 > 2);
      _and_3 = _greaterThan_1;
    }
    if (!_and_3) {
      _and_2 = false;
    } else {
      char _charAt_1 = opName.charAt(2);
      boolean _isUpperCase_1 = Character.isUpperCase(_charAt_1);
      _and_2 = _isUpperCase_1;
    }
    if (_and_2) {
      String _substring_1 = opName.substring(2);
      return Introspector.decapitalize(_substring_1);
    }
    return opName;
  }
  
  public String executableExtensionFactoryQN(final Module element) {
    QualifiedName _fullyQualifiedName = this._iQualifiedNameProvider.getFullyQualifiedName(element);
    String _string = _fullyQualifiedName.toString();
    String _plus = (_string + ".");
    QualifiedName _fullyQualifiedName_1 = this._iQualifiedNameProvider.getFullyQualifiedName(element);
    String _string_1 = _fullyQualifiedName_1.toString();
    CharSequence _extFactoryName = this.projectFilesGenerator.extFactoryName(_string_1);
    return (_plus + _extFactoryName);
  }
  
  public String executableExtensionFactoryQN(final PartSpecification element) {
    Module _containerOfType = EcoreUtil2.<Module>getContainerOfType(element, Module.class);
    return this.executableExtensionFactoryQN(_containerOfType);
  }
  
  public boolean shouldGenerateExtensions(final Module module) {
    PartsSpecifications _partsSpecifications = null;
    if (module!=null) {
      _partsSpecifications=module.getPartsSpecifications();
    }
    EList<PartSpecification> _parts = null;
    if (_partsSpecifications!=null) {
      _parts=_partsSpecifications.getParts();
    }
    final EList<PartSpecification> partSpecs = _parts;
    boolean _and = false;
    boolean _notEquals = (!Objects.equal(partSpecs, null));
    if (!_notEquals) {
      _and = false;
    } else {
      boolean _isEmpty = partSpecs.isEmpty();
      boolean _not = (!_isEmpty);
      _and = _not;
    }
    return _and;
  }
}
