/**
 * Copyright (c) 2013 RCP Vision (http://www.rcp-vision.com) and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 * Lorenzo Bettini - initial API and implementation
 */
package org.eclipse.emf.parsley.dsl.util;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.parsley.dsl.model.Module;
import org.eclipse.emf.parsley.dsl.model.WithExtendsClause;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.xbase.jvmmodel.IJvmModelAssociations;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.typesystem.override.IResolvedOperation;
import org.eclipse.xtext.xbase.typesystem.override.OverrideHelper;
import org.eclipse.xtext.xbase.typesystem.override.ResolvedFeatures;

@SuppressWarnings("all")
public class EmfParsleyDslGuiceModuleHelper {
  @Inject
  @Extension
  private IJvmModelAssociations _iJvmModelAssociations;
  
  @Inject
  @Extension
  private OverrideHelper _overrideHelper;
  
  public JvmGenericType getModuleInferredType(final Module module) {
    Iterable<JvmGenericType> _inferredJavaTypes = this.getInferredJavaTypes(module);
    return IterableExtensions.<JvmGenericType>head(_inferredJavaTypes);
  }
  
  public Iterable<JvmGenericType> getInferredJavaTypes(final EObject o) {
    Set<EObject> _jvmElements = this._iJvmModelAssociations.getJvmElements(o);
    return Iterables.<JvmGenericType>filter(_jvmElements, JvmGenericType.class);
  }
  
  public Iterable<JvmOperation> getAllGuiceValueBindingsMethodsInSuperclass(final Module module) {
    JvmGenericType _moduleInferredType = this.getModuleInferredType(module);
    return this.getAllGuiceValueBindingsMethodsInSuperclass(_moduleInferredType);
  }
  
  public Iterable<JvmOperation> getAllGuiceTypeBindingsMethodsInSuperclass(final Module module) {
    Iterable<JvmOperation> _superTypeJvmOperations = this.superTypeJvmOperations(module);
    final Function1<JvmOperation, Boolean> _function = new Function1<JvmOperation, Boolean>() {
      @Override
      public Boolean apply(final JvmOperation it) {
        boolean _and = false;
        String _simpleName = it.getSimpleName();
        boolean _startsWith = _simpleName.startsWith("bind");
        if (!_startsWith) {
          _and = false;
        } else {
          JvmTypeReference _returnType = it.getReturnType();
          EList<JvmTypeReference> _arguments = ((JvmParameterizedTypeReference) _returnType).getArguments();
          JvmTypeReference _head = IterableExtensions.<JvmTypeReference>head(_arguments);
          boolean _notEquals = (!Objects.equal(_head, null));
          _and = _notEquals;
        }
        return Boolean.valueOf(_and);
      }
    };
    return IterableExtensions.<JvmOperation>filter(_superTypeJvmOperations, _function);
  }
  
  public Iterable<JvmOperation> getAllGuiceProviderBindingsMethodsInSuperclass(final Module module) {
    Iterable<JvmOperation> _superTypeJvmOperations = this.superTypeJvmOperations(module);
    final Function1<JvmOperation, Boolean> _function = new Function1<JvmOperation, Boolean>() {
      @Override
      public Boolean apply(final JvmOperation it) {
        String _simpleName = it.getSimpleName();
        return Boolean.valueOf(_simpleName.startsWith("provide"));
      }
    };
    return IterableExtensions.<JvmOperation>filter(_superTypeJvmOperations, _function);
  }
  
  public Iterable<JvmOperation> getAllGuiceValueBindingsMethodsInSuperclass(final JvmGenericType type) {
    Iterable<JvmOperation> _superTypeJvmOperations = this.superTypeJvmOperations(type);
    final Function1<JvmOperation, Boolean> _function = new Function1<JvmOperation, Boolean>() {
      @Override
      public Boolean apply(final JvmOperation it) {
        String _simpleName = it.getSimpleName();
        return Boolean.valueOf(_simpleName.startsWith("value"));
      }
    };
    return IterableExtensions.<JvmOperation>filter(_superTypeJvmOperations, _function);
  }
  
  public Iterable<JvmGenericType> getAllWithExtendsClauseInferredJavaTypes(final Module module) {
    Iterable<WithExtendsClause> _allWithExtendsClause = this.getAllWithExtendsClause(module);
    final Function1<WithExtendsClause, Iterable<JvmGenericType>> _function = new Function1<WithExtendsClause, Iterable<JvmGenericType>>() {
      @Override
      public Iterable<JvmGenericType> apply(final WithExtendsClause it) {
        return EmfParsleyDslGuiceModuleHelper.this.getInferredJavaTypes(it);
      }
    };
    Iterable<Iterable<JvmGenericType>> _map = IterableExtensions.<WithExtendsClause, Iterable<JvmGenericType>>map(_allWithExtendsClause, _function);
    return Iterables.<JvmGenericType>concat(_map);
  }
  
  public Iterable<WithExtendsClause> getAllWithExtendsClause(final Module module) {
    EList<EObject> _eContents = module.eContents();
    return Iterables.<WithExtendsClause>filter(_eContents, WithExtendsClause.class);
  }
  
  public ResolvedFeatures getJavaResolvedFeatures(final JvmGenericType type) {
    return this._overrideHelper.getResolvedFeatures(type);
  }
  
  public String getJavaMethodResolvedErasedSignature(final IResolvedOperation op) {
    return op.getResolvedErasureSignature();
  }
  
  private Iterable<JvmOperation> superTypeJvmOperations(final Module module) {
    JvmGenericType _moduleInferredType = this.getModuleInferredType(module);
    return this.superTypeJvmOperations(_moduleInferredType);
  }
  
  private Iterable<JvmOperation> superTypeJvmOperations(final JvmGenericType type) {
    boolean _equals = Objects.equal(type, null);
    if (_equals) {
      return CollectionLiterals.<JvmOperation>emptyList();
    }
    EList<JvmTypeReference> _superTypes = type.getSuperTypes();
    JvmTypeReference _head = IterableExtensions.<JvmTypeReference>head(_superTypes);
    JvmType _type = _head.getType();
    Iterable<JvmFeature> _allFeatures = ((JvmGenericType) _type).getAllFeatures();
    return Iterables.<JvmOperation>filter(_allFeatures, JvmOperation.class);
  }
}
