/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.parsley.dsl.pluginxml;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.parsley.dsl.pluginxml.PluginXmlUtils;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.pde.core.plugin.IPlugin;
import org.eclipse.pde.core.plugin.IPluginAttribute;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginModelFactory;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.internal.core.text.DocumentElementNode;
import org.eclipse.pde.internal.core.text.IDocumentAttributeNode;
import org.eclipse.pde.internal.core.text.IDocumentElementNode;
import org.eclipse.pde.internal.core.text.plugin.PluginAttribute;
import org.eclipse.pde.internal.core.text.plugin.PluginElementNode;
import org.eclipse.pde.internal.core.text.plugin.PluginExtensionNode;
import org.eclipse.pde.internal.core.text.plugin.PluginModel;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class PluginXmlLoader
extends PluginModel {
    private List<PluginExtensionNode> pluginExtensionNodes;
    private List<PluginElementNode> pluginExtensionElementNodes;

    public PluginXmlLoader(String source) {
        super((IDocument)new Document(source), true);
    }

    public List<PluginExtensionNode> getExtensionNodes() {
        boolean _equals = Objects.equal(this.pluginExtensionNodes, null);
        if (_equals) {
            this.initializeExtensionNodes();
        }
        return this.pluginExtensionNodes;
    }

    protected List<PluginExtensionNode> initializeExtensionNodes() {
        List _list;
        IPlugin _plugin = this.getPlugin();
        IPluginExtension[] _extensions = _plugin.getExtensions();
        Iterable _filter = Iterables.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)_extensions)), PluginExtensionNode.class);
        this.pluginExtensionNodes = _list = IterableExtensions.toList((Iterable)_filter);
        return this.pluginExtensionNodes;
    }

    public List<PluginElementNode> getExtensionElements() {
        boolean _equals = Objects.equal(this.pluginExtensionElementNodes, null);
        if (_equals) {
            this.initializeExtensionElements();
        }
        return this.pluginExtensionElementNodes;
    }

    protected List<PluginElementNode> initializeExtensionElements() {
        List _list;
        List<PluginExtensionNode> _extensionNodes = this.getExtensionNodes();
        Functions.Function1<PluginExtensionNode, Iterable<PluginElementNode>> _function = new Functions.Function1<PluginExtensionNode, Iterable<PluginElementNode>>(){

            public Iterable<PluginElementNode> apply(PluginExtensionNode it) {
                return PluginXmlLoader.this.mapToNodes((DocumentElementNode)it);
            }
        };
        List _map = ListExtensions.map(_extensionNodes, (Functions.Function1)_function);
        Iterable _flatten = Iterables.concat((Iterable)_map);
        this.pluginExtensionElementNodes = _list = IterableExtensions.toList((Iterable)_flatten);
        return this.pluginExtensionElementNodes;
    }

    private Iterable<PluginElementNode> mapToNodes(DocumentElementNode it) {
        IDocumentElementNode[] _childNodes = it.getChildNodes();
        return Iterables.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)_childNodes)), PluginElementNode.class);
    }

    public List<PluginElementNode> getExtensionChildren(PluginElementNode node) {
        Iterable<PluginElementNode> _mapToNodes = this.mapToNodes((DocumentElementNode)node);
        return IterableExtensions.toList(_mapToNodes);
    }

    public Iterable<Map.Entry<String, IDocumentAttributeNode>> getPluginAttributesEntrySet(PluginElementNode node) {
        return PluginXmlUtils.getPluginAttributesEntrySet(node);
    }

    public PluginExtensionNode getExtensionByPoint(final String p) {
        List<PluginExtensionNode> _extensionNodes = this.getExtensionNodes();
        Functions.Function1<PluginExtensionNode, Boolean> _function = new Functions.Function1<PluginExtensionNode, Boolean>(){

            public Boolean apply(PluginExtensionNode it) {
                String _point = it.getPoint();
                return Objects.equal((Object)_point, (Object)p);
            }
        };
        return (PluginExtensionNode)IterableExtensions.findFirst(_extensionNodes, (Functions.Function1)_function);
    }

    public String getElementExtension(PluginElementNode node) {
        IPluginObject _parent = node.getParent();
        return ((PluginExtensionNode)_parent).getPoint();
    }

    public PluginElementNode getElementByTagAndId(final String xmlTag, final String id) {
        List<PluginElementNode> _extensionElements = this.getExtensionElements();
        Functions.Function1<PluginElementNode, Boolean> _function = new Functions.Function1<PluginElementNode, Boolean>(){

            public Boolean apply(PluginElementNode it) {
                String _xMLTagName = it.getXMLTagName();
                return Objects.equal((Object)_xMLTagName, (Object)xmlTag);
            }
        };
        Iterable _filter = IterableExtensions.filter(_extensionElements, (Functions.Function1)_function);
        Functions.Function1<PluginElementNode, Boolean> _function_1 = new Functions.Function1<PluginElementNode, Boolean>(){

            public Boolean apply(PluginElementNode it) {
                boolean _notEquals;
                boolean _xblockexpression = false;
                IDocumentAttributeNode v = PluginXmlLoader.this.getId((DocumentElementNode)it);
                boolean _xifexpression = false;
                boolean bl = _notEquals = !Objects.equal((Object)v, null);
                if (_notEquals) {
                    String _attributeAsString = PluginXmlLoader.this.getAttributeAsString(v);
                    _xifexpression = Objects.equal((Object)_attributeAsString, (Object)id);
                } else {
                    _xifexpression = false;
                }
                _xblockexpression = _xifexpression;
                return _xblockexpression;
            }
        };
        return (PluginElementNode)IterableExtensions.findFirst((Iterable)_filter, (Functions.Function1)_function_1);
    }

    public IDocumentAttributeNode getId(DocumentElementNode node) {
        return PluginXmlUtils.getId(node);
    }

    public String getAttributeAsString(IDocumentAttributeNode a) {
        return ((PluginAttribute)a).getValue();
    }

    public void copyFromPluginXml(String source) throws CoreException {
        PluginXmlLoader _pluginXmlLoader = new PluginXmlLoader(source);
        List<PluginElementNode> _extensionElements = _pluginXmlLoader.getExtensionElements();
        for (PluginElementNode e : _extensionElements) {
            this.copy(e);
        }
    }

    public void copy(PluginElementNode source) throws CoreException {
        IDocumentAttributeNode _id;
        String _attributeAsString;
        String xmlTagName = source.getXMLTagName();
        PluginElementNode target = this.getElementByTagAndId(xmlTagName, _attributeAsString = this.getAttributeAsString(_id = this.getId((DocumentElementNode)source)));
        boolean _equals = Objects.equal((Object)target, null);
        if (_equals) {
            PluginElementNode _insertExtensionElement;
            String _elementExtension = this.getElementExtension(source);
            target = _insertExtensionElement = this.insertExtensionElement(_elementExtension, xmlTagName);
        }
        this.copy(source, target);
    }

    public void copy(PluginElementNode source, PluginElementNode target) throws CoreException {
        IDocumentElementNode[] _childNodes;
        IPluginAttribute[] atts;
        IPluginAttribute[] iPluginAttributeArray = atts = source.getAttributes();
        int n = atts.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginAttribute a = iPluginAttributeArray[n2];
            PluginAttribute att = (PluginAttribute)a;
            PluginAttribute copy = new PluginAttribute();
            String _name = att.getName();
            copy.setName(_name);
            String _value = att.getValue();
            copy.setValue(_value);
            TreeMap _nodeAttributesMap = PluginXmlUtils.getNodeAttributesMap((DocumentElementNode)target);
            String _name_1 = att.getName();
            _nodeAttributesMap.put(_name_1, copy);
            ++n2;
        }
        IDocumentElementNode[] children = target.getChildNodes();
        IDocumentElementNode[] iDocumentElementNodeArray = _childNodes = source.getChildNodes();
        int n3 = _childNodes.length;
        int n4 = 0;
        while (n4 < n3) {
            final IDocumentElementNode c = iDocumentElementNodeArray[n4];
            Functions.Function1<IDocumentElementNode, Boolean> _function = new Functions.Function1<IDocumentElementNode, Boolean>(){

                public Boolean apply(IDocumentElementNode it) {
                    String _xMLTagName = it.getXMLTagName();
                    String _xMLTagName_1 = c.getXMLTagName();
                    return Objects.equal((Object)_xMLTagName, (Object)_xMLTagName_1);
                }
            };
            IDocumentElementNode myChild = (IDocumentElementNode)IterableExtensions.findFirst((Iterable)((Iterable)Conversions.doWrapArray((Object)children)), (Functions.Function1)_function);
            boolean _equals = Objects.equal((Object)myChild, null);
            if (_equals) {
                IPluginModelFactory _pluginFactory = this.getPluginFactory();
                IPluginElement _createElement = _pluginFactory.createElement((IPluginObject)target);
                PluginElementNode newChild = (PluginElementNode)_createElement;
                String _xMLTagName = c.getXMLTagName();
                newChild.setXMLTagName(_xMLTagName);
                target.addChildNode((IDocumentElementNode)newChild);
                this.copy((PluginElementNode)c, newChild);
            } else {
                this.copy((PluginElementNode)c, (PluginElementNode)myChild);
            }
            ++n4;
        }
    }

    public PluginExtensionNode insertExtension(String point) throws CoreException {
        IPluginModelFactory _pluginFactory = this.getPluginFactory();
        IPluginExtension e = _pluginFactory.createExtension();
        e.setPoint(point);
        IPlugin _plugin = this.getPlugin();
        _plugin.add(e);
        this.initializeExtensionNodes();
        return (PluginExtensionNode)e;
    }

    public PluginElementNode insertExtensionElement(String point, String xmlTag) throws CoreException {
        PluginExtensionNode ext = this.getExtensionByPoint(point);
        boolean _equals = Objects.equal((Object)ext, null);
        if (_equals) {
            PluginExtensionNode _insertExtension;
            ext = _insertExtension = this.insertExtension(point);
        }
        IPluginModelFactory _pluginFactory = this.getPluginFactory();
        IPluginElement _createElement = _pluginFactory.createElement((IPluginObject)ext);
        PluginElementNode element = (PluginElementNode)_createElement;
        ext.addChildNode((IDocumentElementNode)element);
        element.setXMLTagName(xmlTag);
        this.initializeExtensionElements();
        return element;
    }

    public String getContentsAsString() {
        StringConcatenation _builder = new StringConcatenation();
        IPlugin _plugin = this.getPlugin();
        String _string = _plugin.toString();
        String _replaceFirst = _string.replaceFirst("eclipse version=\"3.0", "eclipse version=\"3.4");
        String _replaceFirst_1 = _replaceFirst.replaceFirst("(<plugin)\\r?\\n(>)", "<plugin>");
        _builder.append((Object)_replaceFirst_1, "");
        _builder.newLineIfNotEmpty();
        return _builder.toString();
    }
}

