/**
 * Copyright (c) 2013 RCP Vision (http://www.rcp-vision.com) and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 * Lorenzo Bettini - initial API and implementation
 */
package org.eclipse.emf.parsley.dsl.ui.wizard;

import org.eclipse.emf.parsley.generator.common.EmfParsleyProjectFilesGenerator;
import org.eclipse.emf.parsley.generator.common.EmfParsleyProjectFilesGeneratorUtil;
import org.eclipse.xtend2.lib.StringConcatenation;

@SuppressWarnings("all")
public class EmfParsleyDslNewProjectFiles extends EmfParsleyProjectFilesGenerator {
  public CharSequence genEmptyDslModule(final String projectName) {
    return this.genDslModule(projectName, "");
  }
  
  public CharSequence genDslModule(final String projectName, final CharSequence additional) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("/* ");
    _builder.append(projectName, "");
    _builder.append(" EMF Parsley Dsl Module file */");
    _builder.newLineIfNotEmpty();
    _builder.append("module ");
    _builder.append(projectName, "");
    _builder.append(" {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append(additional, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence genDslModuleWithViewPart(final String projectName, final String viewFQN, final String configuratorContents) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("import ");
    _builder.append(viewFQN, "");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    StringConcatenation _builder_1 = new StringConcatenation();
    _builder_1.append("parts {");
    _builder_1.newLine();
    _builder_1.append("\t");
    _builder_1.append("viewpart ");
    _builder_1.append(projectName, "\t");
    _builder_1.append(" {");
    _builder_1.newLineIfNotEmpty();
    _builder_1.append("\t\t");
    _builder_1.append("viewname \"");
    String _buildClassNameFromProject = EmfParsleyProjectFilesGeneratorUtil.buildClassNameFromProject(projectName);
    _builder_1.append(_buildClassNameFromProject, "\t\t");
    _builder_1.append("\"");
    _builder_1.newLineIfNotEmpty();
    _builder_1.append("\t\t");
    _builder_1.append("viewclass ");
    String _buildClassNameFromProject_1 = EmfParsleyProjectFilesGeneratorUtil.buildClassNameFromProject(viewFQN);
    _builder_1.append(_buildClassNameFromProject_1, "\t\t");
    _builder_1.newLineIfNotEmpty();
    _builder_1.append("\t");
    _builder_1.append("}");
    _builder_1.newLine();
    _builder_1.append("}");
    _builder_1.newLine();
    _builder_1.newLine();
    _builder_1.append(configuratorContents, "");
    _builder_1.newLineIfNotEmpty();
    CharSequence _genDslModule = this.genDslModule(projectName, _builder_1);
    _builder.append(_genDslModule, "");
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  public CharSequence genConfigurator(final CharSequence contents) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("configurator {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append(contents, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence genResourceURI(final CharSequence className) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("resourceURI {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append(className, "\t");
    _builder.append(" -> {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("// TODO create and return a org.eclipse.emf.common.util.URI");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return null;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence genEClass(final CharSequence className) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("eClass {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append(className, "\t");
    _builder.append(" -> {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("// TODO return the EClass of objects to be shown");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence genFeaturesEClass(final CharSequence className) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("eClass {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append(className, "\t");
    _builder.append(" -> {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("// TODO return the EClass with the features to be shown");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence genResourceManager(final CharSequence contents) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("resourceManager {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append(contents, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence genInitializeResource() {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("initializeResource {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// Optional: initialize an empty Resource");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// \'it\' is of type Resource");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// e.g., it.getContents += myFactory.createMyClass");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence genViewClass(final String projectName, final String className, final String extendsClass) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("package ");
    _builder.append(projectName, "");
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("public class ");
    _builder.append(className, "");
    _builder.append(" extends ");
    _builder.append(extendsClass, "");
    _builder.append(" {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
}
