/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.parsley.wizards;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.parsley.generator.common.EmfParsleyProjectFilesGenerator;

public class NewEmfParsleyProjectSupport {
    private static final String JAVA_EXTENSION = ".java";
    private static final String PARSLEY_EXTENSION = ".parsley";
    static EmfParsleyProjectFilesGenerator filesGenerator = new EmfParsleyProjectFilesGenerator();

    protected NewEmfParsleyProjectSupport() {
    }

    public static void createDslModule(IProject project, String projectName, String projectPackagePath, String contents, IProgressMonitor progressMonitor) throws CoreException {
        NewEmfParsleyProjectSupport.createProjectFile(project, String.valueOf(projectPackagePath) + "/" + filesGenerator.moduleFileName(projectName) + PARSLEY_EXTENSION, contents, progressMonitor);
    }

    public static void createActivator(IProject project, String projectName, String projectPackagePath, IProgressMonitor progressMonitor) throws CoreException {
        NewEmfParsleyProjectSupport.createProjectFile(project, String.valueOf(projectPackagePath) + "/" + filesGenerator.activatorName(projectName) + JAVA_EXTENSION, filesGenerator.generateActivator(projectName).toString(), progressMonitor);
    }

    public static void addToProjectStructure(IProject newProject, String[] paths, IProgressMonitor monitor) throws CoreException {
        SubMonitor progressMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        progressMonitor.subTask("Creating project folders");
        String[] stringArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            IFolder etcFolders = newProject.getFolder(path);
            NewEmfParsleyProjectSupport.createFolder(etcFolders);
            ++n2;
        }
        progressMonitor.done();
    }

    private static void createFolder(IFolder folder) throws CoreException {
        IContainer parent = folder.getParent();
        if (parent instanceof IFolder) {
            NewEmfParsleyProjectSupport.createFolder((IFolder)parent);
        }
        if (!folder.exists()) {
            folder.create(false, true, null);
        }
    }

    public static void createProjectFile(IProject project, String fileName, String contents, IProgressMonitor monitor) throws CoreException {
        SubMonitor progressMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        progressMonitor.subTask("Creating file " + fileName);
        IFile iFile = project.getFile(fileName);
        iFile.create((InputStream)new ByteArrayInputStream(contents.getBytes(Charset.forName(iFile.getCharset()))), true, null);
        progressMonitor.done();
    }
}

