/*******************************************************************************
 * Copyright (c) 2015 RCP Vision (http://www.rcp-vision.com) and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 * Vincenzo Caselli - Initial contribution and API
 * 
 *******************************************************************************/
package org.eclipse.swt.internal;

import java.util.EventObject;

/**
 * This class is the cross-platform version of the java.util.EventObject class.
 * <p>
 * It is part of our effort to provide support for both J2SE and J2ME platforms.
 * Under this scheme, classes need to extend SWTEventObject instead of
 * java.util.EventObject.
 * </p>
 * <p>
 * Note: java.util.EventObject is not part of CDC and CLDC.
 * </p>
 */
public class SWTEventObject extends EventObject {

	static final long serialVersionUID = 3258125873411470903L;

	/**
	 * Constructs a new instance of this class.
	 *
	 * @param source
	 *            the object which fired the event
	 */
	public SWTEventObject(Object source) {
		super(source);
	}
}
