/**
 * Copyright (c) 2015 RCP Vision (http://www.rcp-vision.com) and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 * Lorenzo Bettini - initial API and implementation
 */
package org.eclipse.emf.parsley.generator.common;

import org.eclipse.xtext.xbase.lib.StringExtensions;

/**
 * @author Lorenzo Bettini - initial API and implementation
 */
@SuppressWarnings("all")
public class EmfParsleyProjectFilesGeneratorUtil {
  protected EmfParsleyProjectFilesGeneratorUtil() {
  }
  
  public static String buildClassNameFromProject(final String projectName) {
    String prefixName = projectName;
    final int dotIndex = projectName.lastIndexOf(".");
    if ((dotIndex > 0)) {
      String _substring = projectName.substring((dotIndex + 1));
      prefixName = _substring;
    }
    return StringExtensions.toFirstUpper(prefixName);
  }
  
  public static String buildFQNFromProject(final String projectName) {
    String packageName = EmfParsleyProjectFilesGeneratorUtil.getPackageFromProject(projectName);
    boolean _isEmpty = packageName.isEmpty();
    boolean _not = (!_isEmpty);
    if (_not) {
      String _packageName = packageName;
      packageName = (_packageName + ".");
    }
    String _buildClassNameFromProject = EmfParsleyProjectFilesGeneratorUtil.buildClassNameFromProject(projectName);
    return (packageName + _buildClassNameFromProject);
  }
  
  public static String stripPackageFromProject(final String projectName) {
    final int dotIndex = projectName.lastIndexOf(".");
    if ((dotIndex > 0)) {
      return projectName.substring((dotIndex + 1));
    }
    return projectName;
  }
  
  public static String getPackageFromProject(final String projectName) {
    return projectName;
  }
}
