/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.diagram.model.util;

import com.ibm.uma.Activity;
import com.ibm.uma.DiagramElement;
import com.ibm.uma.Dimension;
import com.ibm.uma.GraphConnector;
import com.ibm.uma.GraphEdge;
import com.ibm.uma.GraphNode;
import com.ibm.uma.MethodElement;
import com.ibm.uma.Point;
import com.ibm.uma.Process;
import com.ibm.uma.Property;
import com.ibm.uma.SemanticModelBridge;
import com.ibm.uma.SimpleSemanticModelElement;
import com.ibm.uma.TaskDescriptor;
import com.ibm.uma.UMASemanticModelBridge;
import com.ibm.uma.UmaFactory;
import com.ibm.uma.VariabilityElement;
import com.ibm.uma.VariabilityType;
import com.ibm.uma.WorkBreakdownElement;
import com.ibm.uma.WorkOrder;
import com.ibm.uma.util.UmaUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.AbstractTreeIterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.epf.diagram.DiagramResources;
import org.eclipse.epf.diagram.model.ActivityDetailDiagram;
import org.eclipse.epf.diagram.model.Diagram;
import org.eclipse.epf.diagram.model.Link;
import org.eclipse.epf.diagram.model.ModelFactory;
import org.eclipse.epf.diagram.model.Node;
import org.eclipse.epf.diagram.model.NodeContainer;
import org.eclipse.epf.diagram.model.RoleTaskComposite;
import org.eclipse.epf.diagram.model.TypedNode;
import org.eclipse.epf.diagram.model.WorkBreakdownElementNode;
import org.eclipse.epf.diagram.model.impl.NamedNodeImpl;
import org.eclipse.epf.diagram.model.util.GraphicalDataManager;
import org.eclipse.epf.diagram.model.util.INodeChangeListener;
import org.eclipse.epf.library.edit.util.TngUtil;

public class GraphicalDataHelper {
    public static final int ACTIVITY_DIAGRAM = 0;
    public static final int WORK_PRODUCT_DEPENDENCY_DIAGRAM = 1;
    public static final int ACTIVITY_DETAIL_DIAGRAM = 2;
    public static final int[] DIAGRAM_TYPES;
    public static final String[] DIAGRAM_TYPE_TEXTS;
    public static final String PROP_TYPE = "type";
    public static final String PROP_WORK_PRODUCT_COMPOSITE_TYPE = "wpCompositeType";
    public static final String GRAPH_NODE_SYNCH_BAR = "synchnonization bar";
    public static final String GRAPH_NODE_START = "start node";
    public static final String GRAPH_NODE_END = "end node";
    public static final String GRAPH_NODE_DECISION = "decision node";
    public static final String GRAPH_NODE_FREE_TEXT = "free text";
    public static final String DIAGRAM_WORKFLOW = "Workflow";
    public static final String DIAGRAM_WORK_PRODUCT_DEPENDENCY = "Work Product Dependency";
    public static final String DIAGRAM_ACTIVITY_DETAIL = "Activity Detail";
    static /* synthetic */ Class class$0;

    static {
        int[] nArray = new int[3];
        nArray[1] = 2;
        nArray[2] = 1;
        DIAGRAM_TYPES = nArray;
        DIAGRAM_TYPE_TEXTS = new String[]{DiagramResources.getString("Diagram.type.activity"), DiagramResources.getString("Diagram.type.WPD"), DiagramResources.getString("Diagram.type.activityDetail")};
    }

    public static org.eclipse.draw2d.geometry.Point toPoint(Point p) {
        return new org.eclipse.draw2d.geometry.Point(p.getX().doubleValue(), p.getY().doubleValue());
    }

    public static Point newModelPoint(int x, int y) {
        Point p = UmaFactory.eINSTANCE.createPoint();
        p.setX(new Double(x));
        p.setY(new Double(y));
        return p;
    }

    public static Property findProperty(GraphNode node, String propKey) {
        int i = node.getProperty().size() - 1;
        while (i > -1) {
            Property prop = (Property)node.getProperty().get(i);
            if (propKey.equals(prop.getKey())) {
                return prop;
            }
            --i;
        }
        return null;
    }

    public static Dimension newModelDimension(int width, int height) {
        Dimension size = UmaFactory.eINSTANCE.createDimension();
        size.setWidth(new Double(width));
        size.setHeight(new Double(height));
        return size;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void fillConnections(Node node, GraphNode graphNode) {
        boolean old = node.eDeliver();
        try {
            node.eSetDeliver(false);
            Diagram diagram = (Diagram)node.eContainer();
            Iterator iter = graphNode.getAnchorage().iterator();
            while (iter.hasNext()) {
                GraphConnector conn = (GraphConnector)iter.next();
                Iterator iterator = conn.getGraphEdge().iterator();
                while (iterator.hasNext()) {
                    GraphEdge edge = (GraphEdge)iterator.next();
                    Link link = null;
                    if (edge.eContainer() != graphNode) continue;
                    GraphConnector targetConnector = (GraphConnector)edge.getAnchor().get(1);
                    GraphNode targetGraphNode = (GraphNode)targetConnector.eContainer();
                    if (graphNode.eContainer() != targetGraphNode.eContainer()) continue;
                    GraphNode linkedObject = targetGraphNode;
                    if (targetGraphNode.getSemanticModel() instanceof UMASemanticModelBridge) {
                        linkedObject = ((UMASemanticModelBridge)targetGraphNode.getSemanticModel()).getElement();
                    }
                    Node targetNode = GraphicalDataHelper.findNode(diagram, (Object)linkedObject);
                    link = ModelFactory.eINSTANCE.createLink();
                    link.setSource(node);
                    link.setTarget(targetNode);
                    link.setObject(edge);
                }
            }
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            node.eSetDeliver(old);
            throw throwable;
        }
        {
            Object var13_15 = null;
        }
        node.eSetDeliver(old);
    }

    public static Node findNode(Diagram diagram, GraphNode gNode, Class adapterType) {
        SemanticModelBridge bridge = gNode.getSemanticModel();
        if (bridge instanceof UMASemanticModelBridge) {
            INodeChangeListener listener = (INodeChangeListener)UmaUtil.getAdapter((EObject)((UMASemanticModelBridge)bridge).getElement(), (Class)adapterType);
            return listener.getNode();
        }
        Iterator iter = diagram.getNodes().iterator();
        while (iter.hasNext()) {
            Node element = (Node)iter.next();
            if (gNode != element.getObject()) continue;
            return element;
        }
        return null;
    }

    public static Node findNode(NodeContainer container, Object object) {
        Iterator iter = container.getNodes().iterator();
        while (iter.hasNext()) {
            Node element = (Node)iter.next();
            if (object != element.getObject()) continue;
            return element;
        }
        return null;
    }

    public static Node findNode(NodeContainer container, Object object, boolean checkBase) {
        Iterator iter = container.getNodes().iterator();
        while (iter.hasNext()) {
            Node node = (Node)iter.next();
            if (object == node.getObject()) {
                return node;
            }
            if (!checkBase || !(node.getObject() instanceof VariabilityElement)) continue;
            VariabilityElement ve = ((VariabilityElement)node.getObject()).getVariabilityBasedOnElement();
            while (ve != null) {
                if (ve == object) {
                    return node;
                }
                ve = ve.getVariabilityBasedOnElement();
            }
        }
        return null;
    }

    public static Node findNode(ActivityDetailDiagram diagram, Object object) {
        Node node = null;
        Iterator iter = diagram.getNodes().iterator();
        while (iter.hasNext()) {
            Node element = (Node)iter.next();
            if (element instanceof RoleTaskComposite && (node = GraphicalDataHelper.findNode((NodeContainer)element, object)) != null) {
                return node;
            }
            if (object != element.getObject()) continue;
            return element;
        }
        return null;
    }

    private static String getTypeString(int type) {
        switch (type) {
            case 2: {
                return GRAPH_NODE_DECISION;
            }
            case 4: {
                return GRAPH_NODE_END;
            }
            case 3: {
                return GRAPH_NODE_START;
            }
            case 1: {
                return GRAPH_NODE_SYNCH_BAR;
            }
            case 6: {
                return GRAPH_NODE_FREE_TEXT;
            }
        }
        return null;
    }

    public static GraphNode newTypedGraphNode(int type) {
        GraphNode graphNode = UmaFactory.eINSTANCE.createGraphNode();
        SimpleSemanticModelElement bridge = UmaFactory.eINSTANCE.createSimpleSemanticModelElement();
        bridge.setTypeInfo(GraphicalDataHelper.getTypeString(type));
        graphNode.setSemanticModel((SemanticModelBridge)bridge);
        Point point = UmaFactory.eINSTANCE.createPoint();
        point.setX(new Double(-1.0));
        point.setY(new Double(-1.0));
        graphNode.setPosition(point);
        Dimension dim = UmaFactory.eINSTANCE.createDimension();
        dim.setWidth(new Double(-1.0));
        dim.setHeight(new Double(-1.0));
        graphNode.setSize(dim);
        if (type == 6) {
            graphNode.setName(DiagramResources.getString("Diagram.addFreeTxt"));
        }
        if (type == 6) {
            Property property = UmaFactory.eINSTANCE.createProperty();
            property.setKey(GRAPH_NODE_FREE_TEXT);
            property.setValue(DiagramResources.getString("Diagram.addFreeTxt"));
            ArrayList<Property> list = new ArrayList<Property>();
            list.add(property);
            graphNode.set(9, list);
        }
        return graphNode;
    }

    public static void removeGraphicalData(Link link) {
        GraphicalDataManager.getInstance().removeGraphEdge((GraphEdge)link.getObject());
    }

    public static void addGraphicalData(Link link) {
        GraphEdge edge = (GraphEdge)link.getObject();
        if (edge == null) {
            edge = GraphicalDataManager.getInstance().addGraphConnectorPair(link.getSource().getGraphNode(), link.getTarget().getGraphNode());
            link.setObject(edge);
            link.setSourceEndPoint(link.getSourceEndPoint());
            link.setTargetEndPoint(link.getTargetEndPoint());
        } else {
            GraphNode srcNode = link.getSource().getGraphNode();
            GraphNode targetNode = link.getTarget().getGraphNode();
            Object srcConnector = edge.getAnchor().get(0);
            srcNode.getAnchorage().add(srcConnector);
            srcNode.getContained().add(edge);
            Object targetConnector = edge.getAnchor().get(1);
            targetNode.getAnchorage().add(targetConnector);
        }
    }

    public static void setSemanticModel(Link link, WorkOrder workOrder) {
        GraphEdge edge = (GraphEdge)link.getObject();
        UMASemanticModelBridge bridge = UmaFactory.eINSTANCE.createUMASemanticModelBridge();
        bridge.setElement((MethodElement)workOrder);
        edge.setSemanticModel((SemanticModelBridge)bridge);
    }

    public static Collection getSourceNodes(TypedNode typedNode, Class type) {
        ArrayList actNodes = new ArrayList();
        GraphicalDataHelper.getSourceNodes(actNodes, typedNode, type);
        return actNodes;
    }

    public static Collection getTargetNodes(TypedNode typedNode, Class type) {
        ArrayList actNodes = new ArrayList();
        GraphicalDataHelper.getTargetNodes(actNodes, typedNode, type);
        return actNodes;
    }

    public static void getTargetNodes(Collection actNodes, TypedNode typedNode, Class type) {
        Iterator iter = typedNode.getOutgoingConnections().iterator();
        while (iter.hasNext()) {
            Link link = (Link)iter.next();
            Node target = link.getTarget();
            if (type.isInstance(target)) {
                actNodes.add(target);
                continue;
            }
            if (!(target instanceof TypedNode)) continue;
            GraphicalDataHelper.getTargetNodes(actNodes, (TypedNode)target, type);
        }
    }

    public static void getSourceNodes(Collection actNodes, TypedNode typedNode, Class type) {
        Iterator iter = typedNode.getIncomingConnections().iterator();
        while (iter.hasNext()) {
            Link link = (Link)iter.next();
            Node source = link.getSource();
            if (type.isInstance(source)) {
                actNodes.add(source);
                continue;
            }
            if (!(source instanceof TypedNode)) continue;
            GraphicalDataHelper.getSourceNodes(actNodes, (TypedNode)source, type);
        }
    }

    public static Node getFirstSourceNode(TypedNode typedNode, Class type) {
        Iterator iter = typedNode.getIncomingConnections().iterator();
        while (iter.hasNext()) {
            Link link = (Link)iter.next();
            Node source = link.getSource();
            if (type.isInstance(source)) {
                return source;
            }
            if (!(source instanceof TypedNode) || (source = GraphicalDataHelper.getFirstSourceNode((TypedNode)source, type)) == null) continue;
            return source;
        }
        return null;
    }

    public static WorkOrder removeWorkOrder(NamedNodeImpl node, Object predBreakdownElement) {
        boolean notify = node.isNotificationEnabled();
        try {
            node.setNotificationEnabled(false);
            WorkOrder workOrder = UmaUtil.removeWorkOrder((WorkBreakdownElement)((WorkBreakdownElement)node.getObject()), (Object)predBreakdownElement);
            Object var3_4 = null;
            node.setNotificationEnabled(notify);
            return workOrder;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            node.setNotificationEnabled(notify);
            throw throwable;
        }
    }

    public static WorkOrder addDefaultWorkOrder(NamedNodeImpl node, WorkBreakdownElement predBreakdownElement) {
        boolean notify = node.isNotificationEnabled();
        try {
            node.setNotificationEnabled(false);
            WorkOrder workOrder = UmaUtil.createDefaultWorkOrder((WorkBreakdownElement)((WorkBreakdownElement)node.getObject()), (WorkBreakdownElement)predBreakdownElement);
            Object var3_4 = null;
            node.setNotificationEnabled(notify);
            return workOrder;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            node.setNotificationEnabled(notify);
            throw throwable;
        }
    }

    public static boolean hasNoRoleDescriptorAssociated(TaskDescriptor taskDescriptor) {
        return taskDescriptor.getPerformedPrimarilyBy() == null;
    }

    public static boolean contains(NodeContainer container, Node node) {
        Iterator iter = container.getNodes().iterator();
        while (iter.hasNext()) {
            Object child = iter.next();
            if (child == node) {
                return true;
            }
            if (!(child instanceof NodeContainer) || !GraphicalDataHelper.contains((NodeContainer)child, node)) continue;
            return true;
        }
        return false;
    }

    public static boolean refreshFromBase(com.ibm.uma.Diagram diagram) {
        SemanticModelBridge modelBridge = diagram.getSemanticModel();
        if (modelBridge instanceof UMASemanticModelBridge) {
            UMASemanticModelBridge umaModelBridge = (UMASemanticModelBridge)modelBridge;
            Activity act = (Activity)umaModelBridge.getElement();
            Activity base = (Activity)act.getVariabilityBasedOnElement();
            if (base == null || act.getVariabilityType() == VariabilityType.REPLACES_LITERAL) {
                return false;
            }
            int diagramType = GraphicalDataManager.getInstance().getDiagramType(diagram);
            switch (diagramType) {
                case 0: {
                    GraphNode node;
                    com.ibm.uma.Diagram baseDiagram = GraphicalDataManager.getInstance().getUMADiagram(base, diagramType, false);
                    if (baseDiagram == null) {
                        return false;
                    }
                    ArrayList<GraphNode> oldNodes = new ArrayList<GraphNode>();
                    com.ibm.uma.Diagram copy = GraphicalDataHelper.copyDiagram(baseDiagram);
                    Iterator iter = baseDiagram.getContained().iterator();
                    while (iter.hasNext()) {
                        GraphNode node2;
                        GraphNode baseNode = (GraphNode)iter.next();
                        modelBridge = baseNode.getSemanticModel();
                        if (modelBridge instanceof UMASemanticModelBridge) {
                            MethodElement e = ((UMASemanticModelBridge)modelBridge).getElement();
                            node = GraphicalDataManager.findGraphNode(diagram, e);
                            if (node == null) continue;
                            oldNodes.add(node);
                            continue;
                        }
                        if (!GraphicalDataHelper.isUIGraphNode(baseNode) || (node2 = GraphicalDataHelper.findUIGraphNode(diagram, baseNode.getGuid())) == null) continue;
                        oldNodes.add(node2);
                    }
                    diagram.getContained().removeAll(oldNodes);
                    iter = diagram.getContained().iterator();
                    while (iter.hasNext()) {
                        MethodElement e;
                        GraphNode node3 = (GraphNode)iter.next();
                        if (GraphicalDataHelper.isUIGraphNode(node3) && node3.getBriefDescription() != null && node3.getBriefDescription().length() > 0) {
                            iter.remove();
                            continue;
                        }
                        SemanticModelBridge bridge = node3.getSemanticModel();
                        if (!(bridge instanceof UMASemanticModelBridge) || !((e = ((UMASemanticModelBridge)bridge).getElement()) instanceof Activity) || ((Activity)e).getVariabilityBasedOnElement() == null) continue;
                        iter.remove();
                    }
                    iter = act.getBreakdownElements().iterator();
                    while (iter.hasNext()) {
                        VariabilityElement baseElement;
                        Object element = iter.next();
                        if (!(element instanceof Activity) || (node = GraphicalDataManager.findGraphNode(copy, baseElement = ((Activity)element).getVariabilityBasedOnElement())) == null) continue;
                        UMASemanticModelBridge bridge = (UMASemanticModelBridge)node.getSemanticModel();
                        bridge.setElement((MethodElement)element);
                    }
                    diagram.getContained().addAll(copy.getContained());
                    break;
                }
                default: {
                    com.ibm.uma.Diagram baseDiagram = GraphicalDataManager.getInstance().getUMADiagram(base, diagramType, false);
                    if (baseDiagram == null) {
                        return false;
                    }
                    ArrayList<GraphNode> oldNodes = new ArrayList<GraphNode>();
                    com.ibm.uma.Diagram copy = GraphicalDataHelper.copyDiagram(baseDiagram);
                    Iterator iter = baseDiagram.getContained().iterator();
                    while (iter.hasNext()) {
                        MethodElement e;
                        GraphNode node;
                        GraphNode baseNode = (GraphNode)iter.next();
                        modelBridge = baseNode.getSemanticModel();
                        if (!(modelBridge instanceof UMASemanticModelBridge) || (node = GraphicalDataManager.findGraphNode(diagram, e = ((UMASemanticModelBridge)modelBridge).getElement())) == null) continue;
                        oldNodes.add(node);
                    }
                    diagram.getContained().removeAll(oldNodes);
                    diagram.getContained().addAll(copy.getContained());
                }
            }
        }
        return false;
    }

    private static GraphNode findUIGraphNode(com.ibm.uma.Diagram diagram, String baseGuid) {
        Iterator iter = diagram.getContained().iterator();
        while (iter.hasNext()) {
            GraphNode node = (GraphNode)iter.next();
            if (!GraphicalDataHelper.isUIGraphNode(node) || !baseGuid.equals(node.getBriefDescription())) continue;
            return node;
        }
        return null;
    }

    public static boolean isUIGraphNode(GraphNode gNode) {
        String typeInfo;
        SemanticModelBridge modelBridge = gNode.getSemanticModel();
        return modelBridge instanceof SimpleSemanticModelElement && ((typeInfo = ((SimpleSemanticModelElement)modelBridge).getTypeInfo()).equals(GRAPH_NODE_DECISION) || typeInfo.equals(GRAPH_NODE_END) || typeInfo.equals(GRAPH_NODE_START) || typeInfo.equals(GRAPH_NODE_SYNCH_BAR) || typeInfo.equals(GRAPH_NODE_FREE_TEXT));
    }

    public static com.ibm.uma.Diagram copyDiagram(com.ibm.uma.Diagram baseDiagram) {
        com.ibm.uma.Diagram copy = (com.ibm.uma.Diagram)TngUtil.copy((MethodElement)baseDiagram);
        int size = copy.getContained().size();
        int i = 0;
        while (i < size) {
            GraphNode gNode = (GraphNode)copy.getContained().get(i);
            if (GraphicalDataHelper.isUIGraphNode(gNode)) {
                gNode.setBriefDescription(((DiagramElement)baseDiagram.getContained().get(i)).getGuid());
            }
            ++i;
        }
        return copy;
    }

    public static Collection getDiagrams(Activity act) {
        return GraphicalDataHelper.getDiagrams(act, false);
    }

    public static Collection getDiagrams(Activity act, boolean create) {
        ArrayList<com.ibm.uma.Diagram> diagrams = new ArrayList<com.ibm.uma.Diagram>();
        int i = 0;
        while (i < DIAGRAM_TYPES.length) {
            com.ibm.uma.Diagram diagram = GraphicalDataManager.getInstance().getUMADiagram(act, DIAGRAM_TYPES[i], create);
            if (diagram != null) {
                diagrams.add(diagram);
            }
            ++i;
        }
        return diagrams;
    }

    public static String getDiagramTypeText(com.ibm.uma.Diagram diagram) {
        int type = GraphicalDataManager.getInstance().getDiagramType(diagram);
        if (type != -1) {
            return DIAGRAM_TYPE_TEXTS[type];
        }
        return DiagramResources.getString("Diagram.type.unknown");
    }

    public static void setAllDiagramSuppressed(Process proc, boolean suppressed) {
        AbstractTreeIterator iter = new AbstractTreeIterator(proc){

            protected Iterator getChildren(Object object) {
                Activity act = (Activity)object;
                ArrayList children = new ArrayList();
                Iterator iterator = act.getBreakdownElements().iterator();
                while (iterator.hasNext()) {
                    Object element = iterator.next();
                    if (!(element instanceof Activity)) continue;
                    children.add(element);
                }
                return children.iterator();
            }
        };
        while (iter.hasNext()) {
            Collection diagrams = GraphicalDataHelper.getDiagrams((Activity)iter.next(), suppressed);
            Iterator iterator = diagrams.iterator();
            while (iterator.hasNext()) {
                com.ibm.uma.Diagram diagram = (com.ibm.uma.Diagram)iterator.next();
                diagram.setSuppressed(Boolean.valueOf(suppressed));
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void removeLink(Link link) {
        boolean targetNotify;
        Node targetNode;
        block6: {
            Node sourceNode = link.getSource();
            targetNode = link.getTarget();
            boolean srcNotify = sourceNode != null ? sourceNode.eDeliver() : false;
            targetNotify = targetNode != null ? targetNode.eDeliver() : false;
            try {
                if (sourceNode != null) {
                    sourceNode.eSetDeliver(false);
                }
                if (targetNode != null) {
                    targetNode.eSetDeliver(false);
                }
                link.setSource(null);
                link.setTarget(null);
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                if (sourceNode != null) {
                    sourceNode.eSetDeliver(srcNotify);
                }
                if (targetNode == null) throw throwable;
                targetNode.eSetDeliver(targetNotify);
                throw throwable;
            }
            {
                Object var5_7 = null;
                if (sourceNode == null) break block6;
            }
            sourceNode.eSetDeliver(srcNotify);
        }
        if (targetNode == null) return;
        targetNode.eSetDeliver(targetNotify);
    }

    public static Object findElement(Collection allElements, Object e) {
        Iterator iter = allElements.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (e != TngUtil.unwrap(element)) continue;
            return element;
        }
        return null;
    }

    public static boolean anyDuplicatePredecessors(WorkBreakdownElement e) {
        ArrayList list = new ArrayList();
        ArrayList predlist = new ArrayList();
        GraphicalDataHelper.getPreds(e, predlist);
        Iterator itor = predlist.iterator();
        while (itor.hasNext()) {
            Object obj = itor.next();
            if (!list.contains(obj)) {
                list.add(obj);
                continue;
            }
            return true;
        }
        return false;
    }

    public static void getPreds(WorkBreakdownElement e, List list) {
        List predlist = e.getLinkToPredecessor();
        Iterator itor = predlist.iterator();
        while (itor.hasNext()) {
            WorkOrder workorder = (WorkOrder)itor.next();
            list.add(workorder.getPred());
        }
    }

    public static boolean canRemoveAllPreds(Link link, Node oldSource, Node oldTarget) {
        if (oldTarget instanceof WorkBreakdownElementNode) {
            EList inlist = oldTarget.getIncomingConnections();
            Iterator itor = inlist.iterator();
            while (itor.hasNext()) {
                Link incominglink = (Link)itor.next();
                if (incominglink.getSource() instanceof TypedNode && ((TypedNode)incominglink.getSource()).getType() == 1) {
                    Collection col;
                    TypedNode typedNode = (TypedNode)incominglink.getSource();
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.eclipse.epf.diagram.model.WorkBreakdownElementNode");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (!(col = GraphicalDataHelper.getSourceNodes(typedNode, clazz)).contains(oldSource)) continue;
                    return false;
                }
                if (!(incominglink.getSource() instanceof WorkBreakdownElementNode) || !incominglink.getSource().equals(oldSource)) continue;
                return false;
            }
        }
        return true;
    }
}

