/*
 * Decompiled with CFR 0.152.
 */
package com.rational.rpw.processview;

import com.rational.rpw.processview.Bookmark;
import com.rational.rpw.utilities.CommonFunctions;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;
import java.util.Vector;

public class BookmarkLibrary {
    public static final String LIBRARY_DIRECTORY = "applet";
    public static final String BOOKMARK_SUFFIX = ".bkm";
    public static final String SPACE_REPLACEMENT = "_";
    public static final String SPACE_STRING = " ";
    public static final String DEFAULT_BOOKMARK_CFG_NAME = "DefaultBookmark.cfg";

    private BookmarkLibrary() {
    }

    public static boolean isBookmarkExist(String bookmarkName, String destinationDirectory) {
        boolean isExist = false;
        String libraryDirectory = BookmarkLibrary.getLibraryDirectory(destinationDirectory);
        String finalBookmarkName = bookmarkName.replace(SPACE_STRING.charAt(0), SPACE_REPLACEMENT.charAt(0));
        String fileName = String.valueOf(libraryDirectory) + finalBookmarkName + BOOKMARK_SUFFIX;
        File directory = new File(libraryDirectory);
        if (!directory.exists()) {
            isExist = false;
        } else {
            File file = new File(fileName);
            if (file.exists()) {
                isExist = true;
            }
        }
        return isExist;
    }

    public static Vector findBookmarks(String prefix, String directory) throws FileNotFoundException, IOException, ClassNotFoundException {
        if (prefix != null) {
            prefix = prefix.replace(SPACE_STRING.charAt(0), SPACE_REPLACEMENT.charAt(0));
        }
        Vector<Bookmark> bookmarkList = new Vector<Bookmark>();
        File libDirectory = new File(directory);
        if (libDirectory.exists()) {
            String[] fileNameList = libDirectory.list();
            int i = 0;
            while (i < fileNameList.length) {
                Bookmark existing;
                String bookmarkName;
                String filename;
                if (prefix != null) {
                    if (fileNameList[i].startsWith(prefix) && fileNameList[i].endsWith(BOOKMARK_SUFFIX)) {
                        filename = fileNameList[i];
                        bookmarkName = filename.substring(0, filename.indexOf(BOOKMARK_SUFFIX));
                        existing = BookmarkLibrary.readBookmark(directory, bookmarkName);
                        existing.setDefault(true);
                        bookmarkList.addElement(existing);
                    }
                } else if (fileNameList[i].endsWith(BOOKMARK_SUFFIX)) {
                    filename = fileNameList[i];
                    bookmarkName = filename.substring(0, filename.indexOf(BOOKMARK_SUFFIX));
                    existing = BookmarkLibrary.readBookmark(directory, bookmarkName);
                    existing.setDefault(true);
                    bookmarkList.addElement(existing);
                }
                ++i;
            }
        }
        return bookmarkList;
    }

    public static void writeBookmark(Bookmark bookmark, String bookmarkName, String destinationDirectory) throws FileNotFoundException, IOException {
        String libraryDirectory = BookmarkLibrary.getLibraryDirectory(destinationDirectory);
        String finalBookmarkName = bookmarkName.replace(SPACE_STRING.charAt(0), SPACE_REPLACEMENT.charAt(0));
        String fileName = String.valueOf(libraryDirectory) + finalBookmarkName + BOOKMARK_SUFFIX;
        File directory = new File(libraryDirectory);
        if (!directory.exists()) {
            directory.mkdirs();
        }
        directory = null;
        File file = new File(fileName);
        if (file.exists()) {
            file.delete();
        }
        file = null;
        FileOutputStream fos = null;
        ObjectOutputStream oos = null;
        fos = new FileOutputStream(fileName);
        oos = new ObjectOutputStream(fos);
        oos.writeObject(bookmark);
        fos.close();
        oos.close();
    }

    public static Bookmark readBookmark(String inputDirectory, String bookmarkName) throws FileNotFoundException, IOException, ClassNotFoundException {
        String libraryDirectory = BookmarkLibrary.getLibraryDirectory(inputDirectory);
        Bookmark bookmark = null;
        String finalBookmarkName = bookmarkName.replace(SPACE_STRING.charAt(0), SPACE_REPLACEMENT.charAt(0));
        String filename = String.valueOf(libraryDirectory) + finalBookmarkName + BOOKMARK_SUFFIX;
        FileInputStream fis = new FileInputStream(filename);
        ObjectInputStream ois = new ObjectInputStream(fis);
        bookmark = (Bookmark)ois.readObject();
        fis.close();
        ois.close();
        return bookmark;
    }

    public static Bookmark readBookmark(URL documentBase, String bookmarkName) throws MalformedURLException, IOException, ClassNotFoundException {
        Bookmark bookmark = null;
        String finalBookmarkName = bookmarkName.replace(SPACE_STRING.charAt(0), SPACE_REPLACEMENT.charAt(0));
        String filename = String.valueOf(finalBookmarkName) + BOOKMARK_SUFFIX;
        String urlFilename = null;
        if (documentBase.getProtocol().equals("http")) {
            StringTokenizer tokenizer = new StringTokenizer(filename);
            StringBuffer tempName = new StringBuffer();
            while (tokenizer.hasMoreTokens()) {
                tempName.append(tokenizer.nextToken());
                if (!tokenizer.hasMoreTokens()) continue;
                tempName.append("%20");
            }
            urlFilename = tempName.toString();
        } else {
            urlFilename = filename;
        }
        InputStream inStream = new URL(documentBase, urlFilename).openStream();
        ObjectInputStream ois = new ObjectInputStream(inStream);
        bookmark = (Bookmark)ois.readObject();
        inStream.close();
        ois.close();
        return bookmark;
    }

    public static boolean deleteBookmark(String bookmarkName, String directory) {
        try {
            String finalBookmarkName = bookmarkName.replace(SPACE_STRING.charAt(0), SPACE_REPLACEMENT.charAt(0));
            String filename = String.valueOf(directory) + File.separator + finalBookmarkName + BOOKMARK_SUFFIX;
            File file = new File(filename);
            boolean status = file.delete();
            if (!status) {
                return false;
            }
            file = null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static void writeDefaultBookmarkName(String bookmarkName, String destinationDirectory) throws FileNotFoundException, IOException {
        String libraryDirectory = BookmarkLibrary.getLibraryDirectory(destinationDirectory);
        String finalBookmarkName = bookmarkName.replace(SPACE_STRING.charAt(0), SPACE_REPLACEMENT.charAt(0));
        String fileName = String.valueOf(finalBookmarkName) + BOOKMARK_SUFFIX;
        File directory = new File(libraryDirectory);
        if (!directory.exists()) {
            directory.mkdirs();
        }
        directory = null;
        File file = new File(String.valueOf(libraryDirectory) + DEFAULT_BOOKMARK_CFG_NAME);
        if (file.exists()) {
            file.delete();
        }
        file = null;
        FileOutputStream fos = new FileOutputStream(String.valueOf(libraryDirectory) + DEFAULT_BOOKMARK_CFG_NAME, false);
        StringBuffer buffer = new StringBuffer();
        buffer.append(fileName);
        fos.write(buffer.toString().getBytes());
        fos.close();
    }

    public static String readDefaultBookmarkName(URL documentBase) throws MalformedURLException, IOException, ClassNotFoundException {
        int c;
        InputStream inStream = new URL(documentBase, DEFAULT_BOOKMARK_CFG_NAME).openStream();
        StringBuffer result = new StringBuffer();
        while ((c = inStream.read()) != -1) {
            result.append((char)c);
        }
        String content = result.toString();
        inStream.close();
        inStream = null;
        return content;
    }

    public static String convertFileToPresentationName(String bookmarkFilename) {
        String firstStep = bookmarkFilename.replace(SPACE_REPLACEMENT.charAt(0), SPACE_STRING.charAt(0));
        String secondStep = firstStep.substring(0, firstStep.indexOf(BOOKMARK_SUFFIX));
        return secondStep;
    }

    private static String getLibraryDirectory(String libraryRoot) {
        String tempDir = CommonFunctions.formatPath(libraryRoot);
        String libraryDirectory = null;
        libraryDirectory = !tempDir.endsWith(File.separator) ? String.valueOf(tempDir) + File.separator : tempDir;
        return libraryDirectory;
    }
}

