/*
 * Decompiled with CFR 0.152.
 */
package com.rational.rpw.utilities;

import com.rational.rpw.filelibrary.FileLocation;
import com.rational.rpw.filelibrary.PathMap;
import com.rational.rpw.utilities.IProgress;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.text.Collator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;

public class CommonFunctions {
    public static final int BYTECOPY_BUFFER_SIZE = 50000;
    public static final int PATH_DEPTH_MAX = 20;
    public static final String RELATIVE_PATH = "RelativePath";
    public static final String FILE_NAME = "FileName";

    public static void deleteFiles(File theFile) throws IOException {
        CommonFunctions.deleteFiles(theFile, true);
    }

    public static void deleteFiles(File theFile, boolean deleteDirectory) throws IOException {
        File locFile;
        if (!theFile.exists()) {
            return;
        }
        if (theFile.isFile()) {
            if (!theFile.delete()) {
                throw new IOException("Unable to delete \"" + theFile.getAbsolutePath());
            }
            return;
        }
        String[] theList = theFile.list();
        if (theList != null) {
            int i = 0;
            while (i < theList.length) {
                locFile = new File(String.valueOf(theFile.getPath()) + File.separator + theList[i]);
                if (locFile.isFile()) {
                    if (!locFile.delete()) {
                        throw new IOException("Unable to delete  \"" + locFile.getAbsolutePath() + "\"");
                    }
                } else if (locFile.isDirectory()) {
                    CommonFunctions.deleteFiles(locFile);
                }
                ++i;
            }
        }
        boolean rtnValue = true;
        if (theFile.isDirectory() && deleteDirectory && !theFile.delete()) {
            throw new IOException("Unable to delete  \"" + theFile.getAbsolutePath() + "\"");
        }
        theList = null;
        locFile = null;
    }

    public static void FolderCopy(String pSource, String pTarget) throws IOException {
        FilenameFilter theFilter = new FilenameFilter(){

            public boolean accept(File theFile, String name) {
                return true;
            }
        };
        CommonFunctions.FolderCopy(pSource, pTarget, true, theFilter);
    }

    public static void FolderCopy(File pSource, File pTarget, boolean overWrite) throws IOException {
        FilenameFilter theFilter = new FilenameFilter(){

            public boolean accept(File theFile, String name) {
                return true;
            }
        };
        CommonFunctions.FolderCopy(pSource.getAbsolutePath(), pTarget.getAbsolutePath(), overWrite, theFilter);
    }

    public static void FolderCopy(File pSource, File pTarget, boolean overWrite, IProgress pMonitor) throws IOException {
        FilenameFilter theFilter = new FilenameFilter(){

            public boolean accept(File theFile, String name) {
                return true;
            }
        };
        CommonFunctions.FolderCopy(pSource.getAbsolutePath(), pTarget.getAbsolutePath(), overWrite, theFilter, pMonitor);
    }

    public static void FolderCopy(String pSource, String pTarget, final String exclusionMask) throws IOException {
        FilenameFilter theFilter = new FilenameFilter(){

            public boolean accept(File theFile, String name) {
                return !name.endsWith(exclusionMask);
            }
        };
        CommonFunctions.FolderCopy(pSource, pTarget, true, theFilter);
    }

    public static void FolderCopy(String pSource, String pTarget, boolean overWrite, FilenameFilter theFilter) throws IOException {
        CommonFunctions.FolderCopy(pSource, pTarget, overWrite, theFilter, null);
    }

    public static void FolderCopy(String pSource, String pTarget, boolean overWrite, FilenameFilter theFilter, IProgress pMonitor) throws IOException {
        File locFile;
        if (pSource.toLowerCase().equals(pTarget.toLowerCase())) {
            return;
        }
        File theSource = new File(CommonFunctions.formatPath(pSource));
        File theTarget = new File(CommonFunctions.formatPath(pTarget));
        if (!theSource.exists() || !theSource.isDirectory()) {
            throw new IOException(String.valueOf(theSource.getAbsolutePath()) + " -- " + "The directory does not exist");
        }
        if (!theTarget.exists() && !theTarget.mkdirs()) {
            throw new IOException(String.valueOf(theTarget.getAbsolutePath()) + " -- " + "Unable to create the directory");
        }
        String[] theFileList = theSource.list(theFilter);
        int i = 0;
        while (i < theFileList.length) {
            locFile = new File(String.valueOf(theSource.getPath()) + File.separator + theFileList[i]);
            if (locFile.isFile()) {
                if (!CommonFunctions.byteFileCopy(locFile.getPath(), String.valueOf(theTarget.getPath()) + File.separator + theFileList[i], overWrite)) {
                    throw new IOException("Unable to copy \"" + locFile.getPath() + "\"");
                }
                if (pMonitor != null) {
                    pMonitor.increment();
                }
            } else if (locFile.isDirectory()) {
                CommonFunctions.FolderCopy(locFile.getPath(), String.valueOf(theTarget.getPath()) + File.separator + theFileList[i], overWrite, theFilter, pMonitor);
            }
            ++i;
        }
        theFileList = null;
        theSource = null;
        theTarget = null;
        locFile = null;
    }

    public static boolean byteFileCopy(String SourceFile, String TargetFile) {
        return CommonFunctions.byteFileCopy(SourceFile, TargetFile, true);
    }

    public static boolean byteFileCopy(File SourceFile, File TargetFile) {
        return CommonFunctions.byteFileCopy(SourceFile, TargetFile, true);
    }

    public static boolean byteFileCopy(String SourceFile, String TargetFile, boolean overWrite) {
        File theSource = new File(SourceFile);
        File theTarget = new File(TargetFile);
        return CommonFunctions.byteFileCopy(theSource, theTarget, overWrite);
    }

    public static boolean byteFileCopy(File SourceFile, File TargetFile, boolean overWrite) {
        try {
            SourceFile = CommonFunctions.formatPath(SourceFile);
            TargetFile = CommonFunctions.formatPath(TargetFile);
            if (!SourceFile.isFile()) {
                return false;
            }
            if (SourceFile.getAbsolutePath().toLowerCase().equals(TargetFile.getAbsolutePath().toLowerCase())) {
                return true;
            }
            File theTmpParentDir = CommonFunctions.getParent(TargetFile);
            if (theTmpParentDir == null) {
                return false;
            }
            if (!theTmpParentDir.exists() && !theTmpParentDir.mkdirs()) {
                throw new IOException("Unable to create the directory\"" + theTmpParentDir.getAbsolutePath() + "\"");
            }
            theTmpParentDir = null;
            if (TargetFile.exists() && !overWrite) {
                return true;
            }
            CommonFunctions.byteFileCopyHelper(SourceFile.getAbsolutePath(), TargetFile.getAbsolutePath());
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    private static void byteFileCopyHelper(String SourceFile, String TargetFile) throws IOException {
        FileInputStream in = null;
        FileOutputStream out = null;
        byte[] buf = new byte[50000];
        int numBytesRead = 0;
        try {
            in = new FileInputStream(SourceFile);
            out = new FileOutputStream(TargetFile);
            while ((numBytesRead = in.read(buf)) != -1) {
                out.write(buf, 0, numBytesRead);
            }
            buf = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
            buf = null;
            throw throwable;
        }
        Object var6_8 = null;
        if (in != null) {
            in.close();
        }
        if (out != null) {
            out.close();
        }
        buf = null;
    }

    public static Hashtable parseFilePath(File file) {
        PathMap _theMap = FileLocation.getPathMap();
        String fullPathFileName = file.getAbsolutePath();
        Hashtable<String, String> pathAndName = new Hashtable<String, String>();
        Iterator theIterator = _theMap.getIterator();
        while (theIterator.hasNext()) {
            String libraryRoot = (String)theIterator.next();
            if (!fullPathFileName.toUpperCase().startsWith(libraryRoot.toUpperCase())) continue;
            String relativePath = new String();
            String fileName = null;
            String noRootPath = fullPathFileName.substring(libraryRoot.length(), fullPathFileName.length());
            StringTokenizer tokens = new StringTokenizer(noRootPath, File.separator);
            while (tokens.hasMoreElements()) {
                String theToken = tokens.nextToken();
                if (tokens.hasMoreElements()) {
                    relativePath = String.valueOf(relativePath) + theToken + File.separator;
                    continue;
                }
                fileName = new String(theToken);
            }
            pathAndName.put(RELATIVE_PATH, relativePath);
            pathAndName.put(FILE_NAME, fileName);
            break;
        }
        return pathAndName;
    }

    public static String getRelativePath(String pSource, String pTarget) {
        int position;
        if (pSource == null || pTarget == null) {
            return null;
        }
        String theSource = pSource.toLowerCase();
        String theTarget = pTarget.toLowerCase();
        StringBuffer theTmpBuffer = new StringBuffer(256);
        theTmpBuffer.append(theSource);
        int idx = 0;
        while (idx < theSource.length()) {
            if (theTmpBuffer.charAt(idx) == '\\') {
                theTmpBuffer.setCharAt(idx, '/');
            }
            ++idx;
        }
        theSource = theTmpBuffer.toString();
        theTmpBuffer.setLength(0);
        theTmpBuffer.append(theTarget);
        idx = 0;
        while (idx < theTarget.length()) {
            if (theTmpBuffer.charAt(idx) == '\\') {
                theTmpBuffer.setCharAt(idx, '/');
            }
            ++idx;
        }
        theTarget = theTmpBuffer.toString();
        theTmpBuffer.setLength(0);
        String[] srcArray = new String[20];
        String[] tarArray = new String[20];
        int srcIdx = 0;
        int tarIdx = 0;
        while ((position = theSource.indexOf("/")) != -1) {
            srcArray[srcIdx++] = theSource.substring(0, position);
            if (theSource.length() > ++position) {
                theSource = theSource.substring(position);
                continue;
            }
            theSource = null;
            break;
        }
        if (theSource != null) {
            srcArray[srcIdx++] = theSource;
        }
        while ((position = theTarget.indexOf("/")) != -1) {
            tarArray[tarIdx++] = theTarget.substring(0, position);
            if (theTarget.length() > ++position) {
                theTarget = theTarget.substring(position);
                continue;
            }
            theTarget = null;
            break;
        }
        if (theTarget != null) {
            tarArray[tarIdx++] = theTarget;
        }
        int maxIdx = Math.max(srcIdx, tarIdx);
        int idx2 = 0;
        while (idx2 < maxIdx) {
            if (!srcArray[idx2].equals(tarArray[idx2])) break;
            ++idx2;
        }
        int tmpIdx = idx2;
        while (tmpIdx < srcIdx - 1) {
            theTmpBuffer.append("../");
            ++tmpIdx;
        }
        while (idx2 < tarIdx) {
            theTmpBuffer.append(String.valueOf(tarArray[idx2++]) + "/");
        }
        if (theTmpBuffer.length() > 0) {
            theTmpBuffer.setLength(theTmpBuffer.length() - 1);
        }
        String theRtnValue = theTmpBuffer.toString();
        theTmpBuffer.setLength(0);
        theTmpBuffer = null;
        srcArray = null;
        tarArray = null;
        theSource = null;
        theTarget = null;
        return theRtnValue;
    }

    public static String buildPath(String pCurrentPath, String pRelativePath) {
        int position;
        if (pRelativePath.startsWith("file://")) {
            return pRelativePath;
        }
        if (pCurrentPath == null || pRelativePath == null) {
            return null;
        }
        StringBuffer theTmpBuffer = new StringBuffer(256);
        theTmpBuffer.append(pCurrentPath);
        int idx = 0;
        while (idx < pCurrentPath.length()) {
            if (theTmpBuffer.charAt(idx) == '\\') {
                theTmpBuffer.setCharAt(idx, '/');
            }
            ++idx;
        }
        pCurrentPath = theTmpBuffer.toString();
        theTmpBuffer.setLength(0);
        theTmpBuffer.append(pRelativePath);
        idx = 0;
        while (idx < pRelativePath.length()) {
            if (theTmpBuffer.charAt(idx) == '\\') {
                theTmpBuffer.setCharAt(idx, '/');
            }
            ++idx;
        }
        pRelativePath = theTmpBuffer.toString();
        String[] srcArray = new String[20];
        String[] tarArray = new String[20];
        int srcIdx = 0;
        int tarIdx = 0;
        while ((position = pCurrentPath.indexOf("/")) != -1) {
            srcArray[srcIdx++] = pCurrentPath.substring(0, position);
            if (pCurrentPath.length() > ++position) {
                pCurrentPath = pCurrentPath.substring(position);
                continue;
            }
            pCurrentPath = null;
            break;
        }
        if (pCurrentPath != null) {
            srcArray[srcIdx++] = pCurrentPath;
        }
        while ((position = pRelativePath.indexOf("/")) != -1) {
            tarArray[tarIdx++] = pRelativePath.substring(0, position);
            if (pRelativePath.length() > ++position) {
                pRelativePath = pRelativePath.substring(position);
                continue;
            }
            pRelativePath = null;
            break;
        }
        if (pRelativePath != null) {
            tarArray[tarIdx++] = pRelativePath;
        }
        int numSubDir = 0;
        int theIdx = 0;
        while (theIdx < tarIdx) {
            if (!tarArray[theIdx].equals("..")) break;
            ++numSubDir;
            ++theIdx;
        }
        StringBuffer theNewPath = new StringBuffer(256);
        int theIdx2 = 0;
        while (theIdx2 < srcIdx - numSubDir - 1) {
            theNewPath.append(String.valueOf(srcArray[theIdx2]) + File.separator);
            ++theIdx2;
        }
        theIdx2 = numSubDir;
        while (theIdx2 < tarIdx) {
            theNewPath.append(String.valueOf(tarArray[theIdx2]) + File.separator);
            ++theIdx2;
        }
        theNewPath.setLength(theNewPath.length() - 1);
        String theRtnValue = theNewPath.toString();
        theNewPath.setLength(0);
        theTmpBuffer.setLength(0);
        theTmpBuffer = null;
        theNewPath = null;
        srcArray = null;
        tarArray = null;
        return theRtnValue;
    }

    public static String getFileNameFromPath(String pPath) {
        String theRtnString = CommonFunctions.formatPath(pPath);
        int idx = theRtnString.lastIndexOf(File.separator);
        if (idx != -1) {
            theRtnString = theRtnString.substring(idx + 1);
        }
        return theRtnString;
    }

    public static int lexStringCompare(String firstArgument, String secondArgument) {
        Collator myCollator = Collator.getInstance(Locale.getDefault());
        return myCollator.compare(firstArgument, secondArgument);
    }

    public static boolean sortStringValues(Vector pArray) {
        Vector theSortedArray = new Vector(pArray.size());
        try {
            Enumeration theElements = pArray.elements();
            while (theElements.hasMoreElements()) {
                theSortedArray.addElement(theElements.nextElement());
            }
            CommonFunctions.stringMergeSort(theSortedArray, 0, theSortedArray.size() - 1);
        }
        catch (ClassCastException cce) {
            return false;
        }
        pArray = theSortedArray;
        return true;
    }

    private static void stringMergeSort(Vector pArray, int pLowerBound, int pHigherBound) throws ClassCastException {
        if (pLowerBound < pHigherBound) {
            int theMidPoint = (int)Math.floor((pHigherBound + pLowerBound) / 2);
            CommonFunctions.stringMergeSort(pArray, pLowerBound, theMidPoint);
            CommonFunctions.stringMergeSort(pArray, theMidPoint + 1, pHigherBound);
            CommonFunctions.stringMergeSortHelper(pArray, pLowerBound, theMidPoint, pHigherBound);
        }
    }

    private static void stringMergeSortHelper(Vector pArray, int pLowerBound, int pMidPoint, int pHigherBound) throws ClassCastException {
        int theLowerIdx = pLowerBound;
        block0: while (theLowerIdx < pMidPoint) {
            String theRightValue;
            String theLeftValue = (String)pArray.elementAt(theLowerIdx);
            if (CommonFunctions.lexStringCompare(theLeftValue, theRightValue = (String)pArray.elementAt(pMidPoint)) <= 0) continue;
            pArray.setElementAt(theRightValue, theLowerIdx);
            int tempIdx = pMidPoint + 1;
            while (tempIdx <= pHigherBound) {
                String theTestValue = (String)pArray.elementAt(tempIdx);
                if (CommonFunctions.lexStringCompare(theLeftValue, theTestValue) <= 0) {
                    pArray.setElementAt(theLeftValue, tempIdx - 1);
                    continue block0;
                }
                pArray.setElementAt(theTestValue, tempIdx - 1);
                if (++tempIdx <= pHigherBound) continue;
                pArray.setElementAt(theLeftValue, tempIdx);
            }
        }
    }

    public static String replaceString(String pSource, String pTarget, String pReplacement) {
        int idx;
        String theWorkingString = pSource;
        while ((idx = theWorkingString.indexOf(pTarget)) != -1) {
            theWorkingString = String.valueOf(theWorkingString.substring(0, idx)) + pReplacement + theWorkingString.substring(idx + pTarget.length());
        }
        return theWorkingString;
    }

    public static void CompleteGC() {
        try {
            System.gc();
            Thread.currentThread();
            Thread.sleep(100L);
            System.runFinalization();
            Thread.currentThread();
            Thread.sleep(100L);
            System.gc();
            Thread.currentThread();
            Thread.sleep(100L);
            System.runFinalization();
            Thread.currentThread();
            Thread.sleep(100L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static File getParent(File pFile) {
        File theNewFile = CommonFunctions.convertPathUsingDefaultPathSeparator(pFile);
        if (theNewFile == null) {
            return null;
        }
        theNewFile = new File(theNewFile.getParent());
        return theNewFile;
    }

    public static File convertPathUsingDefaultPathSeparator(File pFile) {
        String theTempPath = CommonFunctions.convertPathUsingDefaultPathSeparator(pFile.getAbsolutePath());
        if (theTempPath.equals("")) {
            return null;
        }
        File theNewFile = new File(theTempPath);
        return theNewFile;
    }

    public static String convertPathUsingDefaultPathSeparator(String pFile) {
        String theTempPath = "";
        theTempPath = File.separator.equals("\\") ? CommonFunctions.replaceString(pFile, "/", "\\") : CommonFunctions.replaceString(pFile, "\\", "/");
        return theTempPath;
    }

    public static String formatPath(String pFile) {
        String thePath = CommonFunctions.convertPathUsingDefaultPathSeparator(pFile);
        while (thePath.endsWith(File.separator)) {
            thePath = thePath.substring(0, thePath.length() - 1);
        }
        String theUNCPrefix = "";
        String theOS = System.getProperty("os.name").toUpperCase();
        if (theOS.indexOf("WINDOWS") != -1 && thePath.startsWith("\\\\") && thePath.indexOf(2) != 92) {
            theUNCPrefix = "\\\\";
        }
        String theDoubleChecker = String.valueOf(File.separator) + File.separator;
        while (thePath.indexOf(theDoubleChecker) != -1) {
            thePath = CommonFunctions.replaceString(thePath, theDoubleChecker, File.separator);
        }
        thePath = String.valueOf(theUNCPrefix) + thePath;
        return thePath;
    }

    public static File formatPath(File pFile) {
        String thePath = pFile.getAbsolutePath();
        thePath = CommonFunctions.formatPath(thePath);
        File theNewFile = new File(thePath);
        return theNewFile;
    }

    public static String formatLink(String pLink) {
        String theNewPath = CommonFunctions.replaceString(pLink, " ", "%20");
        return theNewPath;
    }

    public static String convertToFileURL(String path) {
        return path.replace('\\', '/');
    }

    public static boolean comparePaths(String pPath1, String pPath2) {
        String theOS = System.getProperty("os.name").toUpperCase();
        String theVersion = System.getProperty("os.version");
        int value = 0;
        try {
            Double version = new Double(theVersion);
            value = version.intValue();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (theOS.indexOf("WINDOWS") != -1) {
            pPath1 = pPath1.toLowerCase();
            pPath2 = pPath2.toLowerCase();
        }
        return pPath1.equals(pPath2);
    }
}

