/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.ui;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.epf.common.serviceability.MsgDialog;
import org.eclipse.epf.library.services.LibraryProcessor;
import org.eclipse.epf.library.ui.LibraryUIPlugin;
import org.eclipse.epf.library.ui.LibraryUIResources;
import org.eclipse.epf.library.ui.actions.ConfigurationContributionItem;
import org.eclipse.epf.library.ui.dialogs.OpenLibraryDialog;
import org.eclipse.epf.library.ui.dialogs.SelectLibraryDirectoryDialog;
import org.eclipse.epf.library.ui.preferences.LibraryUIPreferences;
import org.eclipse.jface.action.CoolBarManager;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.ToolBarContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.internal.WorkbenchWindow;

public class LibraryUIManager {
    private static final String TOOLBAR_DUMMY_CONTRIBUTION_ID = "toolbar.dummy.contribution";
    private static final String TOOLBAR_CONFIG_CONTRIBUTION_ID = "toolbar.config.contribution";
    private static final String OPEN_LIBRARY_TITLE = LibraryUIResources.getString("LibraryUI.openLibraryDialog.title");
    private static final String UPGRADE_LIBRARY_TITLE = LibraryUIResources.getString("LibraryUI.upgradeLibraryDialog.title");
    private static final String UPGRADE_LIBRARY_ERROR_MSG = LibraryUIResources.getString("LibraryUI.upgradeLibraryError.msg");
    private static LibraryUIManager instance = null;
    private static String cmdLineLibPath = null;
    static /* synthetic */ Class class$0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LibraryUIManager getInstance() {
        if (instance != null) return instance;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.epf.library.ui.LibraryUIManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (instance != null) return instance;
            instance = new LibraryUIManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private LibraryUIManager() {
        this.addConfigurationContribution();
    }

    public void promptForMethodLibrary() {
        String libPath = LibraryUIPreferences.getSavedLibraryPath();
        if ((libPath == null || libPath.length() == 0) && cmdLineLibPath != null) {
            libPath = cmdLineLibPath;
        }
        if (LibraryProcessor.isValidLibrary((String)libPath, (boolean)true) == Status.OK_STATUS && !LibraryUIPreferences.getPromptForMethodLibraryAtStartup() && !LibraryProcessor.getInstance().isLibraryLocked(libPath)) {
            this.openLibrary(libPath);
            return;
        }
        if (LibraryProcessor.isValidLibrary((String)libPath) != Status.OK_STATUS) {
            libPath = LibraryUIPreferences.getDefaultLibraryPath();
        }
        Shell shell = Display.getCurrent().getActiveShell();
        OpenLibraryDialog dialog = new OpenLibraryDialog(shell, libPath);
        while (dialog.open() == 0) {
            libPath = dialog.getLibraryPath();
            if (LibraryProcessor.isValidLibrary((String)(libPath = LibraryUIManager.toAbsoluteLibraryPath(libPath)), (boolean)true) == Status.OK_STATUS) {
                if (LibraryProcessor.getInstance().isLibraryLocked(libPath) && LibraryUIManager.displayLibraryLockedMessage() != 0) continue;
                LibraryProcessor.getLibraryModelFile((String)libPath);
                if (this.openLibrary(libPath)) {
                    return;
                }
            } else {
                MsgDialog msgDialog = LibraryUIPlugin.getDefault().getMsgDialog();
                boolean rc = msgDialog.displayConfirmation(LibraryUIResources.getString("LibraryUI.openLibraryDialog.title"), LibraryUIResources.formatString("LibraryUI.openLibraryDialog.newLibrary.text", libPath));
                if (!rc) continue;
                if (this.createLibrary(libPath)) {
                    return;
                }
            }
            LibraryUIPlugin.getDefault().getMsgDialog().displayError(OPEN_LIBRARY_TITLE, LibraryUIResources.getString("LibraryUI.invalidLibraryPathError.msg"), LibraryUIResources.getString("LibraryUI.invalidLibraryPathError.reason"));
        }
        System.exit(0);
    }

    public void openLibrary() {
        SelectLibraryDirectoryDialog dialog = new SelectLibraryDirectoryDialog(Display.getCurrent().getActiveShell());
        String libPath = LibraryUIPreferences.getSavedLibraryPath();
        dialog.setFilterPath(libPath);
        do {
            if ((libPath = dialog.open()) == null) {
                return;
            }
            if (LibraryProcessor.isValidLibrary((String)libPath, (boolean)true) == Status.OK_STATUS) {
                if (LibraryProcessor.getInstance().isLibraryLocked(libPath) && LibraryUIManager.displayLibraryLockedMessage() != 0) continue;
                LibraryProcessor.getLibraryModelFile((String)libPath);
                if (this.openLibrary(libPath)) {
                    return;
                }
            }
            MsgDialog msgDialog = LibraryUIPlugin.getDefault().getMsgDialog();
            msgDialog.displayError(OPEN_LIBRARY_TITLE, LibraryUIResources.getString("LibraryUI.invalidLibraryPathError.msg"), LibraryUIResources.getString("LibraryUI.invalidLibraryPathError.reason"));
        } while (libPath != null);
    }

    public boolean openLibrary(final String path) {
        Shell shell = Display.getCurrent().getActiveShell();
        final String libFile = LibraryProcessor.getLibraryModelFile((String)path);
        final ArrayList errors = new ArrayList();
        final IStatus[] status = new IStatus[1];
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void execute(IProgressMonitor monitor) {
                String taskText = LibraryUIResources.getString("LibraryUI.openingLibraryTask.name");
                monitor.beginTask(taskText, 2);
                try {
                    try {
                        monitor.setTaskName(taskText);
                        monitor.worked(1);
                        status[0] = LibraryProcessor.getInstance().openLibrary(libFile);
                        LibraryUIPreferences.setSavedLibraryPath(path);
                    }
                    catch (Exception e) {
                        if (!(e instanceof IOException) || !e.getMessage().startsWith("###")) {
                            LibraryUIPlugin.getDefault().getLogger().logError((Throwable)e);
                        }
                        errors.add(e);
                    }
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    monitor.done();
                    throw throwable;
                }
                {
                    Object var4_6 = null;
                }
                monitor.done();
            }
        };
        try {
            ProgressMonitorDialog dialog = new ProgressMonitorDialog(shell){

                protected void configureShell(Shell shell) {
                    super.configureShell(shell);
                    shell.setText(OPEN_LIBRARY_TITLE);
                }
            };
            dialog.run(true, false, (IRunnableWithProgress)operation);
            if (errors.isEmpty()) {
                IWorkbenchPage activePage;
                IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (workbenchWindow != null && (activePage = workbenchWindow.getActivePage()) != null) {
                    activePage.closeAllEditors(false);
                }
                return true;
            }
            Iterator iter = errors.iterator();
            while (iter.hasNext()) {
                String message;
                Exception e = (Exception)iter.next();
                if (!(e instanceof IOException) || !(message = e.getMessage()).startsWith("###")) continue;
                String projectFileName = message.substring(3);
                String prompt = LibraryUIResources.formatString("LibraryUI.readOnlyProjectFile.text", projectFileName);
                String[] buttonLabels = new String[]{LibraryUIResources.getString("LibraryUI.retryButton.text"), LibraryUIResources.getString("LibraryUI.cancelButton.text")};
                MessageDialog msgBox = new MessageDialog(Display.getCurrent().getActiveShell(), OPEN_LIBRARY_TITLE, null, prompt, 4, buttonLabels, 0);
                if (msgBox.open() == 0) {
                    return this.openLibrary(path);
                }
                return true;
            }
        }
        catch (Exception e) {
            LibraryUIPlugin.getDefault().getLogger().logError((Throwable)e);
        }
        return false;
    }

    public boolean createLibrary(String path) {
        try {
            File libraryPath = new File(path);
            if (!libraryPath.exists()) {
                libraryPath.mkdirs();
            }
            LibraryProcessor.getInstance().newLibrary(libraryPath.getName(), path, true);
            LibraryUIPreferences.setSavedLibraryPath(path);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void addConfigurationContribution() {
        WorkbenchWindow window;
        IWorkbench workbench = LibraryUIPlugin.getDefault().getWorkbench();
        if (workbench != null && (window = (WorkbenchWindow)workbench.getActiveWorkbenchWindow()) != null) {
            CoolBarManager coolBar = window.getCoolBarManager();
            IContributionItem marker = null;
            IContributionItem coolBarItem = coolBar.find(TOOLBAR_CONFIG_CONTRIBUTION_ID);
            if (coolBarItem != null) {
                if (coolBarItem.isVisible()) {
                    return;
                }
                IContributionItem[] items = coolBar.getItems();
                int i = 0;
                while (i < items.length) {
                    if (items[i] == coolBarItem) {
                        coolBar.remove(TOOLBAR_CONFIG_CONTRIBUTION_ID);
                        if (i + 1 < items.length) {
                            marker = items[i + 1];
                        }
                    }
                    ++i;
                }
            }
            ToolBarManager toolbarMgr = new ToolBarManager(0x804000);
            ConfigurationContributionItem testItem = new ConfigurationContributionItem(null);
            toolbarMgr.add((IContributionItem)testItem);
            ToolBarContributionItem contribItem = new ToolBarContributionItem((IToolBarManager)toolbarMgr, TOOLBAR_CONFIG_CONTRIBUTION_ID);
            if (marker != null) {
                coolBar.insertBefore(marker.getId(), (IContributionItem)contribItem);
            } else {
                coolBar.add((IContributionItem)contribItem);
            }
        }
    }

    public static String getCommandLineLibraryPath() {
        return cmdLineLibPath;
    }

    public static void setCommandLineLibraryPath(String libPath) {
        IPath path = Path.fromOSString((String)libPath);
        if (!path.isAbsolute()) {
            cmdLineLibPath = String.valueOf(System.getProperty("user.dir")) + File.separator + libPath;
        }
        if (LibraryProcessor.isValidLibrary((String)cmdLineLibPath, (boolean)true) != Status.OK_STATUS) {
            cmdLineLibPath = null;
        }
    }

    public static String toAbsoluteLibraryPath(String libPath) {
        String absPath = libPath;
        IPath ecPath = Path.fromOSString((String)libPath);
        if (!ecPath.isAbsolute()) {
            absPath = String.valueOf(System.getProperty("user.dir")) + File.separator + "Method Libraries" + File.separator + libPath;
        }
        return absPath;
    }

    private static int displayLibraryLockedMessage() {
        Shell shell = null;
        Image image = null;
        try {
            shell = LibraryUIPlugin.getDefault().getWorkbench().getDisplay().getActiveShell();
            image = shell.getImage();
        }
        catch (Exception exception) {}
        MessageDialog msgDlg = new MessageDialog(shell, OPEN_LIBRARY_TITLE, image, LibraryUIResources.getString("LibraryUI.libraryLocked.msg"), 1, new String[]{LibraryUIResources.getString("LibraryUI.libraryLocked.openButton"), IDialogConstants.CANCEL_LABEL}, 1);
        return msgDlg.open();
    }
}

