/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.ui.actions;

import com.ibm.uma.MethodConfiguration;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.epf.library.LibraryPlugin;
import org.eclipse.epf.library.events.ILibraryChangeListener;
import org.eclipse.epf.library.services.LibraryProcessor;
import org.eclipse.epf.library.services.SafeUpdateController;
import org.eclipse.epf.library.ui.LibraryUIResources;
import org.eclipse.jface.action.ControlContribution;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ConfigurationContribution
extends ControlContribution
implements SelectionListener,
FocusListener {
    public static final String CONTRIBUTION_ID;
    private static final String SELECT_CONFIGURATION;
    private static Combo configCombo;
    private ILibraryChangeListener libListener;
    private static boolean needUpdate;
    private static boolean needCleanList;
    private static boolean needSpecialUpdare;
    private static String currentSelectconfig;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.epf.library.ui.actions.ConfigurationContribution");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        CONTRIBUTION_ID = clazz.getName();
        SELECT_CONFIGURATION = LibraryUIResources.getString("LibraryUI.selectConfigLabel.text");
        needUpdate = false;
        needCleanList = false;
        needSpecialUpdare = false;
    }

    public ConfigurationContribution() {
        super(CONTRIBUTION_ID);
    }

    protected Control createControl(Composite parent) {
        configCombo = new Combo(parent, 12);
        configCombo.setVisibleItemCount(10);
        configCombo.addSelectionListener((SelectionListener)this);
        configCombo.addFocusListener((FocusListener)this);
        this.libListener = new ILibraryChangeListener(){

            public void libraryChanged(int option, Collection changedItems) {
                if (option == 64) {
                    String currentConfig = LibraryProcessor.getInstance().getCurrentConfiguration();
                    ConfigurationContribution.this.selectConfiguration(currentConfig);
                } else {
                    if (option == 4 || option == 1) {
                        needCleanList = true;
                        needUpdate = true;
                        ConfigurationContribution.updateComboListSpecial();
                    } else if ((option == 8 || option == 16) && changedItems != null) {
                        Iterator it = changedItems.iterator();
                        while (it.hasNext()) {
                            Object element = it.next();
                            if (!(element instanceof MethodConfiguration)) continue;
                            needUpdate = true;
                            if (option != 16 || !((MethodConfiguration)element).getName().equals(currentSelectconfig)) break;
                            needSpecialUpdare = true;
                            break;
                        }
                    }
                    if (needSpecialUpdare) {
                        ConfigurationContribution.updateComboListSpecial();
                        needSpecialUpdare = false;
                    }
                }
            }
        };
        LibraryProcessor.getInstance().addListener(this.libListener);
        LibraryProcessor lp = LibraryProcessor.getInstance();
        String[] configNames = lp.getConfigurationNames();
        int lastSessionConfigIdx = ConfigurationContribution.chooseSelectedIdex(configNames);
        if (configNames != null && configNames.length > 0) {
            if (lastSessionConfigIdx < 0) {
                configCombo.add(SELECT_CONFIGURATION);
            }
            int i = 0;
            while (i < configNames.length) {
                String configName = configNames[i];
                if (configName != null) {
                    configCombo.add(configName);
                }
                ++i;
            }
        } else {
            configCombo.add(SELECT_CONFIGURATION);
        }
        if (lastSessionConfigIdx < 0) {
            configCombo.select(0);
        } else {
            configCombo.select(lastSessionConfigIdx);
            currentSelectconfig = ConfigurationContribution.getSavedLastConfig();
            ConfigurationContribution.performSelectionChanged();
        }
        configCombo.setEnabled(true);
        return configCombo;
    }

    public void focusGained(FocusEvent e) {
        if (needUpdate) {
            ConfigurationContribution.updateComboList();
            needUpdate = false;
        }
    }

    public void focusLost(FocusEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        int selectedIndex = configCombo.getSelectionIndex();
        if (selectedIndex > 0 && configCombo.getItem(0).equals(SELECT_CONFIGURATION)) {
            configCombo.remove(0);
            configCombo.select(selectedIndex - 1);
        }
        int currentIndex = configCombo.getSelectionIndex();
        currentSelectconfig = configCombo.getItem(currentIndex);
        ConfigurationContribution.performSelectionChanged();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    private static void updateComboList() {
        SafeUpdateController.asyncExec((Runnable)new Runnable(){

            public void run() {
                try {
                    if (configCombo.isDisposed() || configCombo == null) {
                        return;
                    }
                    if (needCleanList) {
                        configCombo.removeAll();
                        needCleanList = false;
                    }
                    int index = configCombo.getSelectionIndex();
                    String currentSelection = "";
                    if (index >= 0) {
                        currentSelection = configCombo.getItem(index);
                    }
                    index = -1;
                    configCombo.setEnabled(true);
                    LibraryProcessor lp = LibraryProcessor.getInstance();
                    String[] configNames = lp.getConfigurationNames();
                    configCombo.removeAll();
                    if (configNames != null && configNames.length > 0) {
                        int i = 0;
                        while (i < configNames.length) {
                            String configName = configNames[i];
                            if (configName != null) {
                                configCombo.add(configName);
                                if (configName.equals(currentSelection)) {
                                    index = i;
                                }
                            }
                            ++i;
                        }
                    } else {
                        index = 0;
                        configCombo.add(SELECT_CONFIGURATION);
                        configCombo.select(0);
                    }
                    if (index >= 0) {
                        configCombo.select(index);
                    }
                    if (index == -1) {
                        configCombo.add(SELECT_CONFIGURATION, 0);
                        configCombo.select(0);
                    }
                    int currentIdx = configCombo.getSelectionIndex();
                    currentSelectconfig = configCombo.getItem(currentIdx);
                    configCombo.setVisibleItemCount(10);
                    ConfigurationContribution.performSelectionChanged();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private static void updateComboListSpecial() {
        SafeUpdateController.asyncExec((Runnable)new Runnable(){

            public void run() {
                if (needCleanList) {
                    configCombo.removeAll();
                    currentSelectconfig = null;
                }
                try {
                    if (currentSelectconfig != null) {
                        configCombo.remove(currentSelectconfig);
                    }
                    configCombo.add(SELECT_CONFIGURATION, 0);
                    configCombo.select(0);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void selectConfiguration(String cfgName) {
        if (cfgName.equals(currentSelectconfig)) {
            return;
        }
        int currentIdx = configCombo.getSelectionIndex();
        String currentName = "";
        if (currentIdx >= 0) {
            currentName = configCombo.getItem(currentIdx);
        }
        if (!currentName.equals(cfgName)) {
            int selectIndex = -1;
            int i = 0;
            while (i < configCombo.getItemCount()) {
                if (configCombo.getItem(i).equals(cfgName)) {
                    selectIndex = i;
                    break;
                }
                ++i;
            }
            if (selectIndex > 0 && configCombo.getItem(0).equals(SELECT_CONFIGURATION)) {
                configCombo.remove(0);
                --selectIndex;
            }
            if (selectIndex != -1) {
                configCombo.select(selectIndex);
            }
            currentIdx = configCombo.getSelectionIndex();
            currentSelectconfig = configCombo.getItem(currentIdx);
            ConfigurationContribution.performSelectionChanged();
        }
    }

    private static void performSelectionChanged() {
        LibraryProcessor lp = LibraryProcessor.getInstance();
        lp.getConfigurationFactory().setCurrentConfiguration(currentSelectconfig);
        lp.setCurrentConfiguration(currentSelectconfig);
        ConfigurationContribution.saveSelectedConfigIntoPersistence();
    }

    private static int chooseSelectedIdex(String[] configNames) {
        int index = -1;
        String lastSessionConfig = ConfigurationContribution.getSavedLastConfig();
        if (lastSessionConfig != null) {
            int i = 0;
            while (i < configNames.length) {
                if (lastSessionConfig.equals(configNames[i])) {
                    index = i;
                    break;
                }
                ++i;
            }
        }
        return index;
    }

    private static void saveSelectedConfigIntoPersistence() {
        IPreferenceStore store = LibraryPlugin.getDefault().getPreferenceStore();
        store.setValue("org.eclipse.epf.library.pref.selected_config_in_last_session", currentSelectconfig);
        LibraryPlugin.getDefault().savePluginPreferences();
    }

    private static String getSavedLastConfig() {
        IPreferenceStore store = LibraryPlugin.getDefault().getPreferenceStore();
        return store.getString("org.eclipse.epf.library.pref.selected_config_in_last_session");
    }
}

