/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.richtext;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.epf.richtext.IRichText;
import org.eclipse.epf.richtext.IRichTextToolBar;
import org.eclipse.epf.richtext.actions.IRichTextAction;
import org.eclipse.epf.richtext.actions.IRichTextComboAction;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class RichTextToolBar
extends Composite
implements IRichTextToolBar {
    private static final String LAST_KEY_CODE = "lastKeyCode";
    private IRichText richText;
    private boolean addToolBar = true;
    private ToolBar currentToolBar;
    private List actionItems = new ArrayList();

    public RichTextToolBar(Composite parent, int style, IRichText richText) {
        super(parent, style);
        this.richText = richText;
        GridLayout layout = new GridLayout(10, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        super.setLayout((Layout)layout);
    }

    public void addAction(final IRichTextAction action) {
        if (action != null) {
            this.addToolBar();
            ToolItem item = new ToolItem(this.currentToolBar, 0);
            item.setImage(action.getImage());
            item.setToolTipText(action.getToolTipText());
            item.setEnabled(action.getEnabled());
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    action.execute(RichTextToolBar.this.richText);
                }
            });
            this.actionItems.add(item);
        }
    }

    public void addAction(final IRichTextComboAction action) {
        if (action != null) {
            Combo combo = new Combo((Composite)this, 0x800008);
            String[] items = action.getItems();
            int i = 0;
            while (i < items.length) {
                combo.add(items[i]);
                ++i;
            }
            combo.setVisibleItemCount(combo.getItemCount());
            combo.select(0);
            combo.setToolTipText(action.getToolTipText());
            combo.setEnabled(action.getEnabled());
            combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    Object eventSrc;
                    String lastKeyCode = (String)RichTextToolBar.this.getData(RichTextToolBar.LAST_KEY_CODE);
                    if ((lastKeyCode == null || lastKeyCode.equals("\r")) && (eventSrc = event.getSource()) instanceof Combo) {
                        action.execute(RichTextToolBar.this.richText, ((Combo)eventSrc).getSelectionIndex());
                    }
                    RichTextToolBar.this.setData(RichTextToolBar.LAST_KEY_CODE, null);
                }
            });
            combo.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent event) {
                    Object eventSrc;
                    if (event.keyCode == 13 && (eventSrc = event.getSource()) instanceof Combo) {
                        action.execute(RichTextToolBar.this.richText, ((Combo)eventSrc).getSelectionIndex());
                    }
                    RichTextToolBar.this.setData(RichTextToolBar.LAST_KEY_CODE, "" + event.keyCode);
                }
            });
            this.actionItems.add(combo);
            this.addToolBar = true;
        }
    }

    public void addSeparator() {
        this.addToolBar();
        new ToolItem(this.currentToolBar, 2);
    }

    public void setRichTextToolItemsEnabled(boolean enabled) {
        Iterator i = this.actionItems.iterator();
        while (i.hasNext()) {
            Object item = i.next();
            if (item instanceof ToolItem) {
                ((ToolItem)item).setEnabled(enabled);
                continue;
            }
            if (!(item instanceof Combo)) continue;
            ((Combo)item).setEnabled(enabled);
        }
    }

    protected void addToolBar() {
        if (this.addToolBar) {
            this.currentToolBar = new ToolBar((Composite)this, this.getStyle());
            this.currentToolBar.setLayout((Layout)new FillLayout());
            this.addToolBar = false;
        }
    }
}

