/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.richtext.actions;

import org.eclipse.epf.richtext.IRichText;
import org.eclipse.epf.richtext.RichTextImages;
import org.eclipse.epf.richtext.RichTextPlugin;
import org.eclipse.epf.richtext.RichTextResources;
import org.eclipse.epf.richtext.actions.RichTextAction;
import org.eclipse.epf.richtext.dialogs.FindReplaceDialog;
import org.eclipse.swt.widgets.Display;

public class FindReplaceAction
extends RichTextAction {
    public static final int FIND_TEXT = 1;
    public static final int REPLACE_TEXT = 2;
    public static final int REPLACE_FIND_TEXT = 3;
    public static final int REPLACE_ALL_TEXT = 4;
    public static final int FORWARD_MATCH = 1;
    public static final int BACKWARD_MATCH = -1;
    public static final int WHOLE_WORD_MATCH = 2;
    public static final int CASE_SENSITIVE_MATCH = 4;
    private static final String ENCODED_SINGLE_QUOTE = "%sq%";
    private IRichText richText;
    protected boolean foundMatch = false;

    public FindReplaceAction() {
        this.setImage(RichTextImages.IMG_FIND_REPLACE);
        this.setToolTipText(RichTextResources.getString("RichText.findReplaceAction.toolTipText"));
        this.setEnabled(true);
    }

    public void execute(IRichText richText) {
        this.richText = richText;
        if (richText != null) {
            try {
                FindReplaceDialog dialog = new FindReplaceDialog(Display.getCurrent().getActiveShell(), this);
                dialog.open();
            }
            catch (Exception e) {
                RichTextPlugin.getDefault().getLogger().logError((Throwable)e);
            }
        }
    }

    public boolean getFoundMatch() {
        return this.foundMatch;
    }

    public void run(int subAction, String findText, String replaceText, int matchDir, int matchOptions) {
        if (findText.indexOf("'") != -1) {
            findText = findText.replaceAll("'", ENCODED_SINGLE_QUOTE);
        }
        if (replaceText.indexOf("'") != -1) {
            replaceText = replaceText.replaceAll("'", ENCODED_SINGLE_QUOTE);
        }
        try {
            this.foundMatch = false;
            int status = 0;
            switch (subAction) {
                case 1: {
                    status = this.richText.executeCommand("findText", new String[]{findText, "" + matchDir, "" + matchOptions});
                    break;
                }
                case 2: {
                    status = this.richText.executeCommand("replaceText", new String[]{replaceText, "" + matchDir, "" + matchOptions});
                    break;
                }
                case 3: {
                    this.richText.executeCommand("replaceText", new String[]{replaceText, "" + matchDir, "" + matchOptions});
                    status = this.richText.executeCommand("findText", new String[]{findText, "" + matchDir, "" + matchOptions});
                    break;
                }
                case 4: {
                    this.richText.executeCommand("replaceAllText", new String[]{FindReplaceAction.escape(findText), FindReplaceAction.escape(replaceText), "" + matchOptions});
                }
            }
            if (status > 0) {
                this.foundMatch = true;
            }
        }
        catch (Exception e) {
            RichTextPlugin.getDefault().getLogger().logError((Throwable)e);
        }
    }

    private static String escape(String text) {
        if (text == null || text.length() == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        int textSize = text.length();
        int i = 0;
        while (i < textSize) {
            char ch = text.charAt(i);
            switch (ch) {
                case '<': {
                    sb.append("&lt;");
                    break;
                }
                case '>': {
                    sb.append("&gt;");
                    break;
                }
                case '&': {
                    sb.append("&amp;");
                    break;
                }
                default: {
                    sb.append(ch);
                }
            }
            ++i;
        }
        return sb.toString();
    }
}

