/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.richtext.actions;

import org.eclipse.epf.richtext.RichTextPlugin;
import org.eclipse.epf.richtext.actions.FindReplaceAction;
import org.eclipse.epf.richtext.dialogs.FindReplaceDialog;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;

public class HTMLFindReplaceAction
extends FindReplaceAction {
    protected StyledText styledText;

    public void execute(StyledText styledText) {
        this.styledText = styledText;
        if (styledText != null) {
            try {
                FindReplaceDialog dialog = new FindReplaceDialog(Display.getCurrent().getActiveShell(), this);
                dialog.open();
            }
            catch (Exception e) {
                RichTextPlugin.getDefault().getLogger().logError((Throwable)e);
            }
        }
    }

    public void run(int subAction, String findText, String replaceText, int matchDir, int matchOptions) {
        try {
            this.foundMatch = false;
            int status = 0;
            switch (subAction) {
                case 1: {
                    if (this.findTextAndSelect(findText, matchDir, matchOptions) != -1) {
                        status = 1;
                    }
                    if (status != 0 || !this.styledText.getSelectionText().equals(findText)) break;
                    status = 1;
                    break;
                }
                case 2: {
                    this.replaceTextAndSelect(replaceText);
                    status = 1;
                    break;
                }
                case 3: {
                    this.replaceTextAndSelect(replaceText);
                    if (this.findTextAndSelect(findText, matchDir, matchOptions) != -1) {
                        status = 1;
                    }
                    if (status != 0 || !this.styledText.getSelectionText().equals(findText)) break;
                    status = 1;
                    break;
                }
                case 4: {
                    this.replaceAll(findText, replaceText, matchOptions);
                }
            }
            if (status > 0) {
                this.foundMatch = true;
            }
        }
        catch (Exception e) {
            RichTextPlugin.getDefault().getLogger().logError((Throwable)e);
        }
    }

    private int findTextAndSelect(String findText, int matchDir, int matchOptions) {
        Point selectionOffset = this.styledText.getSelectionRange();
        int firstSelectedOffset = selectionOffset.x;
        int lastSelectedOffset = selectionOffset.x + selectionOffset.y - 1;
        String htmlText = this.styledText.getText();
        int indexOfMatch = -1;
        if ((matchOptions & 4) == 0) {
            htmlText = htmlText.toUpperCase();
            findText = findText.toUpperCase();
        }
        do {
            if (indexOfMatch == -1) continue;
            lastSelectedOffset = indexOfMatch + 1;
            firstSelectedOffset = indexOfMatch - 1;
        } while ((indexOfMatch = matchDir == 1 ? htmlText.indexOf(findText, lastSelectedOffset) : htmlText.lastIndexOf(findText, firstSelectedOffset - 1)) != -1 && (matchOptions & 2) == 2 && this.isPartOfWord(htmlText, indexOfMatch, findText.length()));
        if (indexOfMatch != -1) {
            this.styledText.setSelectionRange(indexOfMatch, findText.length());
            this.styledText.showSelection();
        }
        return indexOfMatch;
    }

    private void replaceTextAndSelect(String replaceText) {
        Point selectionOffset = this.styledText.getSelectionRange();
        this.styledText.replaceTextRange(selectionOffset.x, selectionOffset.y, replaceText);
        this.styledText.setSelectionRange(selectionOffset.x, replaceText.length());
    }

    private void replaceAll(String findText, String replaceText, int matchOptions) {
        this.styledText.setSelectionRange(0, 0);
        while (this.findTextAndSelect(findText, 1, matchOptions) != -1) {
            this.replaceTextAndSelect(replaceText);
        }
    }

    private boolean isWordChar(char c) {
        return Character.isLetterOrDigit(c);
    }

    private boolean isPartOfWord(String text, int index, int length) {
        if (index > 0 && this.isWordChar(text.charAt(index - 1))) {
            return true;
        }
        return text.length() >= index + length && this.isWordChar(text.charAt(index + length));
    }
}

