/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.richtext.actions;

import java.io.File;
import java.net.URI;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.epf.common.utils.FileUtil;
import org.eclipse.epf.common.utils.NetUtil;
import org.eclipse.epf.richtext.IRichText;
import org.eclipse.epf.richtext.RichTextImages;
import org.eclipse.epf.richtext.RichTextPlugin;
import org.eclipse.epf.richtext.RichTextResources;
import org.eclipse.epf.richtext.actions.RichTextAction;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.HTMLTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;

public class PasteAction
extends RichTextAction {
    private static final String SOURCE_URL = "SourceURL:";
    private static final Pattern HTML_FRAGMENT = Pattern.compile("<!--StartFragment\\s*-->(.*?)<!--EndFragment-->", 34);
    private static final String HTM_EXT = ".htm";
    private static final String HTML_EXT = ".html";
    private static final String RELATIVE_FILE_URI_PREFIX = "file://.";
    private static final int RELATIVE_FILE_URI_PREFIX_LENGTH = "file://.".length();
    private static final Pattern HREF_REFERENCES = Pattern.compile("href\\s*=\\s*\"(.*?)\"", 34);
    private static final Pattern SRC_REFERENCES = Pattern.compile("src\\s*=\\s*\"(.*?)\"", 34);
    private static boolean debug = RichTextPlugin.getDefault().isDebugging();

    public PasteAction() {
        this.setImage(RichTextImages.IMG_PASTE);
        this.setToolTipText(RichTextResources.getString("RichText.pasteAction.toolTipText"));
        this.setEnabled(true);
    }

    public void execute(IRichText richText) {
        if (richText != null) {
            Clipboard clipboard = new Clipboard(Display.getCurrent());
            HTMLTransfer htmlTransfer = HTMLTransfer.getInstance();
            String htmlContent = null;
            try {
                Object content = clipboard.getContents((Transfer)htmlTransfer);
                if (content != null && content instanceof String) {
                    htmlContent = new String(((String)content).getBytes(), "UTF-8");
                }
            }
            catch (Exception exception) {
                htmlContent = null;
            }
            if (htmlContent != null && htmlContent.length() > 0) {
                String sourceURL = this.getSourceURL(htmlContent);
                String htmlSource = this.getHTMLSource(htmlContent);
                if (htmlSource != null) {
                    String html = this.processLinks(htmlSource, sourceURL, richText.getBasePath());
                    richText.executeCommand("addHTML", html);
                    html = richText.getText();
                    html = PasteAction.removeAbsolutePaths(html, sourceURL, richText.getBasePath());
                    richText.setText(html);
                    richText.setModified(true);
                }
            } else {
                richText.executeCommand("paste");
            }
            clipboard.dispose();
        }
    }

    protected String getSourceURL(String htmlContent) {
        String sourceURL = null;
        int sourceURLIndex = htmlContent.indexOf(SOURCE_URL);
        if (sourceURLIndex > 0) {
            sourceURL = htmlContent.substring(sourceURLIndex + SOURCE_URL.length());
            if ((sourceURL = sourceURL.substring(0, sourceURL.indexOf(FileUtil.LINE_SEP))).toLowerCase().endsWith(HTM_EXT) || sourceURL.toLowerCase().endsWith(HTML_EXT)) {
                sourceURL = sourceURL.substring(0, sourceURL.indexOf(FileUtil.getFileName((String)sourceURL)) - 1);
                sourceURL = sourceURL.replace('\\', '/');
            }
            sourceURL = FileUtil.appendSeparator((String)sourceURL, (String)"/");
        }
        return sourceURL;
    }

    protected String getHTMLSource(String htmlContent) {
        String htmlSource = null;
        Matcher matcher = HTML_FRAGMENT.matcher(htmlContent);
        if (matcher.find()) {
            htmlSource = matcher.group(1);
        }
        return htmlSource;
    }

    protected String processLinks(String html, String sourceURL, String basePath) {
        try {
            File tgtFile;
            File srcFile;
            String url;
            String scheme;
            String name;
            if (sourceURL == null) {
                return html;
            }
            if (sourceURL.equals("")) {
                sourceURL = basePath;
            }
            URI sourceURI = new URI(NetUtil.encodeFileURL((String)sourceURL));
            StringBuffer result = new StringBuffer();
            Matcher matcher = HREF_REFERENCES.matcher(html);
            while (matcher.find()) {
                String href = matcher.group(1);
                if (href.toLowerCase().endsWith(HTM_EXT) || href.toLowerCase().endsWith(HTML_EXT)) {
                    name = FileUtil.getFileName((String)href);
                    URI hrefURI = sourceURI.resolve(href);
                    scheme = hrefURI.getScheme();
                    if (scheme.equalsIgnoreCase("http")) {
                        url = hrefURI.toString();
                        matcher.appendReplacement(result, "href=\"" + url + "\"");
                        continue;
                    }
                    if (!scheme.equalsIgnoreCase("file")) continue;
                    url = hrefURI.getPath();
                    srcFile = new File(url);
                    tgtFile = new File(String.valueOf(basePath) + "resources");
                    tgtFile.mkdirs();
                    FileUtil.copyFile((File)srcFile, (File)tgtFile);
                    matcher.appendReplacement(result, "href=\"resources/" + name + "\"");
                    continue;
                }
                int anchorTagIndex = href.indexOf(35);
                if (anchorTagIndex <= 0) continue;
                String anchorTag = href.substring(anchorTagIndex);
                matcher.appendReplacement(result, "href=\"" + anchorTag + "\"");
            }
            matcher.appendTail(result);
            html = result.toString();
            result = new StringBuffer(2048);
            matcher = SRC_REFERENCES.matcher(html);
            while (matcher.find()) {
                String src = matcher.group(1);
                name = FileUtil.getFileName((String)src);
                URI srcURI = sourceURI.resolve(src);
                scheme = srcURI.getScheme();
                if (scheme == null) continue;
                if (scheme.equalsIgnoreCase("http")) {
                    url = srcURI.toString();
                    matcher.appendReplacement(result, "src=\"" + url + "\"");
                    continue;
                }
                if (!scheme.equalsIgnoreCase("file")) continue;
                url = srcURI.getPath();
                srcFile = new File(url);
                tgtFile = new File(String.valueOf(basePath) + "resources");
                tgtFile.mkdirs();
                FileUtil.copyFile((File)srcFile, (File)tgtFile);
                matcher.appendReplacement(result, "src=\"resources/" + name + "\"");
            }
            matcher.appendTail(result);
            return result.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return html;
        }
    }

    public static String removeAbsolutePaths(String html, String sourceURL, String basePath) {
        try {
            if (sourceURL == null) {
                return html;
            }
            if (sourceURL.equals("")) {
                sourceURL = "file:/" + basePath;
            }
            URI sourceURI = new URI(NetUtil.encodeFileURL((String)sourceURL));
            StringBuffer result = new StringBuffer(2048);
            Matcher matcher = HREF_REFERENCES.matcher(html);
            while (matcher.find()) {
                String href = matcher.group(1);
                if (href.toLowerCase().endsWith(HTM_EXT) || href.toLowerCase().endsWith(HTML_EXT)) {
                    String name = FileUtil.getFileName((String)href);
                    String url = NetUtil.resolveUri((String)href, (String)sourceURL);
                    if (url.toLowerCase().startsWith("http://")) {
                        matcher.appendReplacement(result, "href=\"" + url + "\"");
                        continue;
                    }
                    if (url.toLowerCase().startsWith(RELATIVE_FILE_URI_PREFIX)) {
                        matcher.appendReplacement(result, "href=\"" + url.substring(RELATIVE_FILE_URI_PREFIX_LENGTH - 1) + "\"");
                        continue;
                    }
                    if (!url.toLowerCase().startsWith("file:/")) continue;
                    matcher.appendReplacement(result, "href=\"resources/" + name + "\"");
                    continue;
                }
                int anchorTagIndex = href.indexOf(35);
                if (anchorTagIndex <= 0) continue;
                String anchorTag = href.substring(anchorTagIndex);
                matcher.appendReplacement(result, "href=\"" + anchorTag + "\"");
            }
            matcher.appendTail(result);
            html = result.toString();
            result = new StringBuffer(2048);
            matcher = SRC_REFERENCES.matcher(html);
            while (matcher.find()) {
                String src = matcher.group(1);
                if (debug) {
                    RichTextPlugin.getDefault().getLogger().logInfo("PasteAction: src = \"" + src + "\"");
                }
                try {
                    URI srcURI = sourceURI.resolve(NetUtil.encodeFileURL((String)src));
                    String scheme = srcURI.getScheme();
                    if (scheme == null || !scheme.equalsIgnoreCase("file")) continue;
                    if (debug) {
                        RichTextPlugin.getDefault().getLogger().logInfo("PasteAction: srcURI = \"" + srcURI + "\"");
                        RichTextPlugin.getDefault().getLogger().logInfo("PasteAction: basePath = \"" + basePath + "\"");
                    }
                    matcher.appendReplacement(result, "src=\"" + FileUtil.getRelativePath((File)new File(srcURI), (File)new File(basePath)) + "\"");
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            matcher.appendTail(result);
            return result.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return html;
        }
    }
}

