/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.richtext.dialogs;

import org.eclipse.epf.richtext.RichTextResources;
import org.eclipse.epf.richtext.actions.FindReplaceAction;
import org.eclipse.epf.richtext.dialogs.BaseDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class FindReplaceDialog
extends BaseDialog {
    private FindReplaceAction findReplaceAction;
    private Text findText;
    private Text replaceText;
    private Button searchForwardRadioButton;
    private Button searchBackwardRadioButton;
    private Button caseSensitiveCheckbox;
    private Button wholeWordCheckbox;
    private Button findButton;
    private Button replaceButton;
    private Button replaceFindButton;
    private Button replaceAllButton;

    public FindReplaceDialog(Shell parent, FindReplaceAction findReplaceAction) {
        super(parent);
        this.findReplaceAction = findReplaceAction;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layout = (GridLayout)composite.getLayout();
        layout.numColumns = 1;
        Composite textComposite = new Composite(composite, 0);
        textComposite.setLayout((Layout)new GridLayout(2, false));
        textComposite.setLayoutData((Object)new GridData(768));
        Label findLabel = new Label(textComposite, 0);
        findLabel.setText(RichTextResources.getString("RichText.findLabel.text"));
        this.findText = new Text(textComposite, 2048);
        GridData gridData = new GridData(768);
        gridData.widthHint = 200;
        this.findText.setLayoutData((Object)gridData);
        this.findText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (FindReplaceDialog.this.findButton != null) {
                    FindReplaceDialog.this.findButton.setEnabled(FindReplaceDialog.this.findText.getText().trim().length() > 0);
                }
                if (FindReplaceDialog.this.replaceAllButton != null) {
                    FindReplaceDialog.this.replaceAllButton.setEnabled(FindReplaceDialog.this.findText.getText().trim().length() > 0);
                }
            }
        });
        Label replaceLabel = new Label(textComposite, 0);
        replaceLabel.setText(RichTextResources.getString("RichText.replaceLabel.text"));
        this.replaceText = new Text(textComposite, 2048);
        this.replaceText.setLayoutData((Object)gridData);
        this.replaceText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (FindReplaceDialog.this.replaceButton != null) {
                    FindReplaceDialog.this.replaceButton.setEnabled(FindReplaceDialog.this.findReplaceAction.getFoundMatch());
                }
                if (FindReplaceDialog.this.replaceFindButton != null) {
                    FindReplaceDialog.this.replaceFindButton.setEnabled(FindReplaceDialog.this.findReplaceAction.getFoundMatch());
                }
            }
        });
        Composite optionsComposite = new Composite(composite, 0);
        optionsComposite.setLayout((Layout)new GridLayout(2, true));
        optionsComposite.setLayoutData((Object)new GridData(768));
        Group directionGroup = new Group(optionsComposite, 0);
        directionGroup.setText(RichTextResources.getString("RichText.directionGroup.text"));
        directionGroup.setLayout((Layout)new GridLayout(1, false));
        directionGroup.setLayoutData((Object)new GridData(768));
        this.searchForwardRadioButton = new Button((Composite)directionGroup, 16);
        this.searchForwardRadioButton.setText(RichTextResources.getString("RichText.forwardRadioButton.text"));
        this.searchForwardRadioButton.setSelection(true);
        this.searchBackwardRadioButton = new Button((Composite)directionGroup, 16);
        this.searchBackwardRadioButton.setText(RichTextResources.getString("RichText.backwardRadioButton.text"));
        Group optionsGroup = new Group(optionsComposite, 0);
        optionsGroup.setText(RichTextResources.getString("RichText.optionsGroup.text"));
        optionsGroup.setLayout((Layout)new GridLayout(1, false));
        optionsGroup.setLayoutData((Object)new GridData(768));
        this.caseSensitiveCheckbox = new Button((Composite)optionsGroup, 32);
        this.caseSensitiveCheckbox.setText(RichTextResources.getString("RichText.caseSensitiveCheckbox.text"));
        this.wholeWordCheckbox = new Button((Composite)optionsGroup, 32);
        this.wholeWordCheckbox.setText(RichTextResources.getString("RichText.wholeWordCheckbox.text"));
        super.getShell().setText(RichTextResources.getString("RichText.findReplaceDialog.title"));
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1025, RichTextResources.getString("RichText.findButton.text"), true);
        this.findButton = super.getButton(1025);
        this.findButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                FindReplaceDialog.this.findReplaceAction.run(1, FindReplaceDialog.this.getFindText(), FindReplaceDialog.this.getReplaceText(), FindReplaceDialog.this.getMatchDirection(), FindReplaceDialog.this.getMatchOptions());
                FindReplaceDialog.this.replaceButton.setEnabled(FindReplaceDialog.this.findReplaceAction.getFoundMatch());
                FindReplaceDialog.this.replaceFindButton.setEnabled(FindReplaceDialog.this.findReplaceAction.getFoundMatch());
                FindReplaceDialog.this.findButton.setFocus();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.createButton(parent, 1026, RichTextResources.getString("RichText.replaceButton.text"), false);
        this.replaceButton = super.getButton(1026);
        this.replaceButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                FindReplaceDialog.this.findReplaceAction.run(2, FindReplaceDialog.this.getFindText(), FindReplaceDialog.this.getReplaceText(), FindReplaceDialog.this.getMatchDirection(), FindReplaceDialog.this.getMatchOptions());
                FindReplaceDialog.this.replaceButton.setFocus();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.createButton(parent, 1027, RichTextResources.getString("RichText.replaceFindButton.text"), false);
        this.replaceFindButton = super.getButton(1027);
        this.replaceFindButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                FindReplaceDialog.this.findReplaceAction.run(3, FindReplaceDialog.this.getFindText(), FindReplaceDialog.this.getReplaceText(), FindReplaceDialog.this.getMatchDirection(), FindReplaceDialog.this.getMatchOptions());
                FindReplaceDialog.this.replaceButton.setEnabled(FindReplaceDialog.this.findReplaceAction.getFoundMatch());
                FindReplaceDialog.this.replaceFindButton.setEnabled(FindReplaceDialog.this.findReplaceAction.getFoundMatch());
                FindReplaceDialog.this.replaceFindButton.setFocus();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.createButton(parent, 1028, RichTextResources.getString("RichText.replaceallButton.text"), false);
        this.replaceAllButton = super.getButton(1028);
        this.replaceAllButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                FindReplaceDialog.this.findReplaceAction.run(4, FindReplaceDialog.this.getFindText(), FindReplaceDialog.this.getReplaceText(), FindReplaceDialog.this.getMatchDirection(), FindReplaceDialog.this.getMatchOptions());
                FindReplaceDialog.this.replaceButton.setEnabled(false);
                FindReplaceDialog.this.replaceFindButton.setEnabled(false);
                FindReplaceDialog.this.replaceAllButton.setFocus();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.cancelButton = super.getButton(1);
        this.findButton.setEnabled(false);
        this.replaceButton.setEnabled(false);
        this.replaceFindButton.setEnabled(false);
        this.replaceAllButton.setEnabled(false);
    }

    public String getFindText() {
        return this.findText.getText();
    }

    public String getReplaceText() {
        return this.replaceText.getText();
    }

    public int getMatchDirection() {
        return this.searchForwardRadioButton.getSelection() ? 1 : -1;
    }

    public int getMatchOptions() {
        int options = 0;
        if (this.wholeWordCheckbox.getSelection()) {
            options |= 2;
        }
        if (this.caseSensitiveCheckbox.getSelection()) {
            options |= 4;
        }
        return options;
    }
}

