/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.gef.edit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.BendpointConnectionRouter;
import org.eclipse.draw2d.ConnectionLayer;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.FanRouter;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.epf.authoring.gef.commands.DeleteCommand;
import org.eclipse.epf.authoring.gef.edit.BaseEditPart;
import org.eclipse.epf.authoring.gef.edit.ValidatingDirectEditManager;
import org.eclipse.epf.authoring.gef.edit.policies.NodeContainerEditPolicy;
import org.eclipse.epf.authoring.gef.edit.policies.NodeContainerFlowLayoutEditPolicy;
import org.eclipse.epf.diagram.model.NamedNode;
import org.eclipse.epf.diagram.model.Node;
import org.eclipse.epf.diagram.model.NodeContainer;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.LayerConstants;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editpolicies.ComponentEditPolicy;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.gef.tools.DirectEditManager;

public abstract class NodeContainerEditPart
extends AbstractGraphicalEditPart
implements LayerConstants {
    private BendpointConnectionRouter cRouter;
    protected Adapter modelListener = new AdapterImpl(){

        public void notifyChanged(Notification msg) {
            NodeContainerEditPart.this.handlePropertyChanged(msg);
        }
    };
    static /* synthetic */ Class class$0;

    public NodeContainerEditPart(NodeContainer model) {
        this.setModel(model);
    }

    public void activate() {
        super.activate();
        NodeContainer model = (NodeContainer)((EObject)this.getModel());
        model.eAdapters().add((Object)this.modelListener);
        model.addConsumer((Object)this);
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new ComponentEditPolicy(){

            protected Command createDeleteCommand(GroupRequest deleteRequest) {
                Boolean bool = (Boolean)deleteRequest.getExtendedData().get("gef.ediagram.$perm");
                boolean permDelete = bool == null ? false : bool;
                DeleteCommand cmd = new DeleteCommand(permDelete);
                cmd.setPartToBeDeleted(this.getHost().getModel());
                return cmd;
            }
        });
        this.installEditPolicy("Selection Feedback", null);
        this.installEditPolicy("ContainerEditPolicy", (EditPolicy)new NodeContainerEditPolicy());
        this.installEditPolicy("NodeEditPolicy", null);
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new NodeContainerFlowLayoutEditPolicy());
    }

    public void deactivate() {
        NodeContainer model = (NodeContainer)((EObject)this.getModel());
        model.eAdapters().remove((Object)this.modelListener);
        model.removeConsumer((Object)this);
        super.deactivate();
    }

    protected EditPart findChildByModel(Object model) {
        Iterator iter = this.getChildren().iterator();
        while (iter.hasNext()) {
            EditPart child = (EditPart)iter.next();
            if (child.getModel() != model) continue;
            return child;
        }
        return null;
    }

    protected void addPartToEdit(Collection partsToEdit, Object node) {
        DirectEditManager editManager;
        EditPart editPart;
        if (node instanceof NamedNode && (editPart = this.findChildByModel(node)) instanceof BaseEditPart && (editManager = ((BaseEditPart)editPart).getDirectEditManager()) instanceof ValidatingDirectEditManager && ((ValidatingDirectEditManager)editManager).validate(((NamedNode)node).getName()) != null) {
            partsToEdit.add(editPart);
        }
    }

    protected void handlePropertyChanged(Notification msg) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.epf.diagram.model.NodeContainer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        switch (msg.getFeatureID((Class)clazz)) {
            case 1: 
            case 2: {
                this.refreshVisuals();
                break;
            }
            case 5: {
                this.refreshSourceConnections();
                break;
            }
            case 4: {
                this.refreshTargetConnections();
                break;
            }
            case 7: {
                Iterator iter;
                this.refreshChildren();
                ArrayList partsToEdit = new ArrayList();
                switch (msg.getEventType()) {
                    case 3: {
                        this.addPartToEdit(partsToEdit, msg.getNewValue());
                        break;
                    }
                    case 5: {
                        iter = ((Collection)msg.getNewValue()).iterator();
                        while (iter.hasNext()) {
                            this.addPartToEdit(partsToEdit, iter.next());
                        }
                        break;
                    }
                }
                if (!this.getViewer().getControl().isFocusControl()) break;
                iter = partsToEdit.iterator();
                while (iter.hasNext()) {
                    BaseEditPart editPart = (BaseEditPart)((Object)iter.next());
                    editPart.performDirectEdit();
                }
                break;
            }
        }
    }

    protected void refreshVisuals() {
        Point loc;
        Node node = (Node)this.getModel();
        Dimension size = new Dimension(node.getWidth(), node.getHeight());
        if (size == null) {
            size = new Dimension(60, 100);
        }
        if ((loc = node.getLocation()) == null) {
            loc = new Point(10, 10);
        }
        Rectangle r = new Rectangle(loc, size);
        ((GraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, this.getFigure(), (Object)r);
        if (this.cRouter == null) {
            ConnectionLayer cLayer = (ConnectionLayer)this.getLayer("Connection Layer");
            FanRouter router = new FanRouter();
            router.setSeparation(30);
            this.cRouter = new BendpointConnectionRouter();
            router.setNextRouter((ConnectionRouter)this.cRouter);
            cLayer.setConnectionRouter((ConnectionRouter)router);
        }
    }

    protected List getModelChildren() {
        return ((NodeContainer)this.getModel()).getNodes();
    }
}

