/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.actions;

import com.ibm.uma.MethodConfiguration;
import com.ibm.uma.MethodElement;
import com.ibm.uma.Process;
import com.ibm.uma.util.AssociationHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.actions.ILibraryAction;
import org.eclipse.epf.authoring.ui.actions.MethodElementDeleteAction;
import org.eclipse.epf.authoring.ui.editors.IEditorKeeper;
import org.eclipse.epf.library.edit.ui.UserInteractionHelper;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.services.LibraryProcessor;
import org.eclipse.epf.persistence.MultiFileResourceSetImpl;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;

public class LibraryViewDeleteAction
extends MethodElementDeleteAction
implements ILibraryAction {
    protected void didDelete(Collection deletedElements) {
        Iterator iter = deletedElements.iterator();
        while (iter.hasNext()) {
            Object element = TngUtil.unwrap(iter.next());
            if (!(element instanceof MethodElement) || ((MethodElement)element).eContainer() != null) continue;
            IEditorKeeper.REFERENCE.getEditorKeeper().closeEditorsOnDeletion((MethodElement)element);
        }
    }

    public boolean updateSelection(IStructuredSelection selection) {
        ArrayList filteredSelection = new ArrayList();
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            Object e = iter.next();
            Object element = TngUtil.unwrap(e);
            if (element instanceof ItemProviderAdapter || element instanceof MethodElement && TngUtil.isPredefined((MethodElement)((MethodElement)element))) continue;
            filteredSelection.add(e);
        }
        if (filteredSelection.isEmpty()) {
            return false;
        }
        if (filteredSelection.size() > 1) {
            return false;
        }
        return super.updateSelection((IStructuredSelection)new StructuredSelection(filteredSelection));
    }

    public void run() {
        IStatus status;
        HashSet<Object> configsToDelete = new HashSet<Object>();
        HashSet<Resource> modifiedResources = new HashSet<Resource>();
        Iterator iter = this.selection.iterator();
        while (iter.hasNext()) {
            EObject container;
            Object object = TngUtil.unwrap(iter.next());
            if (object instanceof MethodConfiguration) {
                configsToDelete.add(object);
            }
            if (!(object instanceof EObject) || (container = ((EObject)object).eContainer()).eResource() == null) continue;
            modifiedResources.add(container.eResource());
        }
        if (!configsToDelete.isEmpty()) {
            HashSet<String> configGUIDsToDelete = new HashSet<String>();
            Iterator iter2 = configsToDelete.iterator();
            while (iter2.hasNext()) {
                MethodConfiguration config = (MethodConfiguration)iter2.next();
                configGUIDsToDelete.add(config.getGuid());
            }
            MultiFileResourceSetImpl resourceSet = (MultiFileResourceSetImpl)LibraryProcessor.getInstance().getLibrary().eResource().getResourceSet();
            resourceSet.loadOppositeFeatures(Collections.singletonList(AssociationHelper.MethodConfiguration_DependentProcesses), configGUIDsToDelete);
            Iterator iter3 = configsToDelete.iterator();
            while (iter3.hasNext()) {
                MethodConfiguration config = (MethodConfiguration)iter3.next();
                List references = AssociationHelper.getDependentProcesses((MethodConfiguration)config);
                if (references == null || references.size() <= 0) continue;
                String processName = ((Process)references.get(0)).getName();
                AuthoringUIPlugin.getDefault().getMsgDialog().displayWarning(AuthoringUIResources.getString("AuthoringUI.deleteDialog.title"), AuthoringUIResources.getString("AuthoringUI.deleteConfigError.msg"), AuthoringUIResources.formatString("AuthoringUI.deleteConfigError.reason", processName));
                return;
            }
        }
        if (!(status = UserInteractionHelper.checkModify(modifiedResources, null)).isOK()) {
            AuthoringUIPlugin.getDefault().getMsgDialog().display(AuthoringUIResources.getString("AuthoringUI.deleteDialog.title"), status);
            return;
        }
        if (this.confirmDelete()) {
            this.command.execute();
        }
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }
}

