/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.actions;

import com.ibm.uma.MethodConfiguration;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.epf.authoring.ui.PerspectiveListUtil;
import org.eclipse.epf.authoring.ui.UIActionDispatcher;
import org.eclipse.epf.authoring.ui.editors.EditorChooser;
import org.eclipse.epf.authoring.ui.wizards.OpenConfigurationWizard;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;

public class OpenConfigurationAction
implements IWorkbenchWindowActionDelegate {
    private IStructuredSelection selection;
    private List configList = new ArrayList();

    public void init(IWorkbenchWindow window) {
    }

    public void run(IAction action) {
        Display.getCurrent().asyncExec(new Runnable(){

            public void run() {
                OpenConfigurationAction.this.configList.clear();
                OpenConfigurationAction.this.doWork();
                if (OpenConfigurationAction.this.configList.size() > 0) {
                    if (!PerspectiveListUtil.isAuthoringPerspective()) {
                        System.out.println("$$$DEBUG: Need to switch to authoring perspective!");
                        UIActionDispatcher.openAuthoringPerspective();
                    }
                    int i = 0;
                    while (i < OpenConfigurationAction.this.configList.size()) {
                        MethodConfiguration config = (MethodConfiguration)OpenConfigurationAction.this.configList.get(i);
                        EditorChooser.getInstance().openEditor(config);
                        ++i;
                    }
                }
            }
        });
    }

    public void dispose() {
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    private void doWork() {
        try {
            IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            if (activePage != null) {
                OpenConfigurationWizard wizard = new OpenConfigurationWizard(this.configList);
                wizard.init(PlatformUI.getWorkbench(), this.selection);
                WizardDialog dialog = new WizardDialog(Display.getCurrent().getActiveShell(), (IWizard)wizard);
                dialog.create();
                dialog.open();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

