/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.actions;

import com.ibm.uma.Activity;
import com.ibm.uma.MethodElement;
import com.ibm.uma.RoleDescriptor;
import com.ibm.uma.TaskDescriptor;
import com.ibm.uma.TeamProfile;
import com.ibm.uma.WorkProductDescriptor;
import com.ibm.uma.util.ContentDescriptionFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.actions.MethodElementDeleteAction;
import org.eclipse.epf.library.edit.command.DeleteMethodElementCommand;
import org.eclipse.epf.library.edit.command.IActionManager;
import org.eclipse.epf.library.edit.command.IResourceAwareCommand;
import org.eclipse.epf.library.edit.process.BreakdownElementWrapperItemProvider;
import org.eclipse.epf.library.edit.process.command.DeleteRoleDescriptor;
import org.eclipse.epf.library.edit.process.command.DeleteTaskDescriptor;
import org.eclipse.epf.library.edit.process.command.DeleteTeamProfile;
import org.eclipse.epf.library.edit.process.command.DeleteWorkProductDescriptor;
import org.eclipse.epf.library.edit.process.command.RemoveUnusedDescriptorsCommand;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;

public class ProcessDeleteAction
extends MethodElementDeleteAction {
    private boolean deletionConfirmed = false;
    private HashSet removedDescriptors;

    public ProcessDeleteAction() {
    }

    public ProcessDeleteAction(EditingDomain domain) {
        super(domain);
    }

    public ProcessDeleteAction(EditingDomain domain, boolean confirm) {
        super(domain, confirm);
    }

    public DeleteMethodElementCommand createMethodElementDeleteCommand() {
        return new ProcessElementDeleteCommand(RemoveCommand.create((EditingDomain)this.domain, (Collection)this.selection), this.selection);
    }

    public void run(IActionManager actionMgr) {
        if (this.confirmDelete()) {
            Iterator itor = this.selection.iterator();
            while (itor.hasNext()) {
                this.removeReferences(actionMgr, itor.next());
            }
            this.domain.getCommandStack().execute(this.command);
        }
    }

    protected void saveCurrentEditor() {
    }

    protected String getDeleteConfirmationMessage() {
        return AuthoringUIResources.getString("AuthoringUI.ProcessDeleteAction.deletecofirm.text0");
    }

    public void run() {
        if (this.confirmDelete()) {
            Command cmd = this.command;
            this.removedDescriptors = new HashSet();
            Iterator itor = this.selection.iterator();
            while (itor.hasNext()) {
                this.removeReferences(null, itor.next());
            }
            if (cmd instanceof ProcessElementDeleteCommand) {
                ((ProcessElementDeleteCommand)cmd).excludeElements(this.removedDescriptors);
            }
            cmd.execute();
            if (((DeleteMethodElementCommand)cmd).executed) {
                this.deletionConfirmed = true;
            }
            this.saveCurrentEditor();
        }
    }

    private void removeReferences(IActionManager actionMgr, Object obj) {
        boolean force;
        DeleteTaskDescriptor cmd = null;
        boolean bl = force = !this.confirm;
        if (obj instanceof TaskDescriptor) {
            cmd = new DeleteTaskDescriptor((TaskDescriptor)obj, force);
        } else if (obj instanceof RoleDescriptor) {
            cmd = new DeleteRoleDescriptor((RoleDescriptor)obj, force);
        } else if (obj instanceof WorkProductDescriptor) {
            cmd = new DeleteWorkProductDescriptor((WorkProductDescriptor)obj, force);
        } else if (obj instanceof TeamProfile) {
            cmd = new DeleteTeamProfile((TeamProfile)obj);
        }
        if (cmd != null) {
            if (actionMgr != null) {
                actionMgr.execute((IResourceAwareCommand)cmd);
            } else {
                cmd.execute();
            }
            if (cmd instanceof RemoveUnusedDescriptorsCommand) {
                this.removedDescriptors.addAll(((RemoveUnusedDescriptorsCommand)cmd).getRemovedDescriptors());
            }
        }
    }

    public boolean updateSelection(IStructuredSelection selection) {
        boolean ret = super.updateSelection(ProcessDeleteAction.filterSelection(selection));
        return ret;
    }

    public static IStructuredSelection filterSelection(IStructuredSelection selection) {
        ArrayList list = new ArrayList();
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (element instanceof BreakdownElementWrapperItemProvider && ((BreakdownElementWrapperItemProvider)element).isReadOnly()) continue;
            list.add(element);
        }
        return new StructuredSelection(list);
    }

    public boolean isDeletionConfirmed() {
        return this.deletionConfirmed;
    }

    protected Command getCommand() {
        return this.command;
    }

    protected static class ProcessElementDeleteCommand
    extends DeleteMethodElementCommand {
        private Set contentsToRemove;
        private ArrayList elementsToRemoveReferences;

        public ProcessElementDeleteCommand(Command command, Collection elements) {
            super(command, elements);
        }

        protected void excludeElements(Collection excludedElements) {
            this.elements.removeAll(excludedElements);
            if (this.command instanceof RemoveCommand) {
                ((RemoveCommand)this.command).getCollection().removeAll(excludedElements);
            }
        }

        protected Collection getElementsToRemoveReferences() {
            if (this.elementsToRemoveReferences == null) {
                this.elementsToRemoveReferences = new ArrayList();
                Iterator iter = this.elements.iterator();
                while (iter.hasNext()) {
                    Object element = iter.next();
                    if (element instanceof Activity) {
                        EObject pkg = ((Activity)element).eContainer();
                        if (pkg != null) {
                            this.elementsToRemoveReferences.add(pkg);
                            continue;
                        }
                        this.elementsToRemoveReferences.add(element);
                        continue;
                    }
                    this.elementsToRemoveReferences.add(element);
                }
            }
            return this.elementsToRemoveReferences;
        }

        protected boolean canRemoveReferences(MethodElement e) {
            return true;
        }

        protected void removeReferences() {
            this.contentsToRemove = new HashSet();
            Iterator iter = this.elements.iterator();
            while (iter.hasNext()) {
                Object obj = iter.next();
                if (!(obj instanceof EObject)) continue;
                EObject eObj = (EObject)obj;
                if (obj instanceof Activity) {
                    EObject container;
                    Activity act = (Activity)obj;
                    if (ContentDescriptionFactory.hasPresentation((MethodElement)act)) {
                        this.contentsToRemove.add(act.getPresentation());
                    }
                    if ((container = eObj.eContainer()) == null) continue;
                    EcoreUtil.remove((EObject)container);
                    TreeIterator iterator = container.eAllContents();
                    while (iterator.hasNext()) {
                        Object element = iterator.next();
                        if (!(element instanceof Activity) || !ContentDescriptionFactory.hasPresentation((MethodElement)(act = (Activity)element))) continue;
                        this.contentsToRemove.add(act.getPresentation());
                    }
                    continue;
                }
                EcoreUtil.remove((EObject)((EObject)obj));
            }
            super.removeReferences();
        }

        protected void deleteContent() throws Exception {
            Iterator iter = this.contentsToRemove.iterator();
            while (iter.hasNext()) {
                EcoreUtil.remove((EObject)((EObject)iter.next()));
            }
            this.elementsToDeleteContent.addAll(this.contentsToRemove);
            super.deleteContent();
        }
    }
}

