/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.dialogs;

import com.ibm.uma.Activity;
import com.ibm.uma.BreakdownElement;
import com.ibm.uma.MethodConfiguration;
import com.ibm.uma.Process;
import com.ibm.uma.ProcessComponent;
import com.ibm.uma.TeamProfile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.dialogs.ItemsFilterDialog;
import org.eclipse.epf.authoring.ui.filters.ProcessActivityFilter;
import org.eclipse.epf.authoring.ui.filters.ProcessRoleFilter;
import org.eclipse.epf.authoring.ui.filters.VariabilityProcessRoleFilter;
import org.eclipse.epf.authoring.ui.filters.VariabilityProcessTaskFilter;
import org.eclipse.epf.authoring.ui.filters.VariabilityProcessWorkProductFilter;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.itemsfilter.FilterConstants;
import org.eclipse.ui.PlatformUI;

public class DialogHelper {
    private static List selectElementsFor(BreakdownElement e, IFilter filter, MethodConfiguration config, String tabName) {
        ItemsFilterDialog fd = new ItemsFilterDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), filter, tabName, null, config);
        fd.defultImage(AuthoringUIPlugin.getDefault().getSharedImage("Authoring.gif"));
        fd.setBlockOnOpen(true);
        fd.setViewerSelectionSingle(false);
        fd.setTitle(tabName);
        fd.open();
        return fd.getSelectedItems();
    }

    public static List selectTasksFor(Activity act, MethodConfiguration config) {
        String tabName = FilterConstants.TASKS;
        VariabilityProcessTaskFilter filter = new VariabilityProcessTaskFilter(config, null, FilterConstants.TASKS, act);
        return DialogHelper.selectElementsFor((BreakdownElement)act, (IFilter)filter, config, tabName);
    }

    public static List selectElementsFor(Object object, MethodConfiguration config, AdapterFactory adapterFactory) {
        if (object instanceof Activity) {
            if (adapterFactory == TngAdapterFactory.INSTANCE.getWBS_ComposedAdapterFactory()) {
                return DialogHelper.selectTasksFor((Activity)object, config);
            }
            if (adapterFactory == TngAdapterFactory.INSTANCE.getOBS_ComposedAdapterFactory()) {
                String tabName = FilterConstants.ROLES;
                VariabilityProcessRoleFilter filter = new VariabilityProcessRoleFilter(config, null, FilterConstants.ROLES, (Activity)object);
                return DialogHelper.selectElementsFor((BreakdownElement)object, (IFilter)filter, config, tabName);
            }
            if (adapterFactory == TngAdapterFactory.INSTANCE.getPBS_ComposedAdapterFactory()) {
                String tabName = FilterConstants.WORKPRODUCTS;
                VariabilityProcessWorkProductFilter filter = new VariabilityProcessWorkProductFilter(config, null, FilterConstants.WORKPRODUCTS, (Activity)object);
                return DialogHelper.selectElementsFor((BreakdownElement)object, (IFilter)filter, config, tabName);
            }
        }
        if (object instanceof TeamProfile && adapterFactory == TngAdapterFactory.INSTANCE.getOBS_ComposedAdapterFactory()) {
            String tabName = FilterConstants.ROLES;
            ProcessRoleFilter filter = new ProcessRoleFilter(config, null, FilterConstants.ROLES);
            return DialogHelper.selectElementsFor((BreakdownElement)object, (IFilter)filter, config, tabName);
        }
        return Collections.EMPTY_LIST;
    }

    public static List selectActivitiesFor(Activity act, MethodConfiguration config, int command) {
        String tabName = FilterConstants.PROCESSES;
        ProcessActivityFilter filter = new ProcessActivityFilter(config, null, FilterConstants.PROCESSES, act, command);
        List selection = DialogHelper.selectElementsFor((BreakdownElement)act, (IFilter)filter, config, tabName);
        ArrayList activities = new ArrayList();
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            Process proc;
            Object element = iter.next();
            if (element instanceof Activity) {
                activities.add(element);
                continue;
            }
            if (!(element instanceof ProcessComponent) || (proc = ((ProcessComponent)element).getProcess()) == null) continue;
            activities.add(proc);
        }
        return activities;
    }
}

