/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.forms;

import com.ibm.uma.CustomCategory;
import com.ibm.uma.MethodConfiguration;
import com.ibm.uma.MethodElement;
import com.ibm.uma.MethodLibrary;
import com.ibm.uma.MethodPackage;
import com.ibm.uma.MethodPlugin;
import com.ibm.uma.UmaPackage;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IViewerNotification;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.epf.authoring.ui.AuthoringUIHelpContexts;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.editors.ConfigurationEditor;
import org.eclipse.epf.authoring.ui.editors.ConfigurationEditorInput;
import org.eclipse.epf.authoring.ui.views.ConfigurationViewer;
import org.eclipse.epf.authoring.ui.views.MessageView;
import org.eclipse.epf.library.configuration.ConfigurationClosure;
import org.eclipse.epf.library.configuration.ConfigurationFactory;
import org.eclipse.epf.library.configuration.ElementDependencyError;
import org.eclipse.epf.library.configuration.ErrorInfo;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.command.IActionManager;
import org.eclipse.epf.library.edit.navigator.ContentItemProvider;
import org.eclipse.epf.library.edit.navigator.MethodPackagesItemProvider;
import org.eclipse.epf.library.edit.navigator.ProcessesItemProvider;
import org.eclipse.epf.library.edit.ui.UserInteractionHelper;
import org.eclipse.epf.library.events.ILibraryChangeListener;
import org.eclipse.epf.library.services.ElementReference;
import org.eclipse.epf.library.services.LibraryProcessor;
import org.eclipse.epf.library.services.SafeUpdateController;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class ConfigurationPage
extends FormPage
implements ISelectionProvider {
    MethodConfiguration config = null;
    ConfigurationClosure closure = null;
    ConfigurationViewer treeViewer;
    ConfigPackageContentProvider contProvider;
    ISelectionChangedListener selectionChangedListener = null;
    ScrolledForm form = null;
    boolean isDirty = false;
    private String formPrefix = AuthoringUIResources.getString("AuthoringUI.ConfigurationPage.FormPrefix");
    private ArrayList expandedElements = new ArrayList();
    private Button closureButton;
    private Button fixWarningButton;
    private Button errorButton;
    private Button hideButton;
    private Text elemDespContentText;
    protected Collection selectionChangedListeners = new ArrayList();
    protected ISelection currentSelection = StructuredSelection.EMPTY;
    private MessageView msgView;
    ISelectionChangedListener msgViewListener = null;
    private ConfigTreeFilter configFilter;
    private IActionManager actionMgr;
    private ILibraryChangeListener libListener = null;

    public ConfigurationPage(FormEditor editor) {
        super(editor, AuthoringUIResources.getString("AuthoringUI.ConfigurationPage.Description1"), AuthoringUIResources.getString("AuthoringUI.ConfigurationPage.Description2"));
    }

    public void init(IEditorSite site, IEditorInput input) {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        ConfigurationEditorInput configInput = (ConfigurationEditorInput)input;
        this.config = configInput.getConfiguration();
    }

    public void setInput(Object input) {
        this.treeViewer.setInput(input);
        this.treeViewer.expandAll();
        this.updateCheckStates();
    }

    protected void createFormContent(IManagedForm managedForm) {
        this.form = managedForm.getForm();
        this.form.setText(String.valueOf(this.formPrefix) + this.config.getName());
        FormToolkit toolkit = managedForm.getToolkit();
        TableWrapLayout layout = new TableWrapLayout();
        this.form.getBody().setLayout((Layout)layout);
        Section treeSection = toolkit.createSection(this.form.getBody(), 450);
        this.createTreeContent(toolkit, treeSection);
        this.addListeners();
        this.setInput(LibraryProcessor.getInstance().getLibrary());
    }

    public void createTreeContent(FormToolkit toolkit, Section section) {
        section.setText(AuthoringUIResources.getString("AuthoringUI.ConfigurationPage.ConfigContent"));
        section.setDescription(AuthoringUIResources.getString("AuthoringUI.ConfigurationPage.ConfigContentDescription"));
        section.setLayoutData((Object)new TableWrapData(256));
        Composite sectionClient = toolkit.createComposite((Composite)section);
        section.setClient((Control)sectionClient);
        GridLayout gl = new GridLayout();
        sectionClient.setLayout((Layout)gl);
        gl.numColumns = 6;
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)sectionClient.getParent(), AuthoringUIHelpContexts.CONFIGURATION_EDITOR_ALL_CONTEXT);
        Composite buttonComposite = toolkit.createComposite(sectionClient);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 6;
        buttonComposite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 6;
        gridData.horizontalAlignment = 3;
        buttonComposite.setLayoutData((Object)gridData);
        this.hideButton = toolkit.createButton(buttonComposite, "", 136);
        this.hideButton.setImage(AuthoringUIPlugin.getDefault().getSharedImage("hideUncheckedElem.gif"));
        this.hideButton.setToolTipText(AuthoringUIResources.getString("AuthoringUI.ConfigurationPage.hideToolTip"));
        this.hideButton.setLayoutData((Object)new GridData(3));
        this.fixWarningButton = toolkit.createButton(buttonComposite, "", 8);
        this.fixWarningButton.setImage(AuthoringUIPlugin.getDefault().getSharedImage("addref_co.gif"));
        this.fixWarningButton.setToolTipText(AuthoringUIResources.getString("AuthoringUI.ConfigurationPage.AddMissingToolTip"));
        this.fixWarningButton.setLayoutData((Object)new GridData(3));
        this.closureButton = toolkit.createButton(buttonComposite, "", 8);
        this.closureButton.setImage(AuthoringUIPlugin.getDefault().getSharedImage("closure_co.gif"));
        this.closureButton.setToolTipText(AuthoringUIResources.getString("AuthoringUI.ConfigurationPage.MakeClosureToolTip"));
        this.closureButton.setLayoutData((Object)new GridData(3));
        this.errorButton = toolkit.createButton(buttonComposite, "", 8);
        this.errorButton.setImage(AuthoringUIPlugin.getDefault().getSharedImage("showConfigError.gif"));
        this.errorButton.setToolTipText(AuthoringUIResources.getString("AuthoringUI.ConfigurationPage.ShowErrorToolTip"));
        GridData gd = new GridData(131);
        gd.horizontalAlignment = 3;
        gd.horizontalSpan = 1;
        this.errorButton.setLayoutData((Object)gd);
        Label treeTitleLabel = toolkit.createLabel(sectionClient, AuthoringUIResources.getString("AuthoringUI.ConfigurationPage.TreeTitleLabel"));
        GridData gd2 = new GridData(9);
        treeTitleLabel.setLayoutData((Object)gd2);
        gd2.horizontalSpan = 6;
        this.createViewer(sectionClient);
        Label elemDespLabel = toolkit.createLabel(sectionClient, AuthoringUIResources.getString("AuthoringUI.ConfigurationPage.Description"));
        GridData gd1 = new GridData();
        gd1.horizontalSpan = 6;
        elemDespLabel.setLayoutData((Object)gd1);
        this.elemDespContentText = toolkit.createText(sectionClient, "", 74);
        GridData gd22 = new GridData(1808);
        gd22.grabExcessHorizontalSpace = true;
        gd22.horizontalSpan = 6;
        gd22.heightHint = 50;
        toolkit.paintBordersFor(sectionClient);
        toolkit.paintBordersFor(buttonComposite);
        this.elemDespContentText.setLayoutData((Object)gd22);
        this.hideButton.setEnabled(true);
        this.hideButton.setVisible(true);
        this.errorButton.setEnabled(true);
        this.errorButton.setVisible(true);
        this.fixWarningButton.setEnabled(true);
        this.fixWarningButton.setVisible(true);
        this.closureButton.setEnabled(true);
        this.closureButton.setVisible(true);
    }

    public void initializeConfigFactory() {
        final ConfigurationFactory configFactory = LibraryProcessor.getInstance().getConfigurationFactory();
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                ConfigurationPage.this.closure = new ConfigurationClosure(configFactory, ConfigurationPage.this.config);
            }
        };
        UserInteractionHelper.runWithProgress((IRunnableWithProgress)runnable, (String)AuthoringUIResources.getString("AuthoringUI.ConfigurationPage.LoadingMessage"));
        ComposedAdapterFactory adapterFactory = TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory();
        this.contProvider = new ConfigPackageContentProvider(configFactory, (AdapterFactory)adapterFactory);
        this.treeViewer.setContentProvider((IContentProvider)this.contProvider);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new ConfigPackageLabelProvider(this.contProvider));
        this.configFilter = new ConfigTreeFilter(this.closure);
        this.treeViewer.addFilter(this.configFilter);
        this.updateMessage();
    }

    private void createViewer(Composite sectionClient) {
        sectionClient.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout();
        sectionClient.setLayout((Layout)layout);
        this.treeViewer = new ConfigurationViewer(sectionClient);
        GridData gridData = new GridData(1808);
        gridData.heightHint = 200;
        this.treeViewer.getTree().setLayoutData((Object)gridData);
        this.initializeConfigFactory();
    }

    private void addListeners() {
        this.actionMgr = ((ConfigurationEditor)this.getEditor()).getActionManager();
        this.closureButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ConfigurationPage.this.makeClosure();
            }
        });
        this.fixWarningButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ConfigurationPage.this.fixWarning();
            }
        });
        this.errorButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ConfigurationPage.this.showErrors();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.hideButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ConfigurationPage.this.showHideElements();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.treeViewer.addTreeListener(new ITreeViewerListener(){

            public void treeCollapsed(TreeExpansionEvent event) {
                Object element = event.getElement();
                ConfigurationPage.this.expandedElements.remove(element);
            }

            public void treeExpanded(TreeExpansionEvent event) {
                Object element = event.getElement();
                ConfigurationPage.this.expandedElements.add(element);
            }
        });
        if (this.selectionChangedListener == null) {
            this.selectionChangedListener = new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    System.out.println(String.valueOf(AuthoringUIResources.getString("AuthoringUI.ConfigurationPage.Selected")) + event.getSelection());
                    ConfigurationPage.this.setSelection(event.getSelection());
                }
            };
            this.treeViewer.addSelectionChangedListener(this.selectionChangedListener);
        }
        this.treeViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                boolean checked = event.getChecked();
                ConfigurationPage.this.updateCheckStates(event.getElement(), checked);
                ConfigurationPage.this.showErrors();
                ConfigurationPage.this.saveConfiguration();
            }
        });
        this.libListener = new ILibraryChangeListener(){

            public void libraryChanged(int option, Collection changedItems) {
                Object o;
                if ((option == 16 || option == 32) && changedItems != null && changedItems.size() > 0 && ((o = changedItems.toArray()[0]) instanceof MethodPlugin || o instanceof MethodPackage)) {
                    ConfigurationPage.this.treeViewer.refresh();
                    ConfigurationPage.this.updateCheckStates();
                    ConfigurationPage.this.showErrors();
                }
            }
        };
        LibraryProcessor.getInstance().addListener(this.libListener);
    }

    protected void showHideElements() {
        this.configFilter.setHide();
        this.updateCheckStates();
    }

    protected Object[] getConvertedSelections() {
        ArrayList<Object> items = new ArrayList<Object>();
        Object[] sels = this.treeViewer.getCheckedElements();
        ConfigPackageContentProvider cp = (ConfigPackageContentProvider)this.treeViewer.getContentProvider();
        int i = 0;
        while (i < sels.length) {
            Object sel = cp.getUITargetElement(sels[i]);
            if (sel != null && !items.contains(sel)) {
                items.add(sel);
            }
            ++i;
        }
        return items.toArray();
    }

    protected void showErrors() {
        List invalid = this.closure.getInvalidElements();
        this.closure.setSelections(this.getConvertedSelections());
        if (this.configFilter.isHiding()) {
            this.treeViewer.refresh();
        } else {
            invalid.addAll(this.closure.getInvalidElements());
            ConfigPackageContentProvider cp = (ConfigPackageContentProvider)this.treeViewer.getContentProvider();
            invalid.addAll(cp.getUIElements());
            this.treeViewer.update(invalid.toArray(), null);
        }
        this.updateMessage();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.add(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.remove(listener);
    }

    public ISelection getSelection() {
        return this.currentSelection;
    }

    public void setSelection(ISelection selection) {
        Object o;
        Object node;
        this.currentSelection = selection;
        Iterator listeners = this.selectionChangedListeners.iterator();
        while (listeners.hasNext()) {
            ISelectionChangedListener listener = (ISelectionChangedListener)listeners.next();
            listener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, selection));
        }
        IStructuredSelection sel = (IStructuredSelection)selection;
        Object[] selObjs = sel.toArray();
        if (selObjs != null && selObjs.length > 0 && this.closure.getError(node = selObjs[0]) != null) {
            this.getMessageView().showError(node);
        }
        if ((o = sel.getFirstElement()) instanceof MethodElement) {
            String briefDesc = ((MethodElement)o).getBriefDescription();
            this.elemDespContentText.setText(briefDesc != null ? briefDesc : "");
        }
    }

    protected void makeClosure() {
        ConfigurationClosure c = this.closure;
        c.makeClosure();
        this.treeViewer.refresh();
        this.updateCheckStates();
        this.saveConfiguration();
        this.updateMessage();
    }

    protected void fixWarning() {
        ConfigurationClosure c = this.closure;
        c.fixProblems();
        this.treeViewer.refresh();
        this.updateCheckStates();
        this.saveConfiguration();
        this.updateMessage();
    }

    private void updateCheckStates(Object element, boolean checked) {
        if (checked) {
            ITreeContentProvider cp = (ITreeContentProvider)this.treeViewer.getContentProvider();
            this.checkParent(cp, element);
        }
        this.selectionChildren(element, checked);
    }

    public void selectionChildren(Object element, boolean checked) {
        ITreeContentProvider cp = (ITreeContentProvider)this.treeViewer.getContentProvider();
        Object[] childs = cp.getChildren(element);
        int i = 0;
        while (i < childs.length) {
            this.treeViewer.setChecked(childs[i], checked);
            this.selectionChildren(childs[i], checked);
            ++i;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateCheckStates() {
        this.treeViewer.getTree().setVisible(false);
        try {
            Object content = this.treeViewer.getInput();
            if (content instanceof MethodLibrary) {
                Object element;
                Object[] selectionList = this.closure.getSelection();
                ConfigPackageContentProvider cp = (ConfigPackageContentProvider)this.treeViewer.getContentProvider();
                int i = 0;
                while (i < selectionList.length) {
                    element = selectionList[i];
                    this.checkParent((ITreeContentProvider)cp, element);
                    this.treeViewer.setChecked(element, true);
                    ++i;
                }
                Iterator it = new ArrayList(cp.getUIElements()).iterator();
                while (it.hasNext()) {
                    element = it.next();
                    Object o = cp.getUITargetElement(element);
                    if (o == null || !this.closure.isSelected(o)) continue;
                    this.checkParent((ITreeContentProvider)cp, element);
                    this.treeViewer.setChecked(element, true);
                }
                this.treeViewer.setExpandedElements(this.expandedElements.toArray());
            }
            Object var7_10 = null;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.treeViewer.getTree().setVisible(true);
            throw throwable;
        }
        this.treeViewer.getTree().setVisible(true);
    }

    private void checkParent(ITreeContentProvider cp, Object element) {
        if (element == null || element instanceof MethodLibrary) {
            return;
        }
        Object parent = LibraryUtil.unwrap((Object)cp.getParent(element));
        if (parent != null) {
            this.treeViewer.setChecked(parent, true);
            this.checkParent(cp, parent);
        }
    }

    public void getAllParents(List list, MethodPackage pkg) {
        MethodPackage parentPkg = pkg.getParentPackage();
        if (parentPkg != null) {
            list.add(parentPkg);
            this.getAllParents(list, parentPkg);
        }
    }

    public boolean setParentsChecked(Object element) {
        Widget widget = this.treeViewer.testFindItem(element);
        if (widget instanceof TreeItem) {
            TreeItem item = (TreeItem)widget;
            item = item.getParentItem();
            while (item != null) {
                item.setChecked(true);
                item = item.getParentItem();
            }
            return true;
        }
        return false;
    }

    public boolean isDirty() {
        return false;
    }

    public void setDirty(boolean dirty) {
        this.isDirty = dirty;
    }

    public void saveConfiguration() {
        ArrayList<Object> pkgList = this.config.getMethodPackageSelection();
        ArrayList<Object> plgList = this.config.getMethodPluginSelection();
        this.actionMgr = ((ConfigurationEditor)this.getEditor()).getActionManager();
        if (!plgList.isEmpty() && !this.actionMgr.doAction(6, (EObject)this.config, (EStructuralFeature)UmaPackage.eINSTANCE.getMethodConfiguration_MethodPluginSelection(), (Object)plgList, -1)) {
            return;
        }
        if (!pkgList.isEmpty() && !this.actionMgr.doAction(6, (EObject)this.config, (EStructuralFeature)UmaPackage.eINSTANCE.getMethodConfiguration_MethodPackageSelection(), pkgList, -1)) {
            return;
        }
        pkgList = new ArrayList<Object>();
        plgList = new ArrayList<Object>();
        Object[] objs = this.closure.getSelection();
        int i = 0;
        while (i < objs.length) {
            if (objs[i] instanceof MethodPlugin) {
                plgList.add(objs[i]);
            } else if (objs[i] instanceof MethodPackage) {
                pkgList.add(objs[i]);
            }
            ++i;
        }
        LibraryUtil.validateMethodConfiguration((MethodConfiguration)this.config);
        this.actionMgr = ((ConfigurationEditor)this.getEditor()).getActionManager();
        if (!plgList.isEmpty() && !this.actionMgr.doAction(5, (EObject)this.config, (EStructuralFeature)UmaPackage.eINSTANCE.getMethodConfiguration_MethodPluginSelection(), plgList, -1)) {
            return;
        }
        if (!pkgList.isEmpty() && !this.actionMgr.doAction(5, (EObject)this.config, (EStructuralFeature)UmaPackage.eINSTANCE.getMethodConfiguration_MethodPackageSelection(), pkgList, -1)) {
            return;
        }
    }

    public void dispose() {
        super.dispose();
        if (this.libListener != null) {
            LibraryProcessor.getInstance().removeListener(this.libListener);
        }
        if (this.msgView != null && this.msgViewListener != null) {
            this.msgView.removeSelectionChangedListener(this.msgViewListener);
        }
        if (this.configFilter != null) {
            this.configFilter.dispose();
        }
        if (this.closure != null) {
            this.closure.dispose();
            this.closure = null;
        }
    }

    private MessageView getMessageView() {
        if (this.msgView == null || this.msgView.isDisposed()) {
            this.msgView = MessageView.getView();
            this.msgView.configurationFactoryChanged(this.closure);
            this.msgViewListener = new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                    Object[] selObjs = sel.toArray();
                    if (selObjs != null && selObjs.length > 0) {
                        EObject node = null;
                        if (selObjs[0] instanceof ElementDependencyError) {
                            node = (EObject)((ElementDependencyError)selObjs[0]).getErrorElement();
                        } else if (selObjs[0] instanceof ErrorInfo) {
                            ErrorInfo info = (ErrorInfo)selObjs[0];
                            node = (EObject)info.getCauseElement();
                        } else if (selObjs[0] instanceof ElementReference && (node = (EObject)((ElementReference)selObjs[0]).getRefElement()) != null) {
                            node = node.eContainer();
                        }
                        if (node != null) {
                            ConfigurationPage.this.treeViewer.setSelection(LibraryUtil.getSelectable((EObject)node));
                        }
                    }
                }
            };
            this.msgView.addSelectionChangedListener(this.msgViewListener);
        }
        return this.msgView;
    }

    private void updateMessage() {
        if (this.closure.hasProblem() || this.msgView != null && !this.msgView.isDisposed()) {
            this.getMessageView().updateMessage();
        }
    }

    public ConfigurationClosure getClosure() {
        return this.closure;
    }

    public class ConfigPackageContentProvider
    extends AdapterFactoryContentProvider {
        private ConfigurationFactory configFactory;
        Map childUIParentMap;
        List uiFolders;

        public List getUIElements() {
            return this.uiFolders;
        }

        public ConfigPackageContentProvider(ConfigurationFactory configFactory, AdapterFactory adapterFactory) {
            super(adapterFactory);
            this.childUIParentMap = new HashMap();
            this.uiFolders = new ArrayList();
        }

        public ConfigurationFactory getConfigFactory() {
            return this.configFactory;
        }

        public Object[] getChildren(Object parentElement) {
            Object[] items = this.getValidItems(parentElement, super.getChildren(parentElement));
            return items;
        }

        public Object[] getElements(Object inputElement) {
            Object[] items = this.getValidItems(inputElement, super.getElements(inputElement));
            return items;
        }

        private boolean isUIFolder(Object e) {
            return e instanceof ContentItemProvider || e instanceof ProcessesItemProvider || e instanceof MethodPackagesItemProvider;
        }

        public Object getUITargetElement(Object e) {
            Notifier target;
            if (e instanceof CustomCategory) {
                return ((CustomCategory)e).eContainer();
            }
            if (e instanceof MethodElement) {
                return e;
            }
            if (e instanceof ContentItemProvider) {
                return ((ContentItemProvider)e).getParent(null);
            }
            if (e instanceof ProcessesItemProvider) {
                return ((ProcessesItemProvider)e).getParent(null);
            }
            if (e instanceof ItemProviderAdapter && (target = ((ItemProviderAdapter)e).getTarget()) != null && target instanceof MethodElement) {
                return target;
            }
            return null;
        }

        private Object[] getValidItems(Object parent, Object[] elements) {
            if (elements == null || elements.length == 0) {
                return elements;
            }
            ArrayList<Object> pkgs = new ArrayList<Object>();
            int i = 0;
            while (i < elements.length) {
                Object e = LibraryUtil.unwrap((Object)elements[i]);
                boolean uiFolder = this.isUIFolder(e);
                if (uiFolder || e instanceof MethodPackage || e instanceof MethodPlugin) {
                    pkgs.add(e);
                    if (uiFolder) {
                        this.uiFolders.add(e);
                    }
                    this.childUIParentMap.put(e, parent);
                }
                ++i;
            }
            return pkgs.toArray();
        }

        public Object getParent(Object element) {
            if (this.childUIParentMap.containsKey(element)) {
                return this.childUIParentMap.get(element);
            }
            return super.getParent(element);
        }

        public boolean hasChildren(Object element) {
            Object[] children = this.getChildren(element);
            return children != null && children.length > 0;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            super.inputChanged(viewer, oldInput, newInput);
            this.childUIParentMap.clear();
        }

        public void notifyChanged(Notification notification) {
            super.notifyChanged(notification);
            if (notification instanceof IViewerNotification) {
                IViewerNotification vnt = (IViewerNotification)notification;
                Object element = vnt.getElement();
                ConfigurationViewer ctrl = (ConfigurationViewer)this.viewer;
                SafeUpdateController.syncExec((Runnable)new Runnable(this, vnt, ctrl, element){
                    final /* synthetic */ ConfigPackageContentProvider this$1;
                    private final /* synthetic */ IViewerNotification val$vnt;
                    private final /* synthetic */ ConfigurationViewer val$ctrl;
                    private final /* synthetic */ Object val$element;
                    {
                        this.this$1 = configPackageContentProvider;
                        this.val$vnt = iViewerNotification;
                        this.val$ctrl = configurationViewer;
                        this.val$element = object;
                    }

                    public void run() {
                        if (this.val$vnt.getEventType() == 3 || this.val$vnt.getEventType() == 1) {
                            this.val$ctrl.setChecked(this.val$element, true);
                        }
                    }
                });
            }
        }

        public void dispose() {
            super.dispose();
            this.uiFolders.clear();
            this.childUIParentMap.clear();
            this.configFactory = null;
        }
    }

    public class ConfigPackageLabelProvider
    extends LabelProvider {
        ConfigPackageContentProvider contentProvider;
        ConfigurationFactory configFactory;
        AdapterFactoryLabelProvider afProvider;

        public ConfigPackageLabelProvider(ConfigPackageContentProvider contentProvider) {
            this.contentProvider = contentProvider;
            this.afProvider = new AdapterFactoryLabelProvider(contentProvider.getAdapterFactory());
            this.configFactory = contentProvider.getConfigFactory();
        }

        private ElementDependencyError getFirstChildError(Object e) {
            ElementDependencyError error = null;
            Object[] children = this.contentProvider.getChildren(e);
            if (children == null || children.length == 0) {
                return null;
            }
            int i = 0;
            while (i < children.length) {
                Object object = children[i];
                if (object instanceof ItemProviderAdapter) {
                    return this.getFirstChildError(object);
                }
                error = ConfigurationPage.this.closure.getError(object);
                if (error != null) {
                    return error;
                }
                ++i;
            }
            return error;
        }

        public Image getImage(Object object) {
            ConfigurationClosure config1 = ConfigurationPage.this.closure;
            if (config1 != null) {
                ElementDependencyError error = null;
                error = object instanceof ItemProviderAdapter ? this.getFirstChildError(object) : ConfigurationPage.this.closure.getError(object);
                if (error != null) {
                    if (error.isError() || error.isChildError()) {
                        return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WARN_TSK");
                    }
                    if (error.isWarning() || error.isChildWarning()) {
                        return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WARN_TSK");
                    }
                }
            }
            return this.afProvider.getImage(object);
        }

        protected Image getImageFromObject(Object object) {
            return ExtendedImageRegistry.getInstance().getImage(object);
        }

        public String getText(Object object) {
            return this.afProvider.getText(object);
        }

        public void dispose() {
            super.dispose();
            this.contentProvider = null;
            this.afProvider = null;
            this.configFactory = null;
        }
    }

    public class ConfigTreeFilter
    extends ViewerFilter {
        boolean hideUncheckedNodes = false;
        CheckboxTreeViewer checkTree = null;
        ConfigurationClosure closure = null;
        ConfigPackageContentProvider cp = null;

        public ConfigTreeFilter(ConfigurationClosure closure) {
            this.closure = closure;
        }

        public void setHide() {
            this.hideUncheckedNodes = !this.hideUncheckedNodes;
            this.checkTree.refresh();
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (this.checkTree == null) {
                this.checkTree = (CheckboxTreeViewer)viewer;
                this.cp = (ConfigPackageContentProvider)this.checkTree.getContentProvider();
            }
            if (this.hideUncheckedNodes) {
                Object o = this.cp.getUITargetElement(element);
                return this.closure.isSelected(o);
            }
            return true;
        }

        public boolean isHiding() {
            return this.hideUncheckedNodes;
        }

        public void dispose() {
            this.checkTree = null;
            this.cp = null;
            this.closure = null;
        }
    }
}

