/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.forms;

import com.ibm.uma.BreakdownElement;
import com.ibm.uma.Process;
import com.ibm.uma.ProcessComponent;
import com.ibm.uma.UmaFactory;
import com.ibm.uma.UmaPackage;
import com.ibm.uma.VariabilityElement;
import com.ibm.uma.VariabilityType;
import com.ibm.uma.WorkBreakdownElement;
import com.ibm.uma.WorkOrder;
import com.ibm.uma.WorkOrderType;
import com.ibm.uma.WorkProductDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.ui.viewer.IViewerProvider;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.epf.authoring.gef.figures.Colors;
import org.eclipse.epf.authoring.ui.AuthoringUIHelpContexts;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.editors.ColumnDescriptor;
import org.eclipse.epf.authoring.ui.editors.MethodElementEditor;
import org.eclipse.epf.authoring.ui.editors.ProcessEditor;
import org.eclipse.epf.authoring.ui.forms.ProcessFormPage;
import org.eclipse.epf.authoring.ui.views.ProcessViewer;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.command.IActionManager;
import org.eclipse.epf.library.edit.process.BreakdownElementWrapperItemProvider;
import org.eclipse.epf.library.edit.process.IBSItemProvider;
import org.eclipse.epf.library.edit.process.IColumnAware;
import org.eclipse.epf.library.edit.ui.ExposedAdapterFactoryContentProvider;
import org.eclipse.epf.library.edit.ui.IActionTypeProvider;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.Suppression;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.edit.util.VariabilityElementLabelProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class ProcessBreakdownStructureFormPage
extends ProcessFormPage
implements IViewerProvider {
    private static final String TXT_TRUE = "true";
    private static final String TXT_FALSE = "false";
    protected static final Collection ECLASSES = new ArrayList();
    private ColumnDescriptor[] columnDescriptors;
    private AdapterFactory adapterFactory;
    private ProcessViewer viewer;
    private TextCellEditor textCellEditor;
    private ValidatingTextCellEditor nameCellEditor;
    private ValidatingTextCellEditor predListCellEditor;
    private ComboBoxCellEditor comboBoxCellEditor;
    private CheckboxCellEditor checkBoxCellEditor;
    private ValidatingTextCellEditor presentationNameCellEditor;
    private boolean isReadOnly;
    static /* synthetic */ Class class$0;

    static {
        ECLASSES.add(UmaPackage.eINSTANCE.getMethodPackage());
    }

    public ProcessBreakdownStructureFormPage(FormEditor editor, String id, String title) {
        super(editor, id, title);
    }

    public boolean isReadOnly() {
        if (this.isReadOnly) {
            return this.isReadOnly;
        }
        return TngUtil.isLocked((EObject)this.process);
    }

    public void setReadOnly(boolean isReadOnly) {
        this.isReadOnly = isReadOnly;
    }

    public void setAdapterFactory(AdapterFactory adapterFactory) {
        this.adapterFactory = adapterFactory;
    }

    public void setColumnDescriptors(ColumnDescriptor[] columnDescriptors) {
        this.columnDescriptors = columnDescriptors;
        if (this.adapterFactory instanceof IColumnAware) {
            HashMap<Integer, String> columnIndexToNameMap = new HashMap<Integer, String>();
            int i = 0;
            while (i < columnDescriptors.length) {
                columnIndexToNameMap.put(new Integer(i), columnDescriptors[i].id);
                ++i;
            }
            ((IColumnAware)this.adapterFactory).setColumnIndexToNameMap(columnIndexToNameMap);
        }
    }

    private void setText(BreakdownElement e, String prop, String txt) {
        IActionManager actionMgr = ((MethodElementEditor)this.getEditor()).getActionManager();
        if (prop == "predecessors") {
            WorkBreakdownElement wbe = (WorkBreakdownElement)e;
            ArrayList predecessors = new ArrayList();
            if (ProcessUtil.checkPredecessorList((WorkBreakdownElement)wbe, (String)txt, (AdapterFactory)this.adapterFactory, (Object)this.process, predecessors) == null) {
                WorkOrder wo = null;
                int size = wbe.getLinkToPredecessor().size();
                Iterator iter = wbe.getLinkToPredecessor().iterator();
                while (iter.hasNext()) {
                    wo = (WorkOrder)iter.next();
                    int id = predecessors.indexOf(wo.getPred());
                    if (id != -1) continue;
                    iter.remove();
                }
                size = predecessors.size();
                int i = 0;
                while (i < size) {
                    WorkBreakdownElement element = (WorkBreakdownElement)predecessors.get(i);
                    boolean found = false;
                    Iterator iterator = wbe.getLinkToPredecessor().iterator();
                    while (iterator.hasNext()) {
                        wo = (WorkOrder)iterator.next();
                        if (wo.getPred() != element) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        wo = UmaFactory.eINSTANCE.createWorkOrder();
                        wo.setPred(element);
                        wo.setLinkType(WorkOrderType.FINISH_TO_FINISH_LITERAL);
                        actionMgr.doAction(3, (EObject)wbe, (EStructuralFeature)UmaPackage.eINSTANCE.getWorkBreakdownElement_LinkToPredecessor(), (Object)wo, -1);
                    }
                    ++i;
                }
            }
            return;
        }
        ProcessUtil.setAttribute((IActionManager)actionMgr, (BreakdownElement)e, (String)prop, (String)txt);
    }

    private String getText(BreakdownElement e, String prop) {
        if (prop == "presentation_name" && ProcessUtil.isExtendingOrContributing((BreakdownElement)e)) {
            return e.getPresentationName();
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IBSItemProvider adapter = (IBSItemProvider)this.adapterFactory.adapt((Notifier)e, (Object)clazz);
        return adapter.getAttribute((Object)e, prop);
    }

    public void setTabIndex(int id) {
    }

    public void setTabFolder(CTabFolder tabFolder) {
    }

    protected void createFormContent(IManagedForm managedForm) {
        ScrolledForm form = managedForm.getForm();
        FormToolkit toolkit = managedForm.getToolkit();
        form.setText(this.getEditor().getPartName());
        TableWrapLayout layout = new TableWrapLayout();
        form.getBody().setLayout((Layout)layout);
        Section section = toolkit.createSection(form.getBody(), 320);
        TableWrapData td = new TableWrapData(256, 256);
        section.setLayoutData((Object)td);
        section.setText(String.valueOf(this.getTitle()) + " " + AuthoringUIResources.getString("AuthoringUI.processBreakdownStructureFormPage.BSEditor"));
        section.setLayout((Layout)new GridLayout());
        Composite composite = toolkit.createComposite((Composite)section);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setLayout((Layout)new GridLayout());
        section.setClient((Control)composite);
        Control control = this.createControl(composite);
        toolkit.adapt(control, true, true);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.verticalIndent = 10;
        gridData.heightHint = 600;
        control.setLayoutData((Object)gridData);
        ProcessEditor editor = (ProcessEditor)this.getEditor();
        editor.createContextMenuFor((StructuredViewer)this.viewer);
        this.setInput(this.process);
    }

    public Control createControl(Composite parent) {
        this.viewer = new ProcessViewer(parent, 68354);
        this.viewer.setupColumns(this.columnDescriptors);
        this.viewer.setContentProvider((IContentProvider)new ExposedAdapterFactoryContentProvider(this.adapterFactory));
        this.viewer.setLabelProvider((IBaseLabelProvider)new ProcessAdapterFactoryLabelProvider(this.adapterFactory));
        if (this.viewer instanceof IActionTypeProvider) {
            this.viewer.setActionManager(((MethodElementEditor)this.getEditor()).getActionManager());
        }
        this.textCellEditor = new TextCellEditor(this.viewer.getCellEditorParent());
        this.comboBoxCellEditor = new ComboBoxCellEditor(this.viewer.getCellEditorParent(), new String[]{TXT_TRUE, TXT_FALSE});
        this.checkBoxCellEditor = new CheckboxCellEditor(this.viewer.getCellEditorParent());
        this.setCellEditors();
        this.viewer.setCellModifier(new ICellModifier(){

            public boolean canModify(Object element, String property) {
                if (ProcessBreakdownStructureFormPage.this.isReadOnly()) {
                    return false;
                }
                if (!(element instanceof BreakdownElement || element instanceof BreakdownElementWrapperItemProvider && !((BreakdownElementWrapperItemProvider)element).isReadOnly())) {
                    ArrayList<VariabilityType> types = new ArrayList<VariabilityType>();
                    types.add(VariabilityType.EXTENDS_LITERAL);
                    if (TngUtil.isGeneralizer((Object)((VariabilityElement)((BreakdownElementWrapperItemProvider)element).getOwner()), types)) {
                        return false;
                    }
                }
                if (property == "id" || property == "type" || property == "model_info" || property == "deliverable") {
                    return false;
                }
                if (!((element = TngUtil.unwrap((Object)element)) instanceof WorkProductDescriptor || property != "entry_state" && property != "exit_state")) {
                    return false;
                }
                return element instanceof WorkBreakdownElement || property != "predecessors";
            }

            public Object getValue(Object element, String property) {
                BreakdownElement e = (BreakdownElement)TngUtil.unwrap((Object)element);
                String val = ProcessBreakdownStructureFormPage.this.getText(e, property);
                switch (ProcessBreakdownStructureFormPage.this.getCellEditorType(property)) {
                    case 2: {
                        if (ProcessBreakdownStructureFormPage.TXT_TRUE.equalsIgnoreCase(val)) {
                            return new Integer(0);
                        }
                        return new Integer(1);
                    }
                    case 1: {
                        return val;
                    }
                    case 3: {
                        return Boolean.valueOf(val);
                    }
                }
                return val;
            }

            public void modify(Object element, String property, Object value) {
                String txt;
                Widget item = (Widget)element;
                BreakdownElement be = (BreakdownElement)TngUtil.unwrap((Object)item.getData());
                int columnIndex = ProcessBreakdownStructureFormPage.this.getColumnIndex(property);
                CellEditor cellEditor = ProcessBreakdownStructureFormPage.this.viewer.getCellEditors()[columnIndex];
                String errMsg = cellEditor.getErrorMessage();
                if (errMsg != null) {
                    return;
                }
                switch (ProcessBreakdownStructureFormPage.this.getCellEditorType(property)) {
                    case 1: {
                        txt = (String)value;
                        break;
                    }
                    case 2: {
                        int index = ((Number)value).intValue();
                        if (index == 0) {
                            txt = ProcessBreakdownStructureFormPage.TXT_TRUE;
                            break;
                        }
                        txt = ProcessBreakdownStructureFormPage.TXT_FALSE;
                        break;
                    }
                    case 3: {
                        txt = value.toString();
                        break;
                    }
                    default: {
                        txt = TngUtil.checkNull((String)value.toString());
                    }
                }
                ProcessBreakdownStructureFormPage.this.setText(be, property, txt);
                if (property == "presentation_name" && StrUtil.isBlank((String)be.getName())) {
                    be.setName(txt);
                }
                ProcessBreakdownStructureFormPage.this.viewer.refresh();
            }
        });
        this.viewer.setAutoExpandLevel(3);
        this.viewer.setInput(this.process);
        this.setContextHelp(this.viewer.getControl());
        return this.viewer.getControl();
    }

    public CellEditor getCellEditor(String columnID, int columnIndex) {
        if (columnID == "presentation_name") {
            if (this.presentationNameCellEditor == null) {
                this.presentationNameCellEditor = new ValidatingTextCellEditor(this.viewer.getCellEditorParent()){

                    protected String isValid(Object e, String txt) {
                        e = TngUtil.unwrap((Object)e);
                        return ProcessUtil.checkBreakdownElementPresentationName((AdapterFactory)ProcessBreakdownStructureFormPage.this.adapterFactory, (BreakdownElement)((BreakdownElement)e), (String)txt);
                    }
                };
                this.presentationNameCellEditor.setValidator(new CellEditorValidator(this.presentationNameCellEditor));
                this.presentationNameCellEditor.getControl().addListener(27, (Listener)new ValidatingDeactivateListener(this.presentationNameCellEditor));
            }
            this.presentationNameCellEditor.setColumnIndex(columnIndex);
            return this.presentationNameCellEditor;
        }
        if (columnID == "name") {
            if (this.nameCellEditor == null) {
                this.nameCellEditor = new ValidatingTextCellEditor(this.viewer.getCellEditorParent()){

                    protected String isValid(Object e, String txt) {
                        e = TngUtil.unwrap((Object)e);
                        return TngUtil.checkActivityName((AdapterFactory)ProcessBreakdownStructureFormPage.this.adapterFactory, (Object)e, (String)txt);
                    }
                };
                this.nameCellEditor.setValidator(new CellEditorValidator(this.nameCellEditor));
                this.nameCellEditor.getControl().addListener(27, (Listener)new ValidatingDeactivateListener(this.nameCellEditor));
            }
            this.nameCellEditor.setColumnIndex(columnIndex);
            return this.nameCellEditor;
        }
        if (columnID == "predecessors") {
            if (this.predListCellEditor == null) {
                this.predListCellEditor = new ValidatingTextCellEditor(this.viewer.getCellEditorParent()){

                    protected String isValid(Object e, String txt) {
                        e = TngUtil.unwrap((Object)e);
                        return ProcessUtil.checkPredecessorList((WorkBreakdownElement)((WorkBreakdownElement)e), (String)txt, (AdapterFactory)ProcessBreakdownStructureFormPage.this.adapterFactory, (Object)ProcessBreakdownStructureFormPage.this.process, null);
                    }
                };
                this.predListCellEditor.setValidator(new CellEditorValidator(this.predListCellEditor));
                this.predListCellEditor.getControl().addListener(27, (Listener)new ValidatingDeactivateListener(this.predListCellEditor));
            }
            this.predListCellEditor.setColumnIndex(columnIndex);
            return this.predListCellEditor;
        }
        return null;
    }

    public void setCellEditors() {
        CellEditor[] cellEditors = new CellEditor[this.columnDescriptors.length];
        int i = 0;
        while (i < this.columnDescriptors.length) {
            CellEditor cellEditor = this.getCellEditor(this.columnDescriptors[i].id, i);
            if (cellEditor != null) {
                cellEditors[i] = cellEditor;
            } else {
                switch (this.columnDescriptors[i].cellEditorType) {
                    case 2: {
                        cellEditors[i] = this.comboBoxCellEditor;
                        break;
                    }
                    case 1: {
                        cellEditors[i] = this.textCellEditor;
                        break;
                    }
                    case 3: {
                        cellEditors[i] = this.checkBoxCellEditor;
                        break;
                    }
                    default: {
                        cellEditors[i] = null;
                    }
                }
            }
            ++i;
        }
        this.viewer.setCellEditors(cellEditors);
    }

    public void setInput(Object newInput) {
        if (newInput instanceof Process) {
            this.process = (Process)newInput;
            if (this.process.eContainer() instanceof ProcessComponent) {
                this.viewer.setInput(this.process.eContainer());
                this.viewer.reveal(this.process);
                return;
            }
        }
        this.viewer.setInput(null);
    }

    private int getColumnIndex(String property) {
        Object[] colProps = this.viewer.getColumnProperties();
        int i = 0;
        while (i < colProps.length) {
            if (colProps[i] == property) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private int getCellEditorType(String property) {
        int i = 0;
        while (i < this.columnDescriptors.length) {
            ColumnDescriptor desc = this.columnDescriptors[i];
            if (desc.id == property) {
                return desc.cellEditorType;
            }
            ++i;
        }
        return 0;
    }

    public Viewer getViewer() {
        return this.viewer;
    }

    public void setProcess(Process proc) {
        if (this.process != proc) {
            this.setInput(proc);
        }
    }

    public AdapterFactory getAdapterFactory() {
        return this.adapterFactory;
    }

    public void updateColumns(ColumnDescriptor[] newColumnDescriptors) {
        this.setColumnDescriptors(newColumnDescriptors);
        this.viewer.setupColumns(newColumnDescriptors);
        this.setCellEditors();
        this.viewer.refresh();
    }

    public void dispose() {
        if (this.viewer.getContentProvider() != null) {
            this.viewer.getContentProvider().dispose();
        }
        if (this.viewer.getLabelProvider() != null) {
            this.viewer.getLabelProvider().dispose();
        }
        super.dispose();
    }

    private void setContextHelp(Control control) {
        AdapterFactory adapterFac = this.getAdapterFactory();
        ComposedAdapterFactory allFac = TngAdapterFactory.INSTANCE.getProcessComposedAdapterFactory();
        ComposedAdapterFactory wbsFac = TngAdapterFactory.INSTANCE.getWBS_ComposedAdapterFactory();
        ComposedAdapterFactory obsFac = TngAdapterFactory.INSTANCE.getOBS_ComposedAdapterFactory();
        ComposedAdapterFactory pbsFac = TngAdapterFactory.INSTANCE.getPBS_ComposedAdapterFactory();
        if (adapterFac == wbsFac) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp(control, AuthoringUIHelpContexts.FORM_EDITOR_PROCESS_WBS_CONTEXT);
        } else if (adapterFac == obsFac) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp(control, AuthoringUIHelpContexts.FORM_EDITOR_PROCESS_OBS_CONTEXT);
        } else if (adapterFac == pbsFac) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp(control, AuthoringUIHelpContexts.FORM_EDITOR_PROCESS_PBS_CONTEXT);
        } else if (adapterFac == allFac) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp(control, AuthoringUIHelpContexts.FORM_EDITOR_PROCESS_ALLBS_CONTEXT);
        }
    }

    private class ProcessAdapterFactoryLabelProvider
    extends VariabilityElementLabelProvider
    implements IColorProvider {
        public ProcessAdapterFactoryLabelProvider(AdapterFactory adapterFactory) {
            super(adapterFactory);
        }

        public Color getForeground(Object element) {
            if (this.isSuppressed(element)) {
                return Colors.SUPRESSED_ELEMENT_LABEL;
            }
            if (this.isExternal(element)) {
                return Colors.INHERITED_ELEMENT_LABEL;
            }
            return ColorConstants.listForeground;
        }

        private boolean isSuppressed(Object element) {
            if (element instanceof BreakdownElement) {
                return this.getSuppression().isSuppressed((Object)((BreakdownElement)element));
            }
            if (element instanceof BreakdownElementWrapperItemProvider) {
                return this.getSuppression().isSuppressed((Object)((BreakdownElementWrapperItemProvider)element));
            }
            return false;
        }

        private Suppression getSuppression() {
            return ((ProcessEditor)ProcessBreakdownStructureFormPage.this.getEditor()).getSuppression();
        }

        public Color getBackground(Object element) {
            return ColorConstants.listBackground;
        }

        public boolean isExternal(Object element) {
            return element instanceof BreakdownElementWrapperItemProvider && ((BreakdownElementWrapperItemProvider)element).isReadOnly();
        }

        public Font getFont(Object element) {
            if (this.isExternal(element)) {
                return italicFont;
            }
            return regularFont;
        }
    }

    private class ValidatingTextCellEditor
    extends TextCellEditor {
        protected Object lastInvalidElement;
        private int columnIndex;

        public ValidatingTextCellEditor(Composite parent) {
            super(parent);
        }

        void setColumnIndex(int columnIndex) {
            this.columnIndex = columnIndex;
        }

        public int getColumnIndex() {
            return this.columnIndex;
        }

        public Object getLastInvalidElement() {
            return this.lastInvalidElement;
        }

        String isValid(String txt) {
            IStructuredSelection selection = (IStructuredSelection)ProcessBreakdownStructureFormPage.this.viewer.getSelection();
            if (selection.size() == 1) {
                Object e = selection.getFirstElement();
                String msg = this.isValid(e, txt);
                this.lastInvalidElement = msg != null ? e : null;
                return msg;
            }
            return null;
        }

        protected String isValid(Object e, String txt) {
            return null;
        }
    }

    private static class CellEditorValidator
    implements ICellEditorValidator {
        private ValidatingTextCellEditor cellEditor;

        public CellEditorValidator(ValidatingTextCellEditor cellEditor) {
            this.cellEditor = cellEditor;
        }

        public String isValid(Object value) {
            return this.cellEditor.isValid((String)value);
        }
    }

    private class ValidatingDeactivateListener
    implements Listener {
        private ValidatingTextCellEditor cellEditor;

        ValidatingDeactivateListener(ValidatingTextCellEditor cellEditor) {
            this.cellEditor = cellEditor;
        }

        public void handleEvent(Event e) {
            Display.getCurrent().asyncExec(new Runnable(this){
                final /* synthetic */ ValidatingDeactivateListener this$1;
                {
                    this.this$1 = validatingDeactivateListener;
                }

                public void run() {
                    if (ValidatingDeactivateListener.access$0(this.this$1).getLastInvalidElement() != null) {
                        AuthoringUIPlugin.getDefault().getMsgDialog().displayError(AuthoringUIResources.getString("AuthoringUI.editProcessElementErrorDialog.title"), ValidatingDeactivateListener.access$0(this.this$1).getErrorMessage());
                        ProcessBreakdownStructureFormPage.access$0(ValidatingDeactivateListener.access$1(this.this$1)).editElement(ValidatingDeactivateListener.access$0(this.this$1).getLastInvalidElement(), ValidatingDeactivateListener.access$0(this.this$1).getColumnIndex());
                    }
                }
            });
        }

        static /* synthetic */ ValidatingTextCellEditor access$0(ValidatingDeactivateListener validatingDeactivateListener) {
            return validatingDeactivateListener.cellEditor;
        }

        static /* synthetic */ ProcessBreakdownStructureFormPage access$1(ValidatingDeactivateListener validatingDeactivateListener) {
            return validatingDeactivateListener.ProcessBreakdownStructureFormPage.this;
        }
    }
}

