/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.forms;

import com.ibm.uma.ContentElement;
import com.ibm.uma.MethodElement;
import com.ibm.uma.Task;
import com.ibm.uma.UmaFactory;
import com.ibm.uma.UmaPackage;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.epf.authoring.ui.AuthoringUIImages;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.AuthoringUIText;
import org.eclipse.epf.authoring.ui.dialogs.SectionsOrderDialog;
import org.eclipse.epf.authoring.ui.editors.MethodElementEditor;
import org.eclipse.epf.authoring.ui.editors.MethodElementEditorInput;
import org.eclipse.epf.authoring.ui.forms.BaseFormPage;
import org.eclipse.epf.authoring.ui.forms.MethodFormToolkit;
import org.eclipse.epf.authoring.ui.richtext.IMethodRichText;
import org.eclipse.epf.authoring.ui.richtext.IMethodRichTextEditor;
import org.eclipse.epf.authoring.ui.util.EditorsContextHelper;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.command.AddToSectionListCommand;
import org.eclipse.epf.library.edit.command.IActionManager;
import org.eclipse.epf.library.edit.command.IResourceAwareCommand;
import org.eclipse.epf.library.edit.command.MoveInSectionListCommand;
import org.eclipse.epf.library.edit.command.RemoveFromSectionList;
import org.eclipse.epf.library.edit.util.SectionList;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.edit.util.VariabilityElementLabelProvider;
import org.eclipse.epf.library.ui.LibraryUIText;
import org.eclipse.epf.richtext.RichTextListener;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;

public class TaskStepsPage
extends BaseFormPage {
    private static final String FORM_PAGE_ID = "taskStepsPage";
    private Text ctrl_name;
    private Button ctrl_add;
    private Button ctrl_delete;
    private Button ctrl_up;
    private Button ctrl_down;
    private Button ctrl_ordering;
    private Table ctrl_steps;
    private TableViewer stepsTableViewer;
    private SectionList allSteps;
    protected IMethodRichText activeControl;
    protected boolean descExpandFlag = false;
    protected IMethodRichTextEditor ctrl_expanded;
    protected ImageHyperlink expandLink;
    protected Label expandLabel;
    protected Section generalSection;
    protected Composite generalComposite;
    protected Composite expandedComposite;
    protected IMethodRichText ctrl_maindesc;
    private IStructuredContentProvider stepsViewerContentProvider;
    private ILabelProvider stepsViewerLabelProvider;
    private Task task;
    private com.ibm.uma.Section currentStep;
    private MethodElementEditor.ModifyListener contentModifyListener;
    private IActionManager actionMgr;

    public TaskStepsPage(FormEditor editor) {
        super(editor, FORM_PAGE_ID, AuthoringUIText.STEPS_PAGE_TITLE);
    }

    public void init(IEditorSite site, IEditorInput input) {
        super.init(site, input);
        MethodElementEditorInput methodElementInput = (MethodElementEditorInput)input;
        this.task = (Task)methodElementInput.getMethodElement();
    }

    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        this.form.setText(String.valueOf(LibraryUIText.getUIText((MethodElement)this.task)) + ": " + this.task.getName());
        this.generalSection = this.toolkit.createSection(this.form.getBody(), 450);
        this.generalSection.setLayoutData((Object)new TableWrapData(256));
        this.generalSection.setText(AuthoringUIText.STEPS_SECTION_NAME);
        this.generalSection.setDescription(AuthoringUIText.STEPS_SECTION_DESC);
        this.generalSection.setLayout((Layout)new GridLayout());
        this.generalComposite = this.toolkit.createComposite((Composite)this.generalSection);
        this.generalComposite.setLayoutData((Object)new GridData(768));
        this.generalComposite.setLayout((Layout)new GridLayout(4, false));
        this.generalSection.setClient((Control)this.generalComposite);
        EditorsContextHelper.setHelp((Control)this.generalComposite.getParent(), this.task);
        Composite pane1 = this.toolkit.createComposite(this.generalComposite);
        GridData gridData = new GridData(1808);
        gridData.verticalSpan = 1;
        gridData.horizontalSpan = 3;
        pane1.setLayoutData((Object)gridData);
        pane1.setLayout((Layout)new GridLayout());
        Label l_name = this.toolkit.createLabel(pane1, AuthoringUIText.STEPS_TEXT);
        GridData gridData2 = new GridData(1);
        gridData2.horizontalSpan = 3;
        l_name.setLayoutData((Object)gridData2);
        this.ctrl_steps = this.toolkit.createTable(pane1, 2);
        gridData2 = new GridData(1808);
        gridData2.horizontalSpan = 3;
        gridData2.heightHint = 150;
        this.ctrl_steps.setLayoutData((Object)gridData2);
        this.initProviders();
        this.stepsTableViewer = new TableViewer(this.ctrl_steps);
        this.stepsTableViewer.setContentProvider((IContentProvider)this.stepsViewerContentProvider);
        this.stepsTableViewer.setLabelProvider((IBaseLabelProvider)this.stepsViewerLabelProvider);
        Composite pane2 = this.toolkit.createComposite(this.generalComposite);
        pane2.setLayoutData((Object)new GridData(68));
        pane2.setLayout((Layout)new GridLayout());
        this.ctrl_add = this.toolkit.createButton(pane2, AuthoringUIText.ADD_BUTTON_TEXT, 0);
        this.ctrl_add.setLayoutData((Object)new GridData(768));
        this.ctrl_delete = this.toolkit.createButton(pane2, AuthoringUIText.DELETE_BUTTON_TEXT, 0);
        this.ctrl_delete.setLayoutData((Object)new GridData(768));
        this.ctrl_delete.setEnabled(false);
        this.ctrl_up = this.toolkit.createButton(pane2, AuthoringUIText.UP_BUTTON_TEXT, 0);
        this.ctrl_up.setLayoutData((Object)new GridData(768));
        this.ctrl_up.setEnabled(false);
        this.ctrl_down = this.toolkit.createButton(pane2, AuthoringUIText.DOWN_BUTTON_TEXT, 0);
        this.ctrl_down.setLayoutData((Object)new GridData(768));
        this.ctrl_down.setEnabled(false);
        this.ctrl_ordering = this.toolkit.createButton(pane2, AuthoringUIText.ORDER_BUTTON_TEXT, 0);
        this.ctrl_ordering.setLayoutData((Object)new GridData(768));
        Label nameLabel = this.toolkit.createLabel(this.generalComposite, AuthoringUIText.STEP_NAME_TEXT);
        GridData gridData3 = new GridData(1);
        gridData3.horizontalSpan = 4;
        nameLabel.setLayoutData((Object)gridData3);
        this.ctrl_name = new Text(this.generalComposite, 4);
        gridData3 = new GridData(768);
        gridData3.horizontalSpan = 4;
        this.ctrl_name.setLayoutData((Object)gridData3);
        TaskStepsPage.createBlankLabel(this.toolkit, this.generalComposite, 4);
        ImageHyperlink link = this.createImageHyperlink(this.toolkit, this.generalComposite, null, AuthoringUIImages.IMG_COLLAPSED);
        TaskStepsPage.createLabel(this.toolkit, this.generalComposite, AuthoringUIText.DESCRIPTION_TEXT);
        GridData gridData4 = new GridData(1);
        gridData4.horizontalSpan = 4;
        this.ctrl_maindesc = MethodFormToolkit.createRichText(this.toolkit, this.generalComposite, "", 578, this.contentElementPath, (MethodElement)this.task);
        gridData4 = new GridData(768);
        gridData4.heightHint = 250;
        gridData4.widthHint = 300;
        gridData4.horizontalSpan = 4;
        this.ctrl_maindesc.setLayoutData(gridData4);
        link.setHref((Object)this.ctrl_maindesc);
        link.setData("Title", (Object)AuthoringUIText.DESCRIPTION_TEXT);
        link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                TaskStepsPage.this.toggle(e);
            }
        });
        this.createRichTextEditorSection();
        this.toolkit.paintBordersFor(pane1);
        this.toolkit.paintBordersFor(pane2);
        this.toolkit.paintBordersFor(this.generalComposite);
        this.toolkit.paintBordersFor(this.expandedComposite);
        this.actionMgr = ((MethodElementEditor)this.getEditor()).getActionManager();
        this.addListeners();
        this.loadData();
        this.enableControls();
    }

    public void addListeners() {
        MethodElementEditor editor = (MethodElementEditor)this.getEditor();
        this.contentModifyListener = editor.createModifyListener((EObject)this.currentStep);
        this.ctrl_name.addModifyListener((ModifyListener)this.contentModifyListener);
        this.contentModifyListener.setDisable(true);
        this.form.addListener(26, new Listener(){

            public void handleEvent(Event e) {
                IStatus status = TngUtil.checkEdit((EObject)TaskStepsPage.this.task, (Object)TaskStepsPage.this.getSite().getShell());
                if (status.isOK()) {
                    TaskStepsPage.this.loadData();
                }
                if (TngUtil.isLocked((EObject)TaskStepsPage.this.contentElement)) {
                    TaskStepsPage.this.enableControls(false);
                } else {
                    TaskStepsPage.this.ctrl_add.setEnabled(true);
                    TaskStepsPage.this.checkSelection();
                }
            }
        });
        this.form.addListener(27, new Listener(){

            public void handleEvent(Event e) {
                TaskStepsPage.this.deactivate();
            }
        });
        this.ctrl_name.addModifyListener((ModifyListener)this.contentModifyListener);
        this.ctrl_name.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (TaskStepsPage.this.currentStep != null) {
                    String oldContent = TaskStepsPage.this.currentStep.getName();
                    String newContent = TaskStepsPage.this.ctrl_name.getText();
                    if (TaskStepsPage.this.ctrl_name.getText() == null || TaskStepsPage.this.ctrl_name.getText().length() == 0) {
                        String title = AuthoringUIResources.formatString("AuthoringUI.renameDialog.title", LibraryUIText.TEXT_STEP);
                        String msg = AuthoringUIResources.formatString("AuthoringUI.emptyElementNameError.msg", StrUtil.toLower((String)LibraryUIText.TEXT_STEP));
                        AuthoringUIPlugin.getDefault().getMsgDialog().displayError(title, msg);
                        TaskStepsPage.this.ctrl_name.setSelection(0, oldContent.length());
                    } else if (!newContent.equals(oldContent)) {
                        TaskStepsPage.this.actionMgr.doAction(1, (EObject)TaskStepsPage.this.currentStep, (EStructuralFeature)UmaPackage.eINSTANCE.getNamedElement_Name(), (Object)newContent, -1);
                    }
                }
            }
        });
        this.ctrl_maindesc.addModifyListener(this.contentModifyListener);
        this.ctrl_maindesc.addListener(27, new Listener(){

            public void handleEvent(Event e) {
                TaskStepsPage.this.saveMainDescription();
            }
        });
        this.stepsTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TaskStepsPage.this.checkSelection();
            }
        });
        this.ctrl_add.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                com.ibm.uma.Section child = UmaFactory.eINSTANCE.createSection();
                String newName = MessageFormat.format(AuthoringUIText.NEW_ELEMENT_TEXT, LibraryUIText.TEXT_STEP);
                child.setName(newName);
                AddToSectionListCommand cmd = new AddToSectionListCommand((ContentElement)TaskStepsPage.this.task, child, TaskStepsPage.this.allSteps);
                TaskStepsPage.this.getActionManager().execute((IResourceAwareCommand)cmd);
                TaskStepsPage.this.stepsTableViewer.refresh();
                TaskStepsPage.this.stepsTableViewer.setSelection((ISelection)new StructuredSelection((Object)child));
                TaskStepsPage.this.ctrl_name.setFocus();
                TaskStepsPage.this.ctrl_name.setSelection(0, newName.length());
            }
        });
        this.ctrl_delete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)TaskStepsPage.this.stepsTableViewer.getSelection();
                Iterator iter = selection.toList().iterator();
                while (iter.hasNext()) {
                    Object o = iter.next();
                    if (!(o instanceof com.ibm.uma.Section)) continue;
                    RemoveFromSectionList cmd = new RemoveFromSectionList((ContentElement)TaskStepsPage.this.task, (com.ibm.uma.Section)o, TaskStepsPage.this.allSteps);
                    TaskStepsPage.this.getActionManager().execute((IResourceAwareCommand)cmd);
                }
                TaskStepsPage.this.stepsTableViewer.refresh();
                TaskStepsPage.this.editStep(null);
            }
        });
        this.ctrl_up.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)TaskStepsPage.this.stepsTableViewer.getSelection();
                ArrayList moveUpItems = new ArrayList();
                moveUpItems.addAll(selection.toList());
                MoveInSectionListCommand cmd = new MoveInSectionListCommand((ContentElement)TaskStepsPage.this.task, moveUpItems, TaskStepsPage.this.allSteps, 1);
                TaskStepsPage.this.getActionManager().execute((IResourceAwareCommand)cmd);
                TaskStepsPage.this.stepsTableViewer.refresh();
                if (TaskStepsPage.this.stepsTableViewer.getTable().getSelectionIndex() > 0 && !TngUtil.isLocked((EObject)TaskStepsPage.this.task)) {
                    TaskStepsPage.this.ctrl_up.setEnabled(true);
                } else {
                    TaskStepsPage.this.ctrl_up.setEnabled(false);
                }
                if (TaskStepsPage.this.stepsTableViewer.getTable().getSelectionIndex() < TaskStepsPage.this.stepsTableViewer.getTable().getItemCount() - 1 && !TngUtil.isLocked((EObject)TaskStepsPage.this.task)) {
                    TaskStepsPage.this.ctrl_down.setEnabled(true);
                } else {
                    TaskStepsPage.this.ctrl_down.setEnabled(false);
                }
            }
        });
        this.ctrl_down.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)TaskStepsPage.this.stepsTableViewer.getSelection();
                ArrayList moveDownItems = new ArrayList();
                moveDownItems.addAll(selection.toList());
                MoveInSectionListCommand cmd = new MoveInSectionListCommand((ContentElement)TaskStepsPage.this.task, moveDownItems, TaskStepsPage.this.allSteps, 0);
                TaskStepsPage.this.getActionManager().execute((IResourceAwareCommand)cmd);
                TaskStepsPage.this.stepsTableViewer.refresh();
                if (TaskStepsPage.this.stepsTableViewer.getTable().getSelectionIndex() > 0 && !TngUtil.isLocked((EObject)TaskStepsPage.this.task)) {
                    TaskStepsPage.this.ctrl_up.setEnabled(true);
                } else {
                    TaskStepsPage.this.ctrl_up.setEnabled(false);
                }
                if (TaskStepsPage.this.stepsTableViewer.getTable().getSelectionIndex() < TaskStepsPage.this.stepsTableViewer.getTable().getItemCount() - 1 && !TngUtil.isLocked((EObject)TaskStepsPage.this.task)) {
                    TaskStepsPage.this.ctrl_down.setEnabled(true);
                } else {
                    TaskStepsPage.this.ctrl_down.setEnabled(false);
                }
            }
        });
        this.ctrl_ordering.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SectionsOrderDialog dlg = new SectionsOrderDialog(Display.getCurrent().getActiveShell(), (ContentElement)TaskStepsPage.this.task, TaskStepsPage.this.getActionManager(), AuthoringUIResources.getString("AuthoringUI.StepsOrderDialog.title"), AuthoringUIResources.getString("AuthoringUI.StepsOrderDialog.description"), AuthoringUIResources.getString("AuthoringUI.steps.text"));
                dlg.open();
            }
        });
    }

    protected void enableControls(boolean editable) {
        this.ctrl_name.setEditable(editable);
        this.ctrl_maindesc.setEditable(editable);
        this.ctrl_add.setEnabled(editable);
        this.ctrl_delete.setEnabled(editable);
        this.ctrl_up.setEnabled(editable);
        this.ctrl_down.setEnabled(editable);
        this.ctrl_ordering.setEnabled(true);
        if (this.ctrl_expanded != null) {
            this.ctrl_expanded.setEditable(editable);
        }
    }

    protected void deactivate() {
        if (this.allSteps != null) {
            this.allSteps.apply();
        }
    }

    private void loadData() {
        this.allSteps = null;
        this.stepsTableViewer.setInput((Object)this.task);
        this.stepsTableViewer.refresh();
        this.editStep(this.currentStep);
    }

    private void editStep(com.ibm.uma.Section step) {
        this.contentModifyListener.setDisable(true);
        if (this.ctrl_maindesc.getModified()) {
            this.saveMainDescription();
        }
        this.currentStep = step;
        String name = "";
        String desc = "";
        if (this.currentStep != null) {
            name = this.currentStep.getName();
            desc = this.currentStep.getSectionDescription();
            this.ctrl_name.setFocus();
        }
        this.ctrl_name.setText(name == null ? "" : name);
        this.ctrl_maindesc.setText(desc == null ? "" : desc);
        this.ctrl_maindesc.setModalObject((EObject)this.currentStep);
        this.ctrl_maindesc.setModalObjectFeature((EStructuralFeature)UmaPackage.eINSTANCE.getSection_SectionDescription());
        this.contentModifyListener.setElement((EObject)this.currentStep);
        this.contentModifyListener.setDisable(this.currentStep == null);
        this.enableControls();
    }

    private void enableControls() {
        if (this.task.getPresentation().getSections().contains(this.currentStep)) {
            if (!TngUtil.isLocked((EObject)this.contentElement)) {
                this.ctrl_name.setEditable(true);
                this.ctrl_maindesc.setEditable(true);
            }
        } else {
            this.ctrl_name.setEditable(false);
            this.ctrl_maindesc.setEditable(false);
        }
    }

    public void dispose() {
    }

    private void createRichTextEditorSection() {
        this.expandedComposite = this.toolkit.createComposite((Composite)this.generalSection);
        this.expandedComposite.setLayoutData((Object)new GridData(768));
        this.expandedComposite.setLayout((Layout)new GridLayout(2, false));
        this.expandedComposite.setVisible(false);
        this.expandLink = this.toolkit.createImageHyperlink(this.expandedComposite, 0);
        this.expandLink.setImage(AuthoringUIImages.IMG_EXPANDED);
        this.expandLink.setUnderlined(false);
        this.expandLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                TaskStepsPage.this.toggle(e);
            }
        });
        this.expandLabel = TaskStepsPage.createLabel(this.toolkit, this.expandedComposite, "");
    }

    protected void toggle(HyperlinkEvent e) {
        if (this.ctrl_expanded == null) {
            this.ctrl_expanded = this.createRichTextEditor(this.toolkit, this.expandedComposite, 578, 1808, 400, 400, 2);
            this.ctrl_expanded.addModifyListener(this.contentModifyListener);
        }
        if (this.descExpandFlag) {
            this.generalComposite.setVisible(true);
            this.expandedComposite.setVisible(false);
            this.generalSection.setClient((Control)this.generalComposite);
            IMethodRichText richText = this.activeControl;
            richText.setText(this.ctrl_expanded.getText());
            Iterator i = richText.getListeners();
            while (i.hasNext()) {
                RichTextListener listener = (RichTextListener)i.next();
                this.ctrl_expanded.removeListener(listener.getEventType(), listener.getListener());
            }
            if (this.ctrl_expanded.getModified()) {
                ((MethodElementEditor)this.getEditor()).saveModifiedRichText(this.ctrl_expanded);
            }
            richText.setFocus();
        } else {
            this.ctrl_expanded.setEditable(true);
            this.generalComposite.setVisible(false);
            this.expandedComposite.setVisible(true);
            this.generalSection.setClient((Control)this.expandedComposite);
            this.expandLabel.setText((String)((ImageHyperlink)e.getSource()).getData("Title"));
            IMethodRichText richText = (IMethodRichText)e.getHref();
            this.ctrl_expanded.setText(richText.getText());
            this.ctrl_expanded.setModalObject(richText.getModalObject());
            this.ctrl_expanded.setModalObjectFeature(richText.getModalObjectFeature());
            Iterator i = richText.getListeners();
            while (i.hasNext()) {
                RichTextListener listener = (RichTextListener)i.next();
                this.ctrl_expanded.addListener(listener.getEventType(), listener.getListener());
            }
            this.ctrl_expanded.setEditable(!TngUtil.isLocked((EObject)this.contentElement));
            this.ctrl_expanded.setFocus();
            this.activeControl = richText;
        }
        this.generalSection.layout(true);
        this.descExpandFlag = !this.descExpandFlag;
    }

    private void initProviders() {
        this.stepsViewerContentProvider = new AdapterFactoryContentProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory()){

            public Object[] getElements(Object object) {
                if (TaskStepsPage.this.allSteps == null) {
                    TaskStepsPage.this.allSteps = new SectionList((ContentElement)TaskStepsPage.this.task, 1);
                }
                return TaskStepsPage.this.allSteps.toArray();
            }
        };
        this.stepsViewerLabelProvider = new VariabilityElementLabelProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory()){

            public boolean isExternal(Object element) {
                return !TaskStepsPage.this.task.getPresentation().getSections().contains(element);
            }
        };
    }

    private void saveMainDescription() {
        if (this.currentStep != null) {
            IMethodRichText control;
            IMethodRichText iMethodRichText = control = this.descExpandFlag ? this.ctrl_expanded : this.ctrl_maindesc;
            if (!control.getModified()) {
                return;
            }
            String oldContent = this.currentStep.getSectionDescription();
            if (((MethodElementEditor)this.getEditor()).mustRestoreValue(control, oldContent)) {
                return;
            }
            String newContent = control.getText();
            if (!newContent.equals(oldContent)) {
                this.actionMgr.doAction(1, (EObject)this.currentStep, (EStructuralFeature)UmaPackage.eINSTANCE.getSection_SectionDescription(), (Object)newContent, -1);
            }
        }
    }

    protected IActionManager getActionManager() {
        FormEditor editor = this.getEditor();
        if (editor instanceof MethodElementEditor) {
            return ((MethodElementEditor)editor).getActionManager();
        }
        return null;
    }

    private void checkSelection() {
        IStructuredSelection selection = (IStructuredSelection)this.stepsTableViewer.getSelection();
        if (selection.size() > 0 && !TngUtil.isLocked((EObject)this.task)) {
            this.ctrl_delete.setEnabled(true);
            if (this.stepsTableViewer.getTable().getSelectionIndex() > 0 && !TngUtil.isLocked((EObject)this.task) && selection.size() == 1) {
                this.ctrl_up.setEnabled(true);
            } else {
                this.ctrl_up.setEnabled(false);
            }
            if (this.stepsTableViewer.getTable().getSelectionIndex() < this.stepsTableViewer.getTable().getItemCount() - 1 && !TngUtil.isLocked((EObject)this.task) && selection.size() == 1) {
                this.ctrl_down.setEnabled(true);
            } else {
                this.ctrl_down.setEnabled(false);
            }
        }
        if (selection.size() == 1) {
            this.editStep((com.ibm.uma.Section)selection.getFirstElement());
        }
    }
}

