/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.forms;

import com.ibm.uma.ContentDescription;
import com.ibm.uma.GuidanceDescription;
import com.ibm.uma.MethodElement;
import com.ibm.uma.UmaPackage;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.AuthoringUIText;
import org.eclipse.epf.authoring.ui.editors.MethodElementEditor;
import org.eclipse.epf.authoring.ui.forms.GuidanceDescriptionPage;
import org.eclipse.epf.library.edit.command.IActionManager;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.services.LibraryProcessor;
import org.eclipse.epf.library.util.ResourceHelper;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class TemplateDescriptionPage
extends GuidanceDescriptionPage {
    private Button ctrl_attach;
    private Button ctrl_detach;
    private org.eclipse.swt.widgets.List ctrl_template_file;
    private static final String TEMPLATE_ATTACHMENT_LAST_DIRECTORY_BROWSED_PREF = "template_attachment_last_dir_browsed";

    public TemplateDescriptionPage(FormEditor editor) {
        super(editor);
    }

    protected void createEditorContent(FormToolkit toolkit) {
        super.createEditorContent(toolkit);
        TemplateDescriptionPage.createLabel(toolkit, this.generalComposite, AuthoringUIText.TEMPLATE_FILE_TEXT, 2);
        this.ctrl_template_file = new org.eclipse.swt.widgets.List(this.generalComposite, 772);
        GridData listGridData = new GridData(1, 1, true, true);
        listGridData.heightHint = 30;
        listGridData.widthHint = 300;
        this.ctrl_template_file.setLayoutData((Object)listGridData);
        this.ctrl_template_file.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        Composite buttonComposite = TemplateDescriptionPage.createComposite(toolkit, this.generalComposite, 1);
        GridData gridData = new GridData(128);
        gridData.verticalSpan = 1;
        gridData.horizontalSpan = 3;
        buttonComposite.setLayoutData((Object)gridData);
        buttonComposite.setLayout((Layout)new GridLayout(3, false));
        this.ctrl_attach = TemplateDescriptionPage.createButton(toolkit, buttonComposite, 7);
        this.ctrl_detach = TemplateDescriptionPage.createButton(toolkit, buttonComposite, 8);
        this.label_base.setText(AuthoringUIText.BASE_GUIDANCE_TEXT);
    }

    protected void addListeners() {
        super.addListeners();
        final IActionManager actionMgr = ((MethodElementEditor)this.getEditor()).getActionManager();
        this.ctrl_attach.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
                dialog.setText(AuthoringUIResources.getString("AuthoringUI.attachTemplateFileDialog.title"));
                String lastDir = AuthoringUIPlugin.getDefault().getPreferenceStore().getString(TemplateDescriptionPage.TEMPLATE_ATTACHMENT_LAST_DIRECTORY_BROWSED_PREF);
                if (lastDir != null && lastDir.trim().length() > 0) {
                    dialog.setFilterPath(lastDir);
                } else {
                    dialog.setFilterPath(String.valueOf(LibraryProcessor.getInstance().getLibraryRootPath().getAbsolutePath()) + File.separator + ResourceHelper.getElementPath((MethodElement)TemplateDescriptionPage.this.guidance));
                }
                dialog.open();
                if (dialog.getFileName() != null && dialog.getFileName() != "") {
                    try {
                        File fileToAttach = new File(dialog.getFilterPath(), dialog.getFileName());
                        String fileUrl = ResourceHelper.getURLForAttachment((File)fileToAttach, (MethodElement)TemplateDescriptionPage.this.guidance, (boolean)true);
                        if (TemplateDescriptionPage.this.ctrl_template_file.indexOf(fileUrl) != -1) {
                            AuthoringUIPlugin.getDefault().getMsgDialog().displayInfo(AuthoringUIResources.getString("AuthoringUI.AttachmentDialogattachFile.text"), AuthoringUIResources.getString("AuthoringUI.forms.TemplateDescriptionPage.alreadyAttached.msg"));
                            return;
                        }
                        TemplateDescriptionPage.this.ctrl_template_file.add(fileUrl);
                        boolean status = actionMgr.doAction(1, (EObject)TemplateDescriptionPage.this.guidance.getPresentation(), (EStructuralFeature)UmaPackage.eINSTANCE.getGuidanceDescription_Attachments(), (Object)TemplateDescriptionPage.this.getFilesFromListCtrl(), -1);
                        if (!status) {
                            return;
                        }
                        AuthoringUIPlugin.getDefault().getPreferenceStore().setValue(TemplateDescriptionPage.TEMPLATE_ATTACHMENT_LAST_DIRECTORY_BROWSED_PREF, dialog.getFilterPath());
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
        this.ctrl_detach.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TemplateDescriptionPage.this.ctrl_template_file.remove(TemplateDescriptionPage.this.ctrl_template_file.getSelectionIndex());
                boolean status = actionMgr.doAction(1, (EObject)TemplateDescriptionPage.this.guidance.getPresentation(), (EStructuralFeature)UmaPackage.eINSTANCE.getGuidanceDescription_Attachments(), (Object)TemplateDescriptionPage.this.getFilesFromListCtrl(), -1);
                if (!status) {
                    return;
                }
            }
        });
    }

    protected void refresh(boolean editable) {
        super.refresh(editable);
        this.ctrl_attach.setEnabled(editable);
        this.ctrl_detach.setEnabled(editable);
    }

    protected void loadData() {
        super.loadData();
        if (this.guidance != null) {
            ContentDescription content = this.guidance.getPresentation();
            String thirdpartyformat = ((GuidanceDescription)content).getAttachments();
            this.setFilesToListCtrl(thirdpartyformat);
        }
    }

    protected Object getContentElement() {
        return this.contentElement;
    }

    private void setFilesToListCtrl(String fileString) {
        List attachmentList = TngUtil.convertTemplateAttachmentsToList((String)fileString);
        this.ctrl_template_file.removeAll();
        Iterator iter = attachmentList.iterator();
        while (iter.hasNext()) {
            String attachment = (String)iter.next();
            this.ctrl_template_file.add(attachment);
        }
    }

    private String getFilesFromListCtrl() {
        String[] files = this.ctrl_template_file.getItems();
        return TngUtil.convertTemplateAttachmentsToString(Arrays.asList(files));
    }
}

