/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.properties;

import com.ibm.uma.BreakdownElement;
import com.ibm.uma.MethodConfiguration;
import com.ibm.uma.Process;
import com.ibm.uma.RoleDescriptor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.editors.ProcessEditor;
import org.eclipse.epf.authoring.ui.properties.BreakdownElementGeneralSection;
import org.eclipse.epf.authoring.ui.properties.TNGPropertySheetPage;
import org.eclipse.epf.common.serviceability.Logger;
import org.eclipse.epf.library.configuration.ProcessConfigurator;
import org.eclipse.epf.library.edit.process.BreakdownElementWrapperItemProvider;
import org.eclipse.epf.library.edit.process.IBSItemProvider;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.events.ILibraryChangeListener;
import org.eclipse.epf.library.services.LibraryProcessor;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.wst.common.ui.properties.internal.provisional.AbstractPropertySection;
import org.eclipse.wst.common.ui.properties.internal.provisional.ISection;
import org.eclipse.wst.common.ui.properties.internal.provisional.TabbedPropertySheetPage;
import org.eclipse.wst.common.ui.properties.internal.view.Tab;

public class AbstractSection
extends AbstractPropertySection
implements PropertyChangeListener {
    private BreakdownElement element;
    protected boolean editable = false;
    protected TabbedPropertySheetPage page;
    protected ProcessConfigurator configurator = new ProcessConfigurator(LibraryProcessor.getInstance().getCurrentMethodConfiguration(), null);
    protected Logger logger;
    private ILibraryChangeListener libraryListener = new ILibraryChangeListener(){

        public void libraryChanged(int option, Collection collection) {
            switch (option) {
                case 8: {
                    AbstractSection.this.sectionRefresh();
                }
            }
        }
    };
    static /* synthetic */ Class class$0;

    public AbstractSection() {
        LibraryProcessor.getInstance().addListener(this.libraryListener);
        this.logger = AuthoringUIPlugin.getDefault().getLogger();
    }

    public void createControls(Composite comp, TabbedPropertySheetPage page) {
        super.createControls(comp, page);
        this.page = page;
    }

    private void sectionRefresh() {
        ISection section;
        Tab tab;
        if (this.page != null && (tab = this.page.getCurrentTab()) != null && (section = tab.getSectionAtIndex(0)) != null && section instanceof BreakdownElementGeneralSection) {
            section.refresh();
        }
    }

    public void dispose() {
        super.dispose();
        if (this.libraryListener != null) {
            LibraryProcessor.getInstance().removeListener(this.libraryListener);
        }
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        Assert.isTrue((boolean)(selection instanceof IStructuredSelection));
        Object input = ((IStructuredSelection)selection).getFirstElement();
        this.initElementData(input);
    }

    private void initElementData(Object input) {
        if (input instanceof BreakdownElement) {
            this.element = (BreakdownElement)input;
            if (TngUtil.isLocked((EObject)this.element)) {
                this.editable = false;
            } else {
                this.editable = true;
                if (this.element instanceof RoleDescriptor) {
                    RoleDescriptor roleDesc = (RoleDescriptor)this.element;
                    this.editable = roleDesc.getSuperActivities() != null && !roleDesc.getSuperActivities().isEmpty();
                }
            }
        } else if (input instanceof BreakdownElementWrapperItemProvider) {
            this.element = (BreakdownElement)LibraryUtil.unwrap((Object)input);
            this.editable = false;
        }
    }

    public ISelection getSelection() {
        return TNGPropertySheetPage.getSelection();
    }

    public ProcessEditor getEditor() {
        return TNGPropertySheetPage.getEditor();
    }

    public ItemProviderAdapter getAdapter() {
        try {
            AdapterFactory factory = TNGPropertySheetPage.getAdapterFactory();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ItemProviderAdapter provider = (ItemProviderAdapter)factory.adapt((Notifier)this.element, (Object)clazz);
            return provider;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public AdapterFactory getAdapterFactory() {
        AdapterFactory adapterFactory = TNGPropertySheetPage.getAdapterFactory();
        return adapterFactory;
    }

    public BreakdownElement getElement() {
        ISelection selection = this.getSelection();
        if (selection instanceof IStructuredSelection) {
            Object input = ((IStructuredSelection)selection).getFirstElement();
            try {
                this.initElementData(input);
            }
            catch (Exception e) {
                this.logger.logError("Error getting element from the selection " + this.element, (Throwable)e);
                return null;
            }
            return this.element;
        }
        return null;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.refresh();
    }

    public List getFilteredList(List list) {
        ArrayList newList = new ArrayList();
        Iterator itor = list.iterator();
        while (itor.hasNext()) {
            if (this.configurator == null) continue;
            Object obj = itor.next();
            this.configurator.setMethodConfiguration(LibraryProcessor.getInstance().getCurrentMethodConfiguration());
            if (!this.configurator.accept(obj)) continue;
            newList.add(obj);
        }
        return newList;
    }

    protected MethodConfiguration getDefaultConfiguration() {
        ItemProviderAdapter adapter = this.getAdapter();
        Object parent = null;
        if (adapter != null) {
            IBSItemProvider bsItemProvider = (IBSItemProvider)adapter;
            parent = bsItemProvider.getTopItem();
            MethodConfiguration config = ((Process)parent).getDefaultContext();
            return config;
        }
        this.logger.logError("AbstractSection::getDefaultConfiguration - IBSItemProvider is null");
        return null;
    }

    public String getNamePrefix() {
        return "ProcessElement: ";
    }
}

