/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.properties;

import com.ibm.uma.Activity;
import com.ibm.uma.CapabilityPattern;
import com.ibm.uma.DeliveryProcess;
import com.ibm.uma.Iteration;
import com.ibm.uma.Phase;
import com.ibm.uma.Process;
import org.eclipse.epf.authoring.ui.properties.FormUI;
import org.eclipse.epf.authoring.ui.properties.PropertiesResources;
import org.eclipse.epf.authoring.ui.properties.PropertiesUtil;
import org.eclipse.epf.authoring.ui.properties.WorkBreakdownElementGeneralSection;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.library.edit.process.IBSItemProvider;
import org.eclipse.epf.library.ui.LibraryUIText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class ActivityGeneralSection
extends WorkBreakdownElementGeneralSection {
    protected Activity element;
    private String[] items = new String[]{LibraryUIText.TEXT_ACTIVITY, LibraryUIText.TEXT_ITERATION, LibraryUIText.TEXT_PHASE};
    private Text modelInfoText;
    private Label activityTypeLabel;
    private Combo activityType;

    protected void init() {
        super.init();
        this.element = (Activity)this.getElement();
    }

    protected void createGeneralSection(Composite composite) {
        super.createGeneralSection(composite);
        FormUI.createLabel(this.toolkit, this.generalComposite, PropertiesResources.getString("Activity.ModelInfo"));
        this.modelInfoText = FormUI.createText(this.toolkit, this.generalComposite, -1, this.horizontalSpan);
        this.modelInfoText.setEnabled(false);
        this.modelInfoText.setText(this.getModelInfo());
        this.activityTypeLabel = FormUI.createLabel(this.toolkit, this.generalComposite, PropertiesResources.getString("Activity.Type"));
        this.activityType = FormUI.createCombo(this.toolkit, this.generalComposite, this.horizontalSpan);
        this.activityType.setItems(this.items);
    }

    protected void addListeners() {
        super.addListeners();
        this.activityType.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private String getModelInfo() {
        String info = null;
        try {
            IBSItemProvider adapter = (IBSItemProvider)this.getAdapter();
            info = adapter.getAttribute((Object)this.element, "model_info");
        }
        catch (Exception exception) {}
        if (!StrUtil.isBlank(info)) {
            return info;
        }
        return PropertiesResources.getString("Process.None");
    }

    protected void updateControls() {
        super.updateControls();
        this.activityType.setEnabled(this.editable);
    }

    public void refresh() {
        try {
            if (this.getElement() instanceof Activity) {
                super.refresh();
                this.element = (Activity)this.getElement();
                this.modelInfoText.setText(this.getModelInfo());
                this.activityType.setText(PropertiesUtil.getType(this.element));
                if (!(this.element instanceof Process)) {
                    this.activityTypeLabel.setVisible(true);
                    this.activityType.setVisible(true);
                } else {
                    this.activityTypeLabel.setVisible(false);
                    this.activityType.setVisible(false);
                }
            }
        }
        catch (Exception ex) {
            this.logger.logError("Error refreshing Activity general section : " + this.element, (Throwable)ex);
        }
    }

    public String getNamePrefix() {
        if (this.element instanceof CapabilityPattern) {
            return String.valueOf(LibraryUIText.TEXT_CAPABILITY_PATTERN) + ": ";
        }
        if (this.element instanceof DeliveryProcess) {
            return String.valueOf(LibraryUIText.TEXT_DELIVERY_PROCESS) + ": ";
        }
        if (this.element instanceof Phase) {
            return String.valueOf(LibraryUIText.TEXT_PHASE) + ": ";
        }
        if (this.element instanceof Iteration) {
            return String.valueOf(LibraryUIText.TEXT_ITERATION) + ": ";
        }
        return String.valueOf(LibraryUIText.TEXT_ACTIVITY) + ": ";
    }
}

