/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.properties;

import com.ibm.uma.Activity;
import com.ibm.uma.Checklist;
import com.ibm.uma.Concept;
import com.ibm.uma.DeliveryProcess;
import com.ibm.uma.Example;
import com.ibm.uma.Guidance;
import com.ibm.uma.Guideline;
import com.ibm.uma.MethodConfiguration;
import com.ibm.uma.Process;
import com.ibm.uma.ReusableAsset;
import com.ibm.uma.Roadmap;
import com.ibm.uma.SupportingMaterial;
import com.ibm.uma.UmaPackage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.epf.authoring.ui.dialogs.ItemsFilterDialog;
import org.eclipse.epf.authoring.ui.filters.ProcessGuidanceFilter;
import org.eclipse.epf.authoring.ui.properties.AbstractSection;
import org.eclipse.epf.authoring.ui.properties.FormUI;
import org.eclipse.epf.authoring.ui.properties.PropertiesResources;
import org.eclipse.epf.authoring.ui.properties.TNGPropertySheetPage;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.command.IActionManager;
import org.eclipse.epf.library.edit.configuration.GuidanceGroupingItemProvider;
import org.eclipse.epf.library.edit.configuration.GuidanceItemProvider;
import org.eclipse.epf.library.edit.itemsfilter.FilterConstants;
import org.eclipse.epf.library.edit.process.IBSItemProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.wst.common.ui.properties.internal.provisional.TabbedPropertySheetPage;

public class ActivityGuidanceSection
extends AbstractSection {
    protected ILabelProvider labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory());
    private FormToolkit toolkit;
    private Button ctrl_add_1;
    private Button ctrl_remove_1;
    private Button ctrl_add_2;
    private Button ctrl_remove_2;
    private Button ctrl_add_3;
    private Button ctrl_remove_3;
    private Button ctrl_add_4;
    private Button ctrl_remove_4;
    private Table ctrl_table_1;
    private Table ctrl_table_2;
    private Table ctrl_table_3;
    private Table ctrl_table_4;
    private Section communicationMaterialSection;
    private Section educationMaterialSection;
    private TableViewer viewer_1;
    private TableViewer viewer_2;
    private TableViewer viewer_3;
    private TableViewer viewer_4;
    private Activity element;
    private IActionManager actionMgr;

    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        this.init();
        parent.setLayout((Layout)new GridLayout());
        parent.setLayoutData((Object)new GridData(1808));
        this.createGuidanceSection(parent);
        this.addListeners();
        this.updateControls();
    }

    private void init() {
        this.element = (Activity)this.getElement();
        this.toolkit = this.getWidgetFactory();
        this.actionMgr = TNGPropertySheetPage.getActionManager();
    }

    private void toggleSection() {
        if (!(this.element instanceof DeliveryProcess)) {
            if (this.communicationMaterialSection.isExpanded()) {
                this.communicationMaterialSection.setExpanded(false);
            }
            if (this.educationMaterialSection.isExpanded()) {
                this.educationMaterialSection.setExpanded(false);
            }
            if (this.communicationMaterialSection.isVisible()) {
                this.communicationMaterialSection.setVisible(false);
            }
            if (this.educationMaterialSection.isVisible()) {
                this.educationMaterialSection.setVisible(false);
            }
        } else {
            if (!this.communicationMaterialSection.isExpanded()) {
                this.communicationMaterialSection.setExpanded(true);
            }
            if (!this.educationMaterialSection.isExpanded()) {
                this.educationMaterialSection.setExpanded(true);
            }
            if (!this.communicationMaterialSection.isVisible()) {
                this.communicationMaterialSection.setVisible(true);
            }
            if (!this.educationMaterialSection.isVisible()) {
                this.educationMaterialSection.setVisible(true);
            }
        }
    }

    public void updateControls() {
        this.ctrl_add_1.setEnabled(this.editable);
        this.ctrl_add_2.setEnabled(this.editable);
        this.ctrl_add_3.setEnabled(this.editable);
        this.ctrl_add_4.setEnabled(this.editable);
        IStructuredSelection selection = (IStructuredSelection)this.viewer_1.getSelection();
        if (selection.size() > 0 && this.editable) {
            this.ctrl_remove_1.setEnabled(true);
        } else {
            this.ctrl_remove_1.setEnabled(false);
        }
        selection = (IStructuredSelection)this.viewer_2.getSelection();
        if (selection.size() > 0 && this.editable) {
            this.ctrl_remove_2.setEnabled(true);
        } else {
            this.ctrl_remove_2.setEnabled(false);
        }
        selection = (IStructuredSelection)this.viewer_3.getSelection();
        if (selection.size() > 0 && this.editable) {
            this.ctrl_remove_3.setEnabled(true);
        } else {
            this.ctrl_remove_3.setEnabled(false);
        }
        selection = (IStructuredSelection)this.viewer_4.getSelection();
        if (selection.size() > 0 && this.editable) {
            this.ctrl_remove_4.setEnabled(true);
        } else {
            this.ctrl_remove_4.setEnabled(false);
        }
    }

    public void refresh() {
        try {
            if (this.getElement() instanceof Activity) {
                this.element = (Activity)this.getElement();
                this.viewer_1.refresh();
                this.viewer_2.refresh();
                this.viewer_3.refresh();
                this.viewer_4.refresh();
                this.toggleSection();
                this.updateControls();
            }
        }
        catch (Exception ex) {
            this.logger.logError("Error refreshing activity guidance section: ", (Throwable)ex);
        }
    }

    public void dispose() {
        super.dispose();
        if (this.labelProvider != null) {
            this.labelProvider.dispose();
        }
    }

    private void createGuidanceSection(Composite composite) {
        int tableHeight = 50;
        String sectionTitle = null;
        String sectionDesc = null;
        String tableTitle = null;
        sectionTitle = PropertiesResources.getString("Activity.RoadmapTitle");
        sectionDesc = PropertiesResources.getString("Activity.RoadmapDescription");
        tableTitle = PropertiesResources.getString("Activity.Selected.Roadmap");
        Section section = FormUI.createSection(this.toolkit, composite, sectionTitle, sectionDesc);
        Composite sectionComposite = FormUI.createComposite(this.toolkit, section, 2, false);
        Composite pane1 = FormUI.createComposite(this.toolkit, sectionComposite, 1808);
        FormUI.createLabel(this.toolkit, pane1, tableTitle);
        this.ctrl_table_1 = FormUI.createTable(this.toolkit, pane1, tableHeight);
        this.viewer_1 = new TableViewer(this.ctrl_table_1);
        AdapterFactoryContentProvider contentProvider = new AdapterFactoryContentProvider(this.getAdapterFactory()){

            public Object[] getElements(Object object) {
                return ActivityGuidanceSection.this.getFilteredList(ActivityGuidanceSection.this.element.getRoadmaps()).toArray();
            }
        };
        this.viewer_1.setContentProvider((IContentProvider)contentProvider);
        this.viewer_1.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.viewer_1.setInput((Object)this.element);
        Composite pane2 = FormUI.createComposite(this.toolkit, sectionComposite, 68);
        this.ctrl_add_1 = FormUI.createButton(this.toolkit, pane2, PropertiesResources.getString("Process.Add"));
        this.ctrl_remove_1 = FormUI.createButton(this.toolkit, pane2, PropertiesResources.getString("Process.Remove"));
        this.toolkit.paintBordersFor(pane1);
        sectionTitle = PropertiesResources.getString("Activity.GeneralGuidanceTitle");
        sectionDesc = PropertiesResources.getString("Activity.GeneralGuidanceDescription");
        tableTitle = PropertiesResources.getString("Activity.Selected.GeneralGuidance");
        section = FormUI.createSection(this.toolkit, composite, sectionTitle, sectionDesc);
        sectionComposite = FormUI.createComposite(this.toolkit, section, 2, false);
        pane1 = FormUI.createComposite(this.toolkit, sectionComposite, 1808);
        FormUI.createLabel(this.toolkit, pane1, tableTitle);
        this.ctrl_table_2 = FormUI.createTable(this.toolkit, pane1, tableHeight);
        this.viewer_2 = new TableViewer(this.ctrl_table_2);
        contentProvider = new AdapterFactoryContentProvider(this.getAdapterFactory()){

            public Object[] getElements(Object object) {
                return ActivityGuidanceSection.this.getFilteredList(ActivityGuidanceSection.this.getSelectedGuidances()).toArray();
            }
        };
        this.viewer_2.setContentProvider((IContentProvider)contentProvider);
        this.viewer_2.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.viewer_2.setInput((Object)this.element);
        pane2 = FormUI.createComposite(this.toolkit, sectionComposite, 68);
        this.ctrl_add_2 = FormUI.createButton(this.toolkit, pane2, PropertiesResources.getString("Process.Add"));
        this.ctrl_remove_2 = FormUI.createButton(this.toolkit, pane2, PropertiesResources.getString("Process.Remove"));
        this.toolkit.paintBordersFor(pane1);
        sectionTitle = PropertiesResources.getString("Activity.CommunicationMaterialTitle");
        sectionDesc = PropertiesResources.getString("Activity.CommunicationMaterialDescription");
        tableTitle = PropertiesResources.getString("Activity.Selected.CommunicationMaterial");
        section = FormUI.createSection(this.toolkit, composite, sectionTitle, sectionDesc);
        sectionComposite = FormUI.createComposite(this.toolkit, section, 2, false);
        pane1 = FormUI.createComposite(this.toolkit, sectionComposite, 1808);
        FormUI.createLabel(this.toolkit, pane1, tableTitle);
        this.ctrl_table_3 = FormUI.createTable(this.toolkit, pane1, tableHeight);
        this.viewer_3 = new TableViewer(this.ctrl_table_3);
        contentProvider = new AdapterFactoryContentProvider(this.getAdapterFactory()){

            public Object[] getElements(Object object) {
                if (ActivityGuidanceSection.this.element instanceof DeliveryProcess) {
                    return ActivityGuidanceSection.this.getFilteredList(((DeliveryProcess)ActivityGuidanceSection.this.element).getCommunicationsMaterials()).toArray();
                }
                return Collections.EMPTY_LIST.toArray();
            }
        };
        this.viewer_3.setContentProvider((IContentProvider)contentProvider);
        this.viewer_3.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.viewer_3.setInput((Object)this.element);
        pane2 = FormUI.createComposite(this.toolkit, sectionComposite, 68);
        this.ctrl_add_3 = FormUI.createButton(this.toolkit, pane2, PropertiesResources.getString("Process.Add"));
        this.ctrl_remove_3 = FormUI.createButton(this.toolkit, pane2, PropertiesResources.getString("Process.Remove"));
        this.toolkit.paintBordersFor(pane1);
        this.communicationMaterialSection = section;
        sectionTitle = PropertiesResources.getString("Activity.EducationMaterialTitle");
        sectionDesc = PropertiesResources.getString("Activity.EducationMaterialDescription");
        tableTitle = PropertiesResources.getString("Activity.Selected.EducationMaterial");
        section = FormUI.createSection(this.toolkit, composite, sectionTitle, sectionDesc);
        sectionComposite = FormUI.createComposite(this.toolkit, section, 2, false);
        pane1 = FormUI.createComposite(this.toolkit, sectionComposite, 1808);
        FormUI.createLabel(this.toolkit, pane1, tableTitle);
        this.ctrl_table_4 = FormUI.createTable(this.toolkit, pane1, tableHeight);
        this.viewer_4 = new TableViewer(this.ctrl_table_4);
        contentProvider = new AdapterFactoryContentProvider(this.getAdapterFactory()){

            public Object[] getElements(Object object) {
                if (ActivityGuidanceSection.this.element instanceof DeliveryProcess) {
                    return ActivityGuidanceSection.this.getFilteredList(((DeliveryProcess)ActivityGuidanceSection.this.element).getEducationMaterials()).toArray();
                }
                return Collections.EMPTY_LIST.toArray();
            }
        };
        this.viewer_4.setContentProvider((IContentProvider)contentProvider);
        this.viewer_4.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.viewer_4.setInput((Object)this.element);
        pane2 = FormUI.createComposite(this.toolkit, sectionComposite, 68);
        this.ctrl_add_4 = FormUI.createButton(this.toolkit, pane2, PropertiesResources.getString("Process.Add"));
        this.ctrl_remove_4 = FormUI.createButton(this.toolkit, pane2, PropertiesResources.getString("Process.Remove"));
        this.toolkit.paintBordersFor(pane1);
        this.educationMaterialSection = section;
        this.toggleSection();
    }

    private void addListeners() {
        ItemProviderAdapter adapter = this.getAdapter();
        Object parent = null;
        if (adapter == null) {
            this.logger.logError("ActivityGuidanceSection::addListeners - IBSItemProvider is null");
            return;
        }
        IBSItemProvider bsItemProvider = (IBSItemProvider)adapter;
        parent = bsItemProvider.getTopItem();
        final String tabName = FilterConstants.GUIDANCE;
        final MethodConfiguration config = ((Process)parent).getDefaultContext();
        this.ctrl_table_1.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                IStructuredSelection selection = (IStructuredSelection)ActivityGuidanceSection.this.viewer_1.getSelection();
                if (selection.size() > 0 && ActivityGuidanceSection.this.editable) {
                    ActivityGuidanceSection.this.ctrl_remove_1.setEnabled(true);
                }
            }
        });
        this.viewer_1.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)ActivityGuidanceSection.this.viewer_1.getSelection();
                if (selection.size() > 0 && ActivityGuidanceSection.this.editable) {
                    ActivityGuidanceSection.this.ctrl_remove_1.setEnabled(true);
                }
            }
        });
        this.ctrl_add_1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProcessGuidanceFilter filter = new ProcessGuidanceFilter(this, config, null, tabName){
                    final /* synthetic */ 7 this$1;
                    {
                        this.this$1 = var1_1;
                        super($anonymous0, $anonymous1, $anonymous2);
                    }

                    public boolean childAccept(Object obj) {
                        if (obj instanceof GuidanceGroupingItemProvider) {
                            return true;
                        }
                        if (obj instanceof GuidanceItemProvider) {
                            String name = ((GuidanceItemProvider)obj).getText(obj);
                            return name.equalsIgnoreCase("Roadmap") && !((GuidanceItemProvider)obj).getChildren(obj).isEmpty();
                        }
                        return obj instanceof Roadmap;
                    }
                };
                ItemsFilterDialog fd = new ItemsFilterDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IFilter)filter, ActivityGuidanceSection.this.element, FilterConstants.ROADMAP, ActivityGuidanceSection.this.element.getRoadmaps());
                fd.setBlockOnOpen(true);
                fd.setTitle(FilterConstants.ROADMAP);
                fd.open();
                ActivityGuidanceSection.this.addGuidances(fd.getSelectedItems());
                ActivityGuidanceSection.this.viewer_1.refresh();
            }
        });
        this.ctrl_remove_1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)ActivityGuidanceSection.this.viewer_1.getSelection();
                if (selection.size() > 0) {
                    ArrayList rmItems = new ArrayList();
                    rmItems.addAll(selection.toList());
                    ActivityGuidanceSection.this.removeGuidances(rmItems);
                    ActivityGuidanceSection.this.viewer_1.refresh();
                    ActivityGuidanceSection.this.viewer_1.setSelection(null, true);
                }
                ActivityGuidanceSection.this.ctrl_remove_1.setEnabled(false);
            }
        });
        this.ctrl_table_2.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                IStructuredSelection selection = (IStructuredSelection)ActivityGuidanceSection.this.viewer_2.getSelection();
                if (selection.size() > 0 && ActivityGuidanceSection.this.editable) {
                    ActivityGuidanceSection.this.ctrl_remove_2.setEnabled(true);
                }
            }
        });
        this.viewer_2.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)ActivityGuidanceSection.this.viewer_2.getSelection();
                if (selection.size() > 0 && ActivityGuidanceSection.this.editable) {
                    ActivityGuidanceSection.this.ctrl_remove_2.setEnabled(true);
                }
            }
        });
        this.ctrl_add_2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProcessGuidanceFilter filter = new ProcessGuidanceFilter(this, config, null, tabName){
                    final /* synthetic */ 12 this$1;
                    {
                        this.this$1 = var1_1;
                        super($anonymous0, $anonymous1, $anonymous2);
                    }

                    public boolean childAccept(Object obj) {
                        if (super.childAccept(obj)) {
                            return true;
                        }
                        if (obj instanceof GuidanceItemProvider) {
                            return !((GuidanceItemProvider)obj).getChildren(obj).isEmpty();
                        }
                        return obj instanceof Checklist || obj instanceof Concept || obj instanceof Example || obj instanceof Guideline || obj instanceof ReusableAsset || obj instanceof SupportingMaterial;
                    }
                };
                ItemsFilterDialog fd = new ItemsFilterDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IFilter)filter, ActivityGuidanceSection.this.element, FilterConstants.GUIDANCE, ActivityGuidanceSection.this.getSelectedGuidances());
                fd.setBlockOnOpen(true);
                fd.setTitle(FilterConstants.GUIDANCE);
                fd.open();
                ActivityGuidanceSection.this.addGuidances(fd.getSelectedItems());
                ActivityGuidanceSection.this.viewer_2.refresh();
            }
        });
        this.ctrl_remove_2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)ActivityGuidanceSection.this.viewer_2.getSelection();
                if (selection.size() > 0) {
                    ArrayList rmItems = new ArrayList();
                    rmItems.addAll(selection.toList());
                    ActivityGuidanceSection.this.removeGuidances(rmItems);
                    ActivityGuidanceSection.this.viewer_2.refresh();
                    ActivityGuidanceSection.this.viewer_2.setSelection(null, true);
                }
                ActivityGuidanceSection.this.ctrl_remove_2.setEnabled(false);
            }
        });
        this.ctrl_table_3.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                IStructuredSelection selection = (IStructuredSelection)ActivityGuidanceSection.this.viewer_3.getSelection();
                if (selection.size() > 0 && ActivityGuidanceSection.this.editable) {
                    ActivityGuidanceSection.this.ctrl_remove_3.setEnabled(true);
                }
            }
        });
        this.viewer_3.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)ActivityGuidanceSection.this.viewer_3.getSelection();
                if (selection.size() > 0 && ActivityGuidanceSection.this.editable) {
                    ActivityGuidanceSection.this.ctrl_remove_3.setEnabled(true);
                }
            }
        });
        this.ctrl_add_3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ActivityGuidanceSection.this.element instanceof DeliveryProcess) {
                    DeliveryProcess proc = (DeliveryProcess)ActivityGuidanceSection.this.element;
                    ProcessGuidanceFilter filter = new ProcessGuidanceFilter(this, config, null, tabName){
                        final /* synthetic */ 17 this$1;
                        {
                            this.this$1 = var1_1;
                            super($anonymous0, $anonymous1, $anonymous2);
                        }

                        public boolean childAccept(Object obj) {
                            if (super.childAccept(obj)) {
                                return true;
                            }
                            return obj instanceof GuidanceItemProvider || obj instanceof SupportingMaterial;
                        }
                    };
                    ItemsFilterDialog fd = new ItemsFilterDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IFilter)filter, proc, FilterConstants.GUIDANCE, proc.getCommunicationsMaterials());
                    fd.setBlockOnOpen(true);
                    fd.setTitle(FilterConstants.GUIDANCE);
                    fd.open();
                    ActivityGuidanceSection.this.actionMgr.doAction(5, (EObject)proc, (EStructuralFeature)UmaPackage.eINSTANCE.getDeliveryProcess_CommunicationsMaterials(), (Object)fd.getSelectedItems(), -1);
                }
                ActivityGuidanceSection.this.viewer_3.refresh();
            }
        });
        this.ctrl_remove_3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)ActivityGuidanceSection.this.viewer_3.getSelection();
                if (selection.size() > 0) {
                    ArrayList rmItems = new ArrayList();
                    rmItems.addAll(selection.toList());
                    if (ActivityGuidanceSection.this.element instanceof DeliveryProcess) {
                        DeliveryProcess proc = (DeliveryProcess)ActivityGuidanceSection.this.element;
                        ActivityGuidanceSection.this.actionMgr.doAction(6, (EObject)proc, (EStructuralFeature)UmaPackage.eINSTANCE.getDeliveryProcess_CommunicationsMaterials(), rmItems, -1);
                    }
                    ActivityGuidanceSection.this.viewer_3.refresh();
                    ActivityGuidanceSection.this.viewer_3.setSelection(null, true);
                }
                ActivityGuidanceSection.this.ctrl_remove_3.setEnabled(false);
            }
        });
        this.ctrl_table_4.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                IStructuredSelection selection = (IStructuredSelection)ActivityGuidanceSection.this.viewer_4.getSelection();
                if (selection.size() > 0 && ActivityGuidanceSection.this.editable) {
                    ActivityGuidanceSection.this.ctrl_remove_4.setEnabled(true);
                }
            }
        });
        this.viewer_4.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)ActivityGuidanceSection.this.viewer_4.getSelection();
                if (selection.size() > 0 && ActivityGuidanceSection.this.editable) {
                    ActivityGuidanceSection.this.ctrl_remove_4.setEnabled(true);
                }
            }
        });
        this.ctrl_add_4.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ActivityGuidanceSection.this.element instanceof DeliveryProcess) {
                    DeliveryProcess proc = (DeliveryProcess)ActivityGuidanceSection.this.element;
                    ProcessGuidanceFilter filter = new ProcessGuidanceFilter(this, config, null, tabName){
                        final /* synthetic */ 22 this$1;
                        {
                            this.this$1 = var1_1;
                            super($anonymous0, $anonymous1, $anonymous2);
                        }

                        public boolean childAccept(Object obj) {
                            if (super.childAccept(obj)) {
                                return true;
                            }
                            return obj instanceof GuidanceItemProvider || obj instanceof SupportingMaterial;
                        }
                    };
                    ItemsFilterDialog fd = new ItemsFilterDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IFilter)filter, proc, FilterConstants.GUIDANCE, proc.getEducationMaterials());
                    fd.setBlockOnOpen(true);
                    fd.setTitle(FilterConstants.GUIDANCE);
                    fd.open();
                    ActivityGuidanceSection.this.actionMgr.doAction(5, (EObject)proc, (EStructuralFeature)UmaPackage.eINSTANCE.getDeliveryProcess_EducationMaterials(), (Object)fd.getSelectedItems(), -1);
                    ActivityGuidanceSection.this.viewer_4.refresh();
                }
            }
        });
        this.ctrl_remove_4.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)ActivityGuidanceSection.this.viewer_4.getSelection();
                if (selection.size() > 0) {
                    ArrayList rmItems = new ArrayList();
                    rmItems.addAll(selection.toList());
                    if (ActivityGuidanceSection.this.element instanceof DeliveryProcess) {
                        DeliveryProcess proc = (DeliveryProcess)ActivityGuidanceSection.this.element;
                        ActivityGuidanceSection.this.actionMgr.doAction(6, (EObject)proc, (EStructuralFeature)UmaPackage.eINSTANCE.getDeliveryProcess_EducationMaterials(), rmItems, -1);
                    }
                    ActivityGuidanceSection.this.viewer_4.refresh();
                    ActivityGuidanceSection.this.viewer_4.setSelection(null, true);
                }
                ActivityGuidanceSection.this.ctrl_remove_4.setEnabled(false);
            }
        });
    }

    private void addGuidances(ArrayList addItems) {
        if (!addItems.isEmpty()) {
            Iterator it = addItems.iterator();
            while (it.hasNext()) {
                Object obj = it.next();
                if (!(obj instanceof Guidance)) continue;
                Guidance item = (Guidance)obj;
                if (item instanceof Checklist) {
                    this.actionMgr.doAction(3, (EObject)this.element, (EStructuralFeature)UmaPackage.eINSTANCE.getActivity_Checklists(), (Object)item, -1);
                    continue;
                }
                if (item instanceof Concept) {
                    this.actionMgr.doAction(3, (EObject)this.element, (EStructuralFeature)UmaPackage.eINSTANCE.getActivity_Concepts(), (Object)item, -1);
                    continue;
                }
                if (item instanceof Example) {
                    this.actionMgr.doAction(3, (EObject)this.element, (EStructuralFeature)UmaPackage.eINSTANCE.getActivity_Examples(), (Object)item, -1);
                    continue;
                }
                if (item instanceof SupportingMaterial) {
                    this.actionMgr.doAction(3, (EObject)this.element, (EStructuralFeature)UmaPackage.eINSTANCE.getActivity_SupportingMaterials(), (Object)item, -1);
                    continue;
                }
                if (item instanceof Guideline) {
                    this.actionMgr.doAction(3, (EObject)this.element, (EStructuralFeature)UmaPackage.eINSTANCE.getActivity_Guidelines(), (Object)item, -1);
                    continue;
                }
                if (item instanceof ReusableAsset) {
                    this.actionMgr.doAction(3, (EObject)this.element, (EStructuralFeature)UmaPackage.eINSTANCE.getActivity_ReusableAssets(), (Object)item, -1);
                    continue;
                }
                if (item instanceof Roadmap) {
                    this.actionMgr.doAction(3, (EObject)this.element, (EStructuralFeature)UmaPackage.eINSTANCE.getActivity_Roadmaps(), (Object)item, -1);
                    continue;
                }
                this.logger.logError("Cant set guidance " + item.getType().getName() + ":" + item.getName());
            }
        }
    }

    private void removeGuidances(ArrayList rmItems) {
        if (!rmItems.isEmpty()) {
            Iterator it = rmItems.iterator();
            while (it.hasNext()) {
                Guidance item = (Guidance)it.next();
                if (item instanceof Checklist) {
                    this.actionMgr.doAction(4, (EObject)this.element, (EStructuralFeature)UmaPackage.eINSTANCE.getActivity_Checklists(), (Object)item, -1);
                    continue;
                }
                if (item instanceof Concept) {
                    this.actionMgr.doAction(4, (EObject)this.element, (EStructuralFeature)UmaPackage.eINSTANCE.getActivity_Concepts(), (Object)item, -1);
                    continue;
                }
                if (item instanceof Example) {
                    this.actionMgr.doAction(4, (EObject)this.element, (EStructuralFeature)UmaPackage.eINSTANCE.getActivity_Examples(), (Object)item, -1);
                    continue;
                }
                if (item instanceof SupportingMaterial) {
                    this.actionMgr.doAction(4, (EObject)this.element, (EStructuralFeature)UmaPackage.eINSTANCE.getActivity_SupportingMaterials(), (Object)item, -1);
                    continue;
                }
                if (item instanceof Guideline) {
                    this.actionMgr.doAction(4, (EObject)this.element, (EStructuralFeature)UmaPackage.eINSTANCE.getActivity_Guidelines(), (Object)item, -1);
                    continue;
                }
                if (item instanceof ReusableAsset) {
                    this.actionMgr.doAction(4, (EObject)this.element, (EStructuralFeature)UmaPackage.eINSTANCE.getActivity_ReusableAssets(), (Object)item, -1);
                    continue;
                }
                if (item instanceof Roadmap) {
                    this.actionMgr.doAction(4, (EObject)this.element, (EStructuralFeature)UmaPackage.eINSTANCE.getActivity_Roadmaps(), (Object)item, -1);
                    continue;
                }
                this.logger.logError("Can't remove Guidance: " + item.getType().getName() + ":" + item.getName());
            }
        }
    }

    private List getSelectedGuidances() {
        ArrayList itemList = new ArrayList();
        itemList.addAll(this.element.getChecklists());
        itemList.addAll(this.element.getConcepts());
        itemList.addAll(this.element.getExamples());
        itemList.addAll(this.element.getGuidelines());
        itemList.addAll(this.element.getReusableAssets());
        itemList.addAll(this.element.getSupportingMaterials());
        return itemList;
    }
}

