/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.properties;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.epf.authoring.ui.editors.ProcessEditor;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.command.IActionManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.IPropertySheetEntry;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertySheetEntry;
import org.eclipse.wst.common.ui.properties.internal.provisional.ISection;
import org.eclipse.wst.common.ui.properties.internal.provisional.ITabbedPropertySheetPageContributor;
import org.eclipse.wst.common.ui.properties.internal.provisional.TabbedPropertySheetPage;
import org.eclipse.wst.common.ui.properties.internal.view.Tab;

public class TNGPropertySheetPage
extends TabbedPropertySheetPage {
    private IPropertySheetEntry rootEntry;
    private static IPropertySourceProvider sourceProvider;
    private static ISelection selection;
    private static IActionManager actionMgr;
    private static ProcessEditor processEditor;
    public static String formPageID;

    static {
        selection = null;
        formPageID = null;
    }

    public TNGPropertySheetPage(ProcessEditor editor) {
        super((ITabbedPropertySheetPageContributor)editor);
        actionMgr = editor.getActionManager();
        processEditor = editor;
    }

    public static IActionManager getActionManager() {
        return actionMgr;
    }

    public static ProcessEditor getEditor() {
        return processEditor;
    }

    public void setPropertySourceProvider(IPropertySourceProvider newProvider) {
        sourceProvider = newProvider;
        if (this.rootEntry == null) {
            PropertySheetEntry root = new PropertySheetEntry();
            this.rootEntry = root;
        }
        if (sourceProvider != null && this.rootEntry instanceof PropertySheetEntry) {
            ((PropertySheetEntry)this.rootEntry).setPropertySourceProvider(sourceProvider);
        }
    }

    public static IPropertySourceProvider getPropertySourceProvider() {
        return sourceProvider;
    }

    public static ISelection getSelection() {
        return selection;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection sel) {
        selection = sel;
        if (part instanceof ProcessEditor) {
            processEditor = (ProcessEditor)part;
            actionMgr = processEditor.getActionManager();
            formPageID = processEditor.getActivePageInstance().getId();
        }
        super.selectionChanged(part, selection);
    }

    public void handlePartActivated(IWorkbenchPart part) {
        if (part instanceof ProcessEditor) {
            processEditor = (ProcessEditor)part;
            selection = processEditor.getSelection();
            actionMgr = processEditor.getActionManager();
            formPageID = processEditor.getActivePageInstance().getId();
        }
        super.handlePartActivated(part);
    }

    public static AdapterFactory getAdapterFactory() {
        if (formPageID.equals("wbs")) {
            return TngAdapterFactory.INSTANCE.getWBS_ComposedAdapterFactory();
        }
        if (formPageID.equals("tbs")) {
            return TngAdapterFactory.INSTANCE.getOBS_ComposedAdapterFactory();
        }
        if (formPageID.equals("wpbs")) {
            return TngAdapterFactory.INSTANCE.getPBS_ComposedAdapterFactory();
        }
        if (formPageID.equals("consolidated")) {
            return TngAdapterFactory.INSTANCE.getProcessComposedAdapterFactory();
        }
        return null;
    }

    public void refresh() {
        Tab tab = this.getCurrentTab();
        if (tab != null) {
            tab.refresh();
            ISection section = tab.getSectionAtIndex(0);
            if (section != null) {
                section.refresh();
            }
        }
    }
}

