/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.properties;

import com.ibm.uma.Task;
import com.ibm.uma.TaskDescriptor;
import com.ibm.uma.UmaPackage;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.dialogs.ItemsFilterDialog;
import org.eclipse.epf.authoring.ui.filters.ProcessTaskFilter;
import org.eclipse.epf.authoring.ui.properties.FormUI;
import org.eclipse.epf.authoring.ui.properties.PropertiesResources;
import org.eclipse.epf.authoring.ui.properties.WorkBreakdownElementGeneralSection;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.itemsfilter.FilterConstants;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.ui.LibraryUIText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class TaskDescriptorGeneralSection
extends WorkBreakdownElementGeneralSection {
    protected TaskDescriptor element;
    private Button synchronizedButton;
    private Text ctrl_method_element;
    private Button linkButton;

    protected void init() {
        super.init();
        this.element = (TaskDescriptor)this.getElement();
    }

    protected void createGeneralSection(Composite composite) {
        super.createGeneralSection(composite);
        this.checkBoxComposite = FormUI.createComposite(this.toolkit, this.generalComposite, 768, this.numOfColumns, true);
        this.synchronizedButton = FormUI.createButton(this.toolkit, this.checkBoxComposite, 32);
        this.synchronizedButton.setText(PropertiesResources.getString("BreakdownElement.Option.Synchronized"));
        FormUI.createLabel(this.toolkit, this.generalComposite, PropertiesResources.getString("Process.Type.Task"));
        this.ctrl_method_element = FormUI.createText(this.toolkit, this.generalComposite, -1, 1);
        this.ctrl_method_element.setText(this.getMethodElementName(this.element));
        this.ctrl_method_element.setEnabled(false);
        this.linkButton = FormUI.createButton(this.toolkit, this.generalComposite, 8, 1);
        this.linkButton.setText(PropertiesResources.getString("Process.Button.LinkMethodElement"));
    }

    private void setMethodElement(List items) {
        if (items != null && items.size() >= 1 && items.get(0) instanceof Task) {
            Task task = (Task)items.get(0);
            LinkedList list = ProcessUtil.getSiblings((AdapterFactory)TngAdapterFactory.INSTANCE.getWBS_ComposedAdapterFactory(), (ItemProviderAdapter)this.getAdapter(), (Object)this.element);
            boolean canAssign = true;
            Iterator itor = list.iterator();
            while (itor.hasNext()) {
                Task exisingTask;
                TaskDescriptor taskDesc;
                Object obj = itor.next();
                if (!(obj instanceof TaskDescriptor) || (taskDesc = (TaskDescriptor)obj).equals(this.element) || !task.equals(exisingTask = taskDesc.getTask())) continue;
                canAssign = false;
                break;
            }
            if (canAssign) {
                this.actionMgr.doAction(1, (EObject)this.element, (EStructuralFeature)UmaPackage.eINSTANCE.getTaskDescriptor_Task(), (Object)task, -1);
            } else {
                MessageFormat mf = new MessageFormat(PropertiesResources.getString("Process.InvalidLinkMethodElement"));
                Object[] args = new Object[]{task.getName()};
                AuthoringUIPlugin.getDefault().getMsgDialog().displayInfo(PropertiesResources.getString("Process.LinkMethodElementTitle"), mf.format(args));
            }
        }
    }

    private String getMethodElementName(TaskDescriptor element) {
        String str = PropertiesResources.getString("Process.None");
        if (element.getTask() != null) {
            str = element.getTask().getName();
        }
        return str;
    }

    protected void addListeners() {
        super.addListeners();
        this.synchronizedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TaskDescriptorGeneralSection.this.actionMgr.doAction(1, (EObject)TaskDescriptorGeneralSection.this.element, (EStructuralFeature)UmaPackage.eINSTANCE.getDescriptor_IsSynchronizedWithSource(), (Object)TaskDescriptorGeneralSection.this.synchronizedButton.getSelection(), -1);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.linkButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProcessTaskFilter filter = new ProcessTaskFilter(TaskDescriptorGeneralSection.this.getDefaultConfiguration(), null, FilterConstants.TASKS);
                ArrayList<Task> existingElements = new ArrayList<Task>();
                if (TaskDescriptorGeneralSection.this.element.getTask() != null) {
                    existingElements.add(TaskDescriptorGeneralSection.this.element.getTask());
                }
                ItemsFilterDialog fd = new ItemsFilterDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IFilter)filter, TaskDescriptorGeneralSection.this.element, FilterConstants.TASKS, existingElements);
                fd.setBlockOnOpen(true);
                fd.setViewerSelectionSingle(true);
                fd.setTitle(FilterConstants.TASKS);
                fd.open();
                TaskDescriptorGeneralSection.this.setMethodElement(fd.getSelectedItems());
                TaskDescriptorGeneralSection.this.ctrl_method_element.setText(TaskDescriptorGeneralSection.this.getMethodElementName(TaskDescriptorGeneralSection.this.element));
            }

            public void widgetDefaultSelected(SelectionEvent e1) {
            }
        });
    }

    protected void updateControls() {
        super.updateControls();
        this.synchronizedButton.setEnabled(this.editable);
        this.linkButton.setEnabled(this.editable);
    }

    public void refresh() {
        try {
            if (this.getElement() instanceof TaskDescriptor) {
                super.refresh();
                this.element = (TaskDescriptor)this.getElement();
                this.synchronizedButton.setSelection(this.element.getIsSynchronizedWithSource().booleanValue());
                this.ctrl_method_element.setText(this.getMethodElementName(this.element));
            }
        }
        catch (Exception ex) {
            this.logger.logError("Error refreshing TaskDescriptor general section: " + this.element, (Throwable)ex);
        }
    }

    public String getNamePrefix() {
        return String.valueOf(LibraryUIText.TEXT_TASK_DESCRIPTOR) + ": ";
    }
}

