/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.views;

import com.ibm.uma.MethodConfiguration;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.ui.dnd.LocalTransfer;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.epf.authoring.ui.AuthoringUIHelpContexts;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.UIActionDispatcher;
import org.eclipse.epf.authoring.ui.actions.ConfigurationViewEditAction;
import org.eclipse.epf.authoring.ui.actions.ILibraryActionBarContributor;
import org.eclipse.epf.authoring.ui.actions.LibraryActionBarContributor;
import org.eclipse.epf.authoring.ui.dnd.LibraryViewerDragAdapter;
import org.eclipse.epf.authoring.ui.views.AbstractBaseView;
import org.eclipse.epf.library.configuration.ConfigurationFilter;
import org.eclipse.epf.library.configuration.ConfigurationLabelProvider;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.events.ILibraryChangeListener;
import org.eclipse.epf.library.services.LibraryProcessor;
import org.eclipse.epf.library.ui.LibraryUIManager;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.HTMLTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class ConfigurationView
extends AbstractBaseView {
    public static final String VIEW_ID;
    private String configName;
    private TreeViewer treeViewer;
    private IDoubleClickListener doubleClickListener;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.epf.authoring.ui.views.ConfigurationView");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        VIEW_ID = clazz.getName();
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.createActions(site);
        LibraryUIManager.getInstance().addConfigurationContribution();
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, AuthoringUIHelpContexts.CONFIGURATION_VIEW_CONTEXT);
        this.editingDomain = new AdapterFactoryEditingDomain(this.adapterFactory, (CommandStack)new BasicCommandStack());
        this.adapterFactory = (ComposedAdapterFactory)this.editingDomain.getAdapterFactory();
        this.setConfiguration(null);
        this.libListener = new ILibraryChangeListener(){

            public void libraryChanged(int option, Collection changedItems) {
                switch (option) {
                    case 1: 
                    case 4: {
                        ConfigurationView.this.setMethodConfiguration(null);
                        break;
                    }
                    case 64: {
                        String configName = LibraryProcessor.getInstance().getCurrentConfiguration();
                        MethodConfiguration config = LibraryProcessor.getInstance().getConfiguration(configName);
                        ConfigurationView.this.setMethodConfiguration(config);
                        break;
                    }
                    case 16: {
                        if (changedItems == null) break;
                        Iterator it = changedItems.iterator();
                        while (it.hasNext()) {
                            Object element = it.next();
                            if (!(element instanceof MethodConfiguration) || !((MethodConfiguration)element).getName().equals(ConfigurationView.this.getCurrentConfig())) continue;
                            ConfigurationView.this.setMethodConfiguration(null);
                        }
                        break;
                    }
                }
            }
        };
        LibraryProcessor.getInstance().addListener(this.libListener);
    }

    public String getCurrentConfig() {
        return this.configName;
    }

    public void setFocus() {
        this.actionBarContributor.setActiveView((IViewPart)this);
        IStructuredSelection selected = (IStructuredSelection)this.getSelection();
        if (selected.isEmpty()) {
            this.actionBarContributor.disableGlobalEditMenu();
        } else {
            this.actionBarContributor.enableGlobalEditMenu();
        }
        if (this.treeViewer != null) {
            this.treeViewer.getControl().setFocus();
        }
    }

    public void createViewer(Composite parent) {
        Composite content = new Composite(parent, 0);
        content.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout();
        content.setLayout((Layout)layout);
        this.treeViewer = new TreeViewer(content);
        this.treeViewer.getTree().setLayoutData((Object)new GridData(1808));
        int dndOperations = 3;
        Transfer[] transfers = new Transfer[]{HTMLTransfer.getInstance(), LocalTransfer.getInstance()};
        this.treeViewer.addDragSupport(dndOperations, transfers, (DragSourceListener)new LibraryViewerDragAdapter((Viewer)this.treeViewer));
        this.doubleClickListener = new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                UIActionDispatcher.getInstance().handleDoubleClickEvent(event);
            }
        };
        this.treeViewer.addDoubleClickListener(this.doubleClickListener);
        this.createContextMenuFor((StructuredViewer)this.treeViewer);
    }

    public void createActions(IViewSite viewSite) {
        Action editAction = new Action(AuthoringUIResources.getString("AuthoringUI.actionLabel.edit")){

            public void run() {
                UIActionDispatcher.editConfiguration(ConfigurationView.this.configName);
            }
        };
        editAction.setToolTipText(AuthoringUIResources.getString("AuthoringUI.editConfiguration.tooltip"));
    }

    private void reset() {
        IBaseLabelProvider labelProvider;
        this.configName = null;
        if (this.adapterFactory != null) {
            if (this.adapterFactory instanceof IDisposable) {
                ((IDisposable)this.adapterFactory).dispose();
            }
            this.adapterFactory = null;
        }
        this.editingDomain.setAdapterFactory(null);
        IContentProvider contentProvider = this.treeViewer.getContentProvider();
        if (contentProvider != null) {
            contentProvider.dispose();
        }
        if ((labelProvider = this.treeViewer.getLabelProvider()) != null) {
            labelProvider.dispose();
        }
        StructuredSelection emptySelection = new StructuredSelection();
        this.actionDispatcher.setSelection((ISelection)emptySelection);
        UIActionDispatcher.getInstance().setSelection((ISelection)emptySelection);
    }

    public void setMethodConfiguration(MethodConfiguration config) {
        Control ctrl = this.getViewer().getControl();
        if (ctrl == null || ctrl.isDisposed()) {
            return;
        }
        if (this.treeViewer.getInput() == config) {
            return;
        }
        String title = "";
        if (config != null) {
            this.configName = config.getName();
            ConfigurationFilter configFilter = new ConfigurationFilter(config, (Viewer)this.treeViewer);
            this.adapterFactory = TngAdapterFactory.INSTANCE.getConfigurationView_AdapterFactory((IFilter)configFilter);
            this.editingDomain.setAdapterFactory(this.adapterFactory);
            this.treeViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider(this.adapterFactory));
            this.treeViewer.setLabelProvider((IBaseLabelProvider)new ConfigurationLabelProvider(config, this.adapterFactory));
            title = config.getName();
        } else {
            IBaseLabelProvider labelProvider;
            this.configName = null;
            if (this.adapterFactory != null) {
                if (this.adapterFactory instanceof IDisposable) {
                    ((IDisposable)this.adapterFactory).dispose();
                }
                this.adapterFactory = null;
            }
            this.editingDomain.setAdapterFactory(null);
            IContentProvider contentProvider = this.treeViewer.getContentProvider();
            if (contentProvider != null) {
                contentProvider.dispose();
            }
            if ((labelProvider = this.treeViewer.getLabelProvider()) != null) {
                labelProvider.dispose();
            }
            StructuredSelection emptySelection = new StructuredSelection();
            this.actionDispatcher.setSelection((ISelection)emptySelection);
            UIActionDispatcher.getInstance().setSelection((ISelection)emptySelection);
        }
        this.treeViewer.setInput((Object)config);
        this.setContentDescription(title);
    }

    public void setConfiguration(String name) {
        MethodConfiguration config;
        this.configName = name;
        if (this.configName == null) {
            this.configName = LibraryProcessor.getInstance().getConfigurationFactory().getCurrentConfiguration();
        }
        if (this.configName != null && (config = LibraryProcessor.getInstance().getConfiguration(this.configName)) != null) {
            this.setMethodConfiguration(config);
            return;
        }
        this.configName = null;
    }

    public void dispose() {
        super.dispose();
        if (this.doubleClickListener != null) {
            this.treeViewer.removeDoubleClickListener(this.doubleClickListener);
        }
    }

    public static ConfigurationView getView() {
        try {
            IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            if (activePage != null) {
                IViewPart view = activePage.findView(VIEW_ID);
                if (view == null) {
                    view = activePage.showView(VIEW_ID);
                }
                return (ConfigurationView)view;
            }
        }
        catch (Exception e) {
            AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)e);
        }
        return null;
    }

    public Viewer getViewer() {
        return this.treeViewer;
    }

    public ILibraryActionBarContributor createActionBarContributor() {
        return new ConfigurationViewActionBarContributor((EditingDomain)this.editingDomain);
    }

    public void setInputForViewer(Object model) {
        if (model == null || model instanceof MethodConfiguration) {
            this.setMethodConfiguration((MethodConfiguration)model);
        } else {
            this.reset();
        }
    }

    private class ConfigurationViewActionBarContributor
    extends LibraryActionBarContributor {
        public ConfigurationViewActionBarContributor(EditingDomain editingDomain) {
            super(editingDomain);
        }

        public void init(IActionBars actionBars) {
            this.viewActionBars = actionBars;
            this.configViewEditAction = new ConfigurationViewEditAction(AuthoringUIResources.getString("AuthoringUI.actionLabel.edit"));
            actionBars.setGlobalActionHandler("org.eclipse.epf.authoring.ui.actions.openElement", (IAction)this.configViewEditAction);
        }

        public void activate() {
            this.activeViewPart.addPropertyListener((IPropertyListener)this);
            ISelectionProvider selectionProvider = this.activeViewPart instanceof ISelectionProvider ? (ISelectionProvider)this.activeViewPart : this.activeViewPart.getSite().getSelectionProvider();
            selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.configViewEditAction);
            this.update();
        }

        public void deactivate() {
            this.activeViewPart.removePropertyListener((IPropertyListener)this);
            ISelectionProvider selectionProvider = this.activeViewPart instanceof ISelectionProvider ? (ISelectionProvider)this.activeViewPart : this.activeViewPart.getSite().getSelectionProvider();
            selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.configViewEditAction);
        }

        public void update() {
            ISelectionProvider selectionProvider = this.activeViewPart instanceof ISelectionProvider ? (ISelectionProvider)this.activeViewPart : this.activeViewPart.getSite().getSelectionProvider();
            ISelection selection = selectionProvider.getSelection();
            StructuredSelection structuredSelection = selection instanceof IStructuredSelection ? (IStructuredSelection)selection : StructuredSelection.EMPTY;
            this.configViewEditAction.selectionChanged((IStructuredSelection)structuredSelection);
        }

        public void selectionChanged(SelectionChangedEvent event) {
        }

        public void disableGlobalEditMenu() {
            this.configViewEditAction.setEnabled(false);
        }

        public void enableGlobalEditMenu() {
            this.configViewEditAction.setEnabled(true);
        }

        public void menuAboutToShow(IMenuManager menuManager) {
            menuManager.add((IContributionItem)new Separator("additions"));
            menuManager.add((IContributionItem)new Separator("edit"));
            menuManager.add((IContributionItem)new Separator("additions-end"));
            this.addGlobalActions(menuManager);
            menuManager.add((IContributionItem)new Separator());
            menuManager.add((IContributionItem)new ActionContributionItem((IAction)this.configViewEditAction));
        }
    }
}

