/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.views;

import com.ibm.uma.MethodElement;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.views.HTMLWrappers;
import org.eclipse.epf.common.utils.FileUtil;
import org.eclipse.epf.library.layout.ElementLayoutManager;
import org.eclipse.epf.library.layout.HtmlBuilder;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationAdapter;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;

public class ElementHTMLViewer {
    private static final String DEFAULT_CONTENT_WRAPPER_START = "<html><head> <meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\"></head><script language=\"javascript\">function init() { parent.ory_toc=\"disable\"; parent.contentframe.location=\"";
    private static final String DEFAULT_CONTENT_WRAPPER_END = "\"; }</script></head><frameset rows=\"100%,*\" frameborder=\"no\" border=\"0\" framespacing=\"0\" id=\"contentframeset\" name=\"contentframeset\"><frame src=\"about:blank\" id=\"contentframe\" name=\"contentframe\" scrolling=\"auto\"/><frame src=\"about:blank\" id=\"blankframe\" name=\"blankframe\" onload=\"init()\"/></frameset></html>";
    private static final String DEFAULT_PRINT_WRAPPER_START = "<html><head> <meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\"></head><script language=\"javascript\">function init() { parent.ory_toc=\"disable\"; parent.contentframe.location=\"print();";
    private static final String DEFAULT_PRINT_WRAPPER_END = "\"; }</script></head><frameset rows=\"100%,*\" frameborder=\"no\" border=\"0\" framespacing=\"0\" id=\"contentframeset\" name=\"contentframeset\"><frame src=\"about:blank\" id=\"contentframe\" name=\"contentframe\" scrolling=\"auto\"/><frame src=\"about:blank\" id=\"blankframe\" name=\"blankframe\" onload=\"init()\"/></frameset></html>";
    private static final String PRINT_FILE = "print.html";
    private String contentWrapperSart;
    private String contentWrapperEnd;
    private String printWrapperSart;
    private String printWrapperEnd;
    private Browser printBrowser;
    protected Browser browser = null;
    protected Composite parent;
    private String currentLocation = null;
    private HtmlBuilder htmlBuilder;
    private Cursor waitCursor = null;

    public ElementHTMLViewer(Composite parent) {
        this.parent = parent;
        this.htmlBuilder = new HtmlBuilder();
        this.createControl();
    }

    private void createControl() {
        try {
            this.browser = new Browser(this.parent, 0);
            this.browser.setLayoutData((Object)new GridData(1808));
            this.browser.addLocationListener((LocationListener)new LocationAdapter(){

                public void changed(LocationEvent e) {
                }

                public void changing(LocationEvent e) {
                    String location = ElementHTMLViewer.this.getElementUrl(e.location);
                    if (ElementHTMLViewer.this.isLocationChanged(location)) {
                        ElementHTMLViewer.this.currentLocation = location;
                        ElementHTMLViewer.this.generateHtml(ElementHTMLViewer.this.currentLocation);
                    }
                }
            });
            this.printBrowser = new Browser(this.parent, 0);
            this.printBrowser.setSize(1, 1);
            this.printBrowser.setVisible(false);
            this.contentWrapperSart = HTMLWrappers.getString("CONTENT_WRAPPER_START");
            if (this.contentWrapperSart == null) {
                this.contentWrapperSart = DEFAULT_CONTENT_WRAPPER_START;
            }
            this.contentWrapperEnd = HTMLWrappers.getString("CONTENT_WRAPPER_END");
            if (this.contentWrapperEnd == null) {
                this.contentWrapperEnd = DEFAULT_CONTENT_WRAPPER_START;
            }
            this.printWrapperSart = HTMLWrappers.getString("PRINT_WRAPPER_START");
            if (this.printWrapperSart == null) {
                this.printWrapperSart = DEFAULT_PRINT_WRAPPER_START;
            }
            this.printWrapperEnd = HTMLWrappers.getString("PRINT_WRAPPER_END");
            if (this.printWrapperEnd == null) {
                this.printWrapperEnd = "\"; }</script></head><frameset rows=\"100%,*\" frameborder=\"no\" border=\"0\" framespacing=\"0\" id=\"contentframeset\" name=\"contentframeset\"><frame src=\"about:blank\" id=\"contentframe\" name=\"contentframe\" scrolling=\"auto\"/><frame src=\"about:blank\" id=\"blankframe\" name=\"blankframe\" onload=\"init()\"/></frameset></html>";
            }
            this.waitCursor = this.parent.getShell().getDisplay().getSystemCursor(1);
        }
        catch (Exception e) {
            this.browser = null;
            AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)e);
        }
    }

    private boolean isLocationChanged(String location) {
        if (location == null || this.currentLocation == null) {
            return false;
        }
        if (File.separatorChar != '/') {
            String oldLocation;
            return !(location = location.replace(File.separatorChar, '/')).endsWith(oldLocation = this.currentLocation.replace(File.separatorChar, '/')) && !oldLocation.endsWith(location);
        }
        return !location.endsWith(this.currentLocation) && !this.currentLocation.endsWith(location);
    }

    public Browser getBrowser() {
        return this.browser;
    }

    public void setFocus() {
        if (this.browser != null) {
            this.browser.setFocus();
        }
    }

    public HtmlBuilder getHtmlBuilder() {
        return this.htmlBuilder;
    }

    public void setHtmlBuilder(HtmlBuilder builder) {
        this.htmlBuilder = builder;
    }

    public void setLayoutManager(ElementLayoutManager layoutMgr) {
        this.htmlBuilder.setLayoutManager(layoutMgr);
    }

    public void showElementContent(Object element) {
        this.startWait();
        try {
            String file_url = "about:blank";
            if (element instanceof MethodElement) {
                file_url = this.htmlBuilder.generateHtml((MethodElement)element);
            }
            this.currentLocation = file_url;
            this.browser.setUrl(file_url);
        }
        catch (RuntimeException e) {
            AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)e);
        }
        this.endWait();
    }

    private void generateHtml(String url) {
        this.startWait();
        try {
            this.htmlBuilder.generateHtml(url);
        }
        catch (RuntimeException e) {
            AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)e);
        }
        this.endWait();
    }

    private String getElementUrl(String location) {
        if (location == null || location.length() == 0 || location.equals("about:blank")) {
            return null;
        }
        if ((location = this.getUrl(location)).indexOf("pages_not_installed/") >= 0) {
            return null;
        }
        return location;
    }

    private String getUrl(String location) {
        String publish_dir = this.htmlBuilder.getPublishDir();
        String url = this.fixPath(location);
        int index = url.toLowerCase().indexOf(this.fixPath(publish_dir).toLowerCase());
        if (index >= 0) {
            url = url.substring(index + publish_dir.length());
        }
        if ((index = url.indexOf("#")) > 0) {
            url = url.substring(0, index);
        }
        return url;
    }

    private String fixPath(String path) {
        try {
            path = URLDecoder.decode(path, "utf-8");
            if (File.separatorChar != '/') {
                return path.replace(File.separatorChar, '/');
            }
            return path;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return "";
        }
    }

    public void print() {
        String printFile = String.valueOf(this.htmlBuilder.getPublishDir()) + PRINT_FILE;
        if (this.currentLocation != null) {
            StringBuffer wrapperHTML = new StringBuffer();
            wrapperHTML.append(this.printWrapperSart).append(this.currentLocation).append(this.printWrapperEnd);
            String htmlText = wrapperHTML.toString();
            if (FileUtil.writeUTF8File((String)printFile, (String)htmlText)) {
                this.printBrowser.setUrl(printFile);
            }
        }
    }

    private void startWait() {
        this.parent.getShell().setCursor(this.waitCursor);
    }

    private void endWait() {
        this.parent.getShell().setCursor(null);
    }

    public void refresh() {
        this.generateHtml(this.currentLocation);
        this.browser.refresh();
    }
}

