/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.internal.core.text;

import java.io.IOException;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.IDocument;
import org.eclipse.search.internal.core.SearchScope;
import org.eclipse.search.internal.core.text.DocumentCharSequence;
import org.eclipse.search.internal.core.text.FileCharSequenceProvider;
import org.eclipse.search.internal.core.text.ITextSearchResultCollector;
import org.eclipse.search.internal.core.text.MatchLocator;
import org.eclipse.search.internal.ui.Messages;
import org.eclipse.search.internal.ui.SearchMessages;
import org.eclipse.search.internal.ui.SearchPlugin;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.texteditor.ITextEditor;

public class TextSearchVisitor
implements IResourceProxyVisitor {
    private SearchScope fScope;
    private ITextSearchResultCollector fCollector;
    private MatchLocator fLocator;
    private Map fDocumentsInEditors;
    private IProgressMonitor fProgressMonitor;
    private int fNumberOfScannedFiles;
    private int fNumberOfFilesToScan;
    private long fLastUpdateTime;
    private boolean fVisitDerived;
    private final MultiStatus fStatus;
    private final FileCharSequenceProvider fFileCharSequenceProvider;

    public TextSearchVisitor(MatchLocator locator, SearchScope scope, boolean visitDerived, ITextSearchResultCollector collector, MultiStatus status, int fileCount) {
        this.fScope = scope;
        this.fCollector = collector;
        this.fStatus = status;
        this.fProgressMonitor = collector.getProgressMonitor();
        this.fLocator = locator;
        this.fNumberOfScannedFiles = 0;
        this.fNumberOfFilesToScan = fileCount;
        this.fVisitDerived = visitDerived;
        this.fFileCharSequenceProvider = new FileCharSequenceProvider();
    }

    public void process() {
        this.fDocumentsInEditors = this.evalNonFileBufferDocuments();
        IResource[] roots = this.fScope.getRootElements();
        int i = 0;
        while (i < roots.length) {
            try {
                roots[i].accept((IResourceProxyVisitor)this, 0);
            }
            catch (CoreException ex) {
                this.fStatus.add(ex.getStatus());
            }
            ++i;
        }
        this.fDocumentsInEditors = null;
    }

    private Map evalNonFileBufferDocuments() {
        HashMap result = new HashMap();
        IWorkbench workbench = SearchPlugin.getDefault().getWorkbench();
        IWorkbenchWindow[] windows = workbench.getWorkbenchWindows();
        int i = 0;
        while (i < windows.length) {
            IWorkbenchPage[] pages = windows[i].getPages();
            int x = 0;
            while (x < pages.length) {
                IEditorReference[] editorRefs = pages[x].getEditorReferences();
                int z = 0;
                while (z < editorRefs.length) {
                    IEditorPart ep = editorRefs[z].getEditor(false);
                    if (ep instanceof ITextEditor && ep.isDirty()) {
                        this.evaluateTextEditor(result, ep);
                    }
                    ++z;
                }
                ++x;
            }
            ++i;
        }
        return result;
    }

    private void evaluateTextEditor(Map result, IEditorPart ep) {
        IFile file;
        IEditorInput input = ep.getEditorInput();
        if (input instanceof IFileEditorInput && !result.containsKey(file = ((IFileEditorInput)input).getFile())) {
            ITextFileBufferManager bufferManager = FileBuffers.getTextFileBufferManager();
            ITextFileBuffer textFileBuffer = bufferManager.getTextFileBuffer(file.getFullPath());
            if (textFileBuffer != null) {
                result.put(file, textFileBuffer.getDocument());
            } else {
                IDocument document = ((ITextEditor)ep).getDocumentProvider().getDocument((Object)input);
                if (document != null) {
                    result.put(file, document);
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean visit(IResourceProxy proxy) {
        if (proxy.getType() != 1) {
            return true;
        }
        if (!this.fVisitDerived) {
            if (proxy.isDerived() != false) return false;
        }
        if (!this.fScope.matchesFileName(proxy.getName())) {
            return false;
        }
        try {
            block20: {
                try {
                    block21: {
                        if (this.fLocator.isEmpty()) {
                            this.fCollector.accept(proxy, -1, 0);
                            var9_2 = null;
                            break block20;
                        }
                        file = (IFile)proxy.requestResource();
                        document = this.getOpenDocument(file);
                        if (document == null) break block21;
                        this.fLocator.locateMatches(this.fProgressMonitor, new DocumentCharSequence(document), this.fCollector, proxy);
                        ** GOTO lbl-1000
                    }
                    seq = null;
                    try {
                        try {
                            seq = this.fFileCharSequenceProvider.newCharSequence(file);
                            this.fLocator.locateMatches(this.fProgressMonitor, seq, this.fCollector, proxy);
                        }
                        catch (FileCharSequenceProvider.FileCharSequenceException e) {
                            e.throwWrappedException();
                        }
                    }
                    catch (Throwable var7_25) {
                        var6_26 = null;
                        if (seq == null) throw var7_25;
                        try {
                            this.fFileCharSequenceProvider.releaseCharSequence(seq);
                            throw var7_25;
                        }
                        catch (IOException e) {
                            SearchPlugin.log(e);
                        }
                        throw var7_25;
                    }
                    {
                        var6_27 = null;
                        if (seq == null) ** GOTO lbl-1000
                        ** try [egrp 4[TRYBLOCK] [3 : 179->191)] { 
lbl42:
                        // 1 sources

                        this.fFileCharSequenceProvider.releaseCharSequence(seq);
lbl44:
                        // 1 sources

                        catch (IOException e) {
                            SearchPlugin.log(e);
                        }
                    }
                }
                catch (UnsupportedCharsetException e) {
                    file = (IFile)proxy.requestResource();
                    args = new String[]{this.getCharSetName(file), file.getFullPath().makeRelative().toString()};
                    message = Messages.format(SearchMessages.TextSearchVisitor_unsupportedcharset, args);
                    this.fStatus.add((IStatus)new Status(4, "org.eclipse.search", 2, message, (Throwable)e));
                }
                catch (IllegalCharsetNameException e) {
                    file = (IFile)proxy.requestResource();
                    args = new String[]{this.getCharSetName(file), file.getFullPath().makeRelative().toString()};
                    message = Messages.format(SearchMessages.TextSearchVisitor_illegalcharset, args);
                    this.fStatus.add((IStatus)new Status(4, "org.eclipse.search", 2, message, (Throwable)e));
                }
                catch (IOException e) {
                    file = (IFile)proxy.requestResource();
                    args = new String[]{this.getExceptionMessage(e), file.getFullPath().makeRelative().toString()};
                    message = Messages.format(SearchMessages.TextSearchVisitor_error, args);
                    this.fStatus.add((IStatus)new Status(4, "org.eclipse.search", 2, message, (Throwable)e));
                }
                catch (CoreException e) {
                    file = (IFile)proxy.requestResource();
                    args = new String[]{this.getExceptionMessage((Exception)e), file.getFullPath().makeRelative().toString()};
                    message = Messages.format(SearchMessages.TextSearchVisitor_error, args);
                    this.fStatus.add((IStatus)new Status(4, "org.eclipse.search", 2, message, (Throwable)e));
                }
                ** GOTO lbl-1000
            }
            this.updateProgressMonitor();
            return false;
        }
        catch (Throwable var10_30) {
            var9_3 = null;
            this.updateProgressMonitor();
            throw var10_30;
        }
lbl-1000:
        // 8 sources

        {
            var9_4 = null;
            this.updateProgressMonitor();
            return false;
        }
    }

    private String getExceptionMessage(Exception e) {
        String message = e.getLocalizedMessage();
        if (message == null) {
            return e.getClass().getName();
        }
        return message;
    }

    private IDocument getOpenDocument(IFile file) {
        ITextFileBufferManager bufferManager;
        ITextFileBuffer textFileBuffer;
        IDocument document = (IDocument)this.fDocumentsInEditors.get(file);
        if (document == null && (textFileBuffer = (bufferManager = FileBuffers.getTextFileBufferManager()).getTextFileBuffer(file.getFullPath())) != null) {
            document = textFileBuffer.getDocument();
        }
        return document;
    }

    private String getCharSetName(IFile file) {
        try {
            return file.getCharset();
        }
        catch (CoreException coreException) {
            return "unknown";
        }
    }

    private void updateProgressMonitor() {
        long currTime;
        ++this.fNumberOfScannedFiles;
        if (this.fNumberOfScannedFiles < this.fNumberOfFilesToScan && (currTime = System.currentTimeMillis()) - this.fLastUpdateTime > 1000L) {
            Object[] args = new Object[]{new Integer(this.fNumberOfScannedFiles + 1), new Integer(this.fNumberOfFilesToScan)};
            this.fProgressMonitor.setTaskName(Messages.format(SearchMessages.TextSearchVisitor_scanning, args));
            this.fLastUpdateTime = currTime;
        }
        this.fProgressMonitor.worked(1);
        if (this.fProgressMonitor.isCanceled()) {
            throw new OperationCanceledException(SearchMessages.TextSearchVisitor_canceled);
        }
    }
}

