/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.common.html;

import org.eclipse.epf.common.utils.FileUtil;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.HTMLTransfer;
import org.eclipse.swt.dnd.RTFTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;

public class HTMLClipboard {
    private static final String VERSION = "Version:";
    private static final String START_HTML = "StartHTML:";
    private static final String END_HTML = "StartHTML:";
    private static final String START_FRAGMENT = "StartFragment:";
    private static final String END_FRAGMENT = "EndFragment:";
    private static final String SOURCE_URL = "SourceURL:";
    private Clipboard clipboard = new Clipboard(Display.getCurrent());
    private TextTransfer textTransfer = TextTransfer.getInstance();
    private RTFTransfer rtfTransfer;
    private HTMLTransfer htmlTransfer;
    private String textContent = (String)this.clipboard.getContents((Transfer)this.textTransfer);
    private String rtfContent;
    private String version;
    private String startHTML;
    private String endHTML;
    private String startFragment;
    private String endFragment;
    private String sourceURL;
    private String htmlSource;

    public HTMLClipboard() {
        this.rtfTransfer = RTFTransfer.getInstance();
        this.rtfContent = (String)this.clipboard.getContents((Transfer)this.rtfTransfer);
        this.htmlTransfer = HTMLTransfer.getInstance();
        String htmlContent = (String)this.clipboard.getContents((Transfer)this.htmlTransfer);
        if (htmlContent != null && htmlContent.length() > 0) {
            this.parseHTMLContent(htmlContent);
        }
    }

    public void updateClipboard(String sourceURL) {
        int increment = sourceURL.length() - this.sourceURL.length() + 1;
        this.startHTML = this.updateValue(this.startHTML, increment);
        this.endHTML = this.updateValue(this.endHTML, increment);
        this.startFragment = this.updateValue(this.startFragment, increment);
        this.endFragment = this.updateValue(this.endFragment, increment);
        StringBuffer htmlContent = new StringBuffer(2048);
        htmlContent.append(VERSION).append(this.version).append(FileUtil.LINE_SEP);
        htmlContent.append("StartHTML:").append(this.startHTML).append(FileUtil.LINE_SEP);
        htmlContent.append("StartHTML:").append(this.endHTML).append(FileUtil.LINE_SEP);
        htmlContent.append(START_FRAGMENT).append(this.startFragment).append(FileUtil.LINE_SEP);
        htmlContent.append(END_FRAGMENT).append(this.endFragment).append(FileUtil.LINE_SEP);
        htmlContent.append(SOURCE_URL).append(sourceURL).append(FileUtil.LINE_SEP);
        htmlContent.append(this.htmlSource);
        this.clipboard.setContents(new Object[]{this.textContent, this.rtfContent, htmlContent.toString()}, new Transfer[]{this.textTransfer, this.rtfTransfer, this.htmlTransfer});
    }

    public void dispose() {
        this.clipboard.dispose();
    }

    protected void parseHTMLContent(String htmlContent) {
        int index = htmlContent.indexOf(VERSION);
        if (index > 0) {
            this.version = htmlContent.substring(index + VERSION.length());
            this.version = this.version.substring(0, this.version.indexOf(FileUtil.LINE_SEP));
        }
        if ((index = htmlContent.indexOf("StartHTML:")) > 0) {
            this.startHTML = htmlContent.substring(index + "StartHTML:".length());
            this.startHTML = this.startHTML.substring(0, this.startHTML.indexOf(FileUtil.LINE_SEP));
        }
        if ((index = htmlContent.indexOf("StartHTML:")) > 0) {
            this.endHTML = htmlContent.substring(index + "StartHTML:".length());
            this.endHTML = this.endHTML.substring(0, this.endHTML.indexOf(FileUtil.LINE_SEP));
        }
        if ((index = htmlContent.indexOf(START_FRAGMENT)) > 0) {
            this.startFragment = htmlContent.substring(index + START_FRAGMENT.length());
            this.startFragment = this.startFragment.substring(0, this.startFragment.indexOf(FileUtil.LINE_SEP));
        }
        if ((index = htmlContent.indexOf(END_FRAGMENT)) > 0) {
            this.endFragment = htmlContent.substring(index + END_FRAGMENT.length());
            this.endFragment = this.endFragment.substring(0, this.endFragment.indexOf(FileUtil.LINE_SEP));
        }
        if ((index = htmlContent.indexOf(SOURCE_URL)) > 0) {
            this.sourceURL = htmlContent.substring(index + SOURCE_URL.length());
            this.sourceURL = this.sourceURL.substring(0, this.sourceURL.indexOf(FileUtil.LINE_SEP));
        }
        try {
            int startHTMLIndex = Integer.parseInt(this.startHTML);
            this.htmlSource = htmlContent.substring(startHTMLIndex);
        }
        catch (Exception exception) {}
    }

    protected String updateValue(String value, int increment) {
        try {
            String newValue = "" + (Integer.parseInt(value) + increment);
            String result = String.valueOf(value.substring(0, value.length() - newValue.length())) + newValue;
            return result;
        }
        catch (Exception exception) {
            return value;
        }
    }
}

