/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.common.utils;

import java.io.File;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class I18nUtil {
    private I18nUtil() {
    }

    public static String getString(ResourceBundle resourceBundle, String key) {
        if (resourceBundle != null) {
            try {
                return resourceBundle.getString(key);
            }
            catch (MissingResourceException missingResourceException) {}
        }
        return String.valueOf('[') + key + ']';
    }

    public static String formatString(ResourceBundle resourceBundle, String key, Object data) {
        if (resourceBundle != null) {
            try {
                String localizedStr = resourceBundle.getString(key);
                return MessageFormat.format(localizedStr, data);
            }
            catch (MissingResourceException missingResourceException) {}
        }
        return String.valueOf('[') + key + ']';
    }

    public static String formatString(ResourceBundle resourceBundle, String key, Object data1, Object data2) {
        if (resourceBundle != null) {
            try {
                String localizedStr = resourceBundle.getString(key);
                return MessageFormat.format(localizedStr, data1, data2);
            }
            catch (MissingResourceException missingResourceException) {}
        }
        return String.valueOf('[') + key + ']';
    }

    public static String formatString(ResourceBundle resourceBundle, String key, Object[] data) {
        if (resourceBundle != null) {
            try {
                String localizedStr = resourceBundle.getString(key);
                return MessageFormat.format(localizedStr, data);
            }
            catch (MissingResourceException missingResourceException) {}
        }
        return String.valueOf('[') + key + ']';
    }

    public static String getLocalizedFile(String path, Locale locale) {
        String fileName;
        String dir;
        int pathIndex;
        if (locale.equals(Locale.US) || path == null) {
            return null;
        }
        String language = locale.getLanguage();
        String country = locale.getCountry();
        String variant = locale.getVariant();
        String[] localeStrs = new String[3];
        if (variant != null && variant.length() > 0) {
            localeStrs[0] = locale.toString();
        }
        if (country != null && country.length() > 0) {
            localeStrs[1] = String.valueOf(language) + "_" + country;
        }
        if (language != null) {
            localeStrs[2] = language;
        }
        if ((pathIndex = (dir = path.replace('\\', '/')).lastIndexOf("/")) > 0) {
            dir = path.substring(0, pathIndex + 1);
            fileName = path.substring(pathIndex + 1);
        } else {
            fileName = dir;
            dir = "";
        }
        String fileExt = "";
        int extIndex = fileName.lastIndexOf(".");
        if (extIndex > 0) {
            fileExt = fileName.substring(extIndex);
            fileName = fileName.substring(0, extIndex);
        }
        fileName = String.valueOf(dir) + fileName + "_";
        int i = 0;
        while (i < 3) {
            String fname;
            File file;
            if (localeStrs[i] != null && (file = new File(fname = String.valueOf(fileName) + localeStrs[i] + fileExt)).exists()) {
                return fname;
            }
            ++i;
        }
        return null;
    }
}

