/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.common.utils;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.HashMap;

public class ImageUtil {
    private static final int MAX_WRAP_WIDTH = 70;
    private static final int MAX_WRAP_LINE = 3;
    private static HashMap imageCache = new HashMap();

    private ImageUtil() {
    }

    public static BufferedImage getBufferedImage(String imageFile, Component c) {
        if (imageFile == null || c == null) {
            return null;
        }
        BufferedImage bufferedImage = (BufferedImage)imageCache.get(imageFile);
        if (bufferedImage != null) {
            return bufferedImage;
        }
        Image image = c.getToolkit().getImage(imageFile);
        MediaTracker tracker = new MediaTracker(c);
        tracker.addImage(image, 0);
        try {
            tracker.waitForAll();
        }
        catch (InterruptedException interruptedException) {}
        bufferedImage = new BufferedImage(image.getWidth(c), image.getHeight(c), 2);
        Graphics2D g2d = bufferedImage.createGraphics();
        g2d.drawImage(image, 0, 0, c);
        imageCache.put(imageFile, bufferedImage);
        return bufferedImage;
    }

    public static boolean waitForImage(Image image, Component c) {
        MediaTracker tracker = new MediaTracker(c);
        tracker.addImage(image, 0);
        try {
            tracker.waitForAll();
        }
        catch (InterruptedException interruptedException) {}
        return !tracker.isErrorAny();
    }

    public static void drawText(Graphics2D g2d, String text, Font font, Color color, int x, int y) {
        if (text == null || text.length() == 0) {
            return;
        }
        g2d.setColor(color);
        FontRenderContext frc = g2d.getFontRenderContext();
        TextLayout textlayout = new TextLayout(text, font, frc);
        textlayout.draw(g2d, x, y);
    }

    public static void drawText(Graphics2D g2d, String text, Font font, Color color, int x, int y, float width) {
        if (text == null || text.length() == 0) {
            return;
        }
        float maxWrapWidth = 70.0f;
        if (width > maxWrapWidth) {
            maxWrapWidth = width;
        }
        g2d.setColor(color);
        Point2D.Float pen = new Point2D.Float(x, y);
        HashMap<TextAttribute, Font> attributes = new HashMap<TextAttribute, Font>();
        attributes.put(TextAttribute.FONT, font);
        AttributedCharacterIterator textIterator = new AttributedString(text, attributes).getIterator();
        FontRenderContext frc = g2d.getFontRenderContext();
        LineBreakMeasurer measurer = new LineBreakMeasurer(textIterator, frc);
        int line = 1;
        while (line <= 3) {
            TextLayout layout = measurer.nextLayout(maxWrapWidth);
            if (layout == null) break;
            pen.y += layout.getAscent();
            float dx = 0.0f;
            if (layout.isLeftToRight()) {
                dx = width - layout.getAdvance();
            }
            layout.draw(g2d, pen.x + dx / 2.0f, pen.y);
            pen.y += layout.getDescent() + layout.getLeading() - 1.0f;
            ++line;
        }
    }
}

