/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.ui.ISourceProvider;
import org.eclipse.ui.ISourceProviderListener;

public abstract class AbstractSourceProvider
implements ISourceProvider {
    private Collection listeners = null;

    public final void addSourceProviderListener(ISourceProviderListener listener) {
        if (listener == null) {
            throw new NullPointerException("The listener cannot be null");
        }
        if (this.listeners == null) {
            this.listeners = new ArrayList(1);
        } else if (this.listeners.contains(listener)) {
            return;
        }
        this.listeners.add(listener);
    }

    protected final void fireSourceChanged(int sourcePriority, String sourceName, Object sourceValue) {
        if (this.listeners != null && !this.listeners.isEmpty()) {
            Iterator listenerItr = this.listeners.iterator();
            while (listenerItr.hasNext()) {
                ISourceProviderListener listener = (ISourceProviderListener)listenerItr.next();
                listener.sourceChanged(sourcePriority, sourceName, sourceValue);
            }
        }
    }

    protected final void fireSourceChanged(int sourcePriority, Map sourceValuesByName) {
        if (this.listeners != null && !this.listeners.isEmpty()) {
            Iterator listenerItr = this.listeners.iterator();
            while (listenerItr.hasNext()) {
                ISourceProviderListener listener = (ISourceProviderListener)listenerItr.next();
                listener.sourceChanged(sourcePriority, sourceValuesByName);
            }
        }
    }

    public final void removeSourceProviderListener(ISourceProviderListener listener) {
        if (listener == null) {
            throw new NullPointerException("The listener cannot be null");
        }
        if (this.listeners != null) {
            this.listeners.remove(listener);
            if (this.listeners.isEmpty()) {
                this.listeners = null;
            }
        }
    }
}

