/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.publishing.layout;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.epf.library.layout.util.XmlElement;

public class BookmarkList {
    private List bookmarks = new ArrayList();

    public void addBookmark(String name, String fileName, boolean setAsDefault) {
        _BookmarkEntry entry = new _BookmarkEntry(name, fileName, setAsDefault);
        this.bookmarks.add(entry);
    }

    public List getBookmarks() {
        return this.bookmarks;
    }

    public XmlElement getXmlElement() {
        XmlElement elementXml = new XmlElement("Bookmarks");
        Iterator it = this.bookmarks.iterator();
        while (it.hasNext()) {
            _BookmarkEntry entry = (_BookmarkEntry)it.next();
            String bookmark = entry.fileName;
            String url = "";
            int indx = bookmark.lastIndexOf(".");
            if (indx > 0) {
                url = String.valueOf(bookmark.substring(0, indx)) + ".html";
            }
            elementXml.newChild("Bookmark").setAttribute("name", bookmark).setAttribute("tabName", entry.tabName).setAttribute("url", url).setAttribute("default", entry.isDefault ? "true" : "false");
        }
        return elementXml;
    }

    private class _BookmarkEntry {
        private String fileName;
        private String tabName;
        boolean isDefault;

        _BookmarkEntry(String name, String fileName, boolean isDefault) {
            this.tabName = name;
            this.fileName = fileName;
            this.isDefault = isDefault;
        }
    }
}

