/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.publishing.services;

import com.ibm.uma.MethodElement;
import com.ibm.uma.MethodLibrary;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.epf.library.layout.ElementLayoutManager;
import org.eclipse.epf.library.layout.HtmlBuilder;
import org.eclipse.epf.library.services.LibraryProcessor;
import org.eclipse.epf.publishing.layout.Bookmark;
import org.eclipse.epf.publishing.services.AbstractViewBuilder;

public class LibraryViewBuilder
extends AbstractViewBuilder {
    public LibraryViewBuilder(HtmlBuilder builder) {
        super(builder, null);
    }

    public static LibraryViewBuilder getViewBuilder(String pubDir) {
        ElementLayoutManager layoutMgr = new ElementLayoutManager(null, pubDir);
        HtmlBuilder builder = new HtmlBuilder(layoutMgr);
        return new LibraryViewBuilder(builder);
    }

    public List buildViews(IProgressMonitor monitor) {
        MethodLibrary library = LibraryProcessor.getInstance().getLibrary();
        Bookmark root = super.createBookmark(monitor, library);
        ElementLayoutManager layoutMgr = LibraryProcessor.getInstance().getConfigurationFactory().getLayoutManager(null);
        this.iterateElement(monitor, layoutMgr, root, (MethodElement)library);
        ArrayList<Bookmark> views = new ArrayList<Bookmark>();
        views.add(root);
        return views;
    }

    private void iterateElement(IProgressMonitor monitor, ElementLayoutManager layoutMgr, Bookmark parent, MethodElement element) {
        Bookmark b = super.createBookmark(monitor, element);
        parent.addChild(b);
        EList children = element.eContents();
        if (children != null) {
            Iterator it = children.iterator();
            while (it.hasNext()) {
                Object e = it.next();
                if (!(e instanceof MethodElement)) continue;
                this.iterateElement(monitor, layoutMgr, b, (MethodElement)e);
            }
        }
    }
}

