/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.publishing.services.index;

import java.io.OutputStreamWriter;
import org.eclipse.epf.publishing.services.index.HelpMessages;
import org.eclipse.epf.publishing.services.index.KeyWord;
import org.eclipse.epf.publishing.services.index.KeyWordIndexHelper;
import org.eclipse.epf.publishing.services.index.MiscStatic;

public class Document {
    private String title = null;
    private String url = null;
    private KeyWord parentM = null;

    public Document(String title, String url) {
        this.title = title;
        this.url = url.replace('\\', '/');
    }

    public void setKeyWord(KeyWord key) {
        this.parentM = key;
    }

    public String getTitle() {
        return this.title;
    }

    public String getUrl() {
        int first = this.url.indexOf("#");
        if (this.parentM != null && first < 0) {
            this.url = String.valueOf(this.url) + "#" + this.parentM.getAnchor("");
            return this.url;
        }
        if (first > 0 && this.url.indexOf("#", first) > 0) {
            return this.url.substring(0, first + this.url.indexOf("#", first));
        }
        return this.url;
    }

    public void print(OutputStreamWriter outP) {
        if (outP == null) {
            System.out.println("Document.print\n" + HelpMessages.BAD_OUTPUT_STREAM);
            return;
        }
        String totalUrl = this.url;
        String tmpTitle = null;
        tmpTitle = this.title;
        if (this.parentM != null) {
            totalUrl = String.valueOf(totalUrl) + "#" + this.parentM.getAnchor("");
        }
        if (tmpTitle == null || tmpTitle.equals("")) {
            tmpTitle = "<FONT COLOR=\"#009933\">HelpMessages.TITLE_ANCHOR_MISSING</FONT>";
        }
        String target = null;
        if (!KeyWordIndexHelper.defObj.getTarget().equals(" ")) {
            target = " TARGET=\"" + KeyWordIndexHelper.defObj.getTarget() + "\" ";
        }
        MiscStatic.print(outP, "<A HREF=\"" + totalUrl + "\" ");
        if (target != null) {
            MiscStatic.print(outP, target);
        }
        MiscStatic.print(outP, ">" + tmpTitle + "</A>");
    }
}

