/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.publishing.services.index;

import java.io.OutputStreamWriter;
import java.util.Vector;
import org.eclipse.epf.publishing.services.index.Def;
import org.eclipse.epf.publishing.services.index.Document;
import org.eclipse.epf.publishing.services.index.HelpMessages;
import org.eclipse.epf.publishing.services.index.IO;
import org.eclipse.epf.publishing.services.index.KeyWordIndexHelper;
import org.eclipse.epf.publishing.services.index.MiscStatic;
import org.eclipse.epf.publishing.services.index.SpecKeyWord;

public class KeyWord {
    private String keyWord = null;
    private Vector myKeyWords = null;
    private Vector myDocuments = null;
    private SpecKeyWord mySpecKeyWord = null;
    private KeyWord parentM = null;

    public KeyWord(String keyWord, KeyWord key) {
        this.keyWord = keyWord;
        this.parentM = key;
    }

    public String getKeyWord() {
        return this.keyWord;
    }

    public void addKeyWord(String key, Document doc) {
        int index = MiscStatic.getIndex(key, KeyWordIndexHelper.defObj.levelSeparatorReplace, 0);
        if (index == -1) {
            this.addDocument(doc);
        } else {
            int index2 = MiscStatic.getIndex(key, KeyWordIndexHelper.defObj.levelSeparatorReplace, index + 1);
            String nextKeyWord = null;
            nextKeyWord = index2 != -1 ? key.substring(index + 1, index2) : key.substring(index + 1);
            KeyWord tmpKey = this.createKeyWord(nextKeyWord);
            if (tmpKey != null) {
                tmpKey.addKeyWord(key.substring(index + 1), doc);
            }
        }
    }

    public void setSpecKeyWord(String relatedKey, boolean see) {
        IO.printDebug("setSpecKeyWord " + relatedKey);
        this.mySpecKeyWord = new SpecKeyWord(relatedKey, see);
    }

    public void insertSpecKeyWord(String specKeyWordString, String relatedKeyWord) {
        boolean found = false;
        int i = 0;
        String firstKeyWord = specKeyWordString;
        int pos = specKeyWordString.indexOf(KeyWordIndexHelper.defObj.levelSeparatorReplace, 0);
        if (pos != -1) {
            firstKeyWord = specKeyWordString.substring(0, pos);
        }
        while (!found && this.myKeyWords != null && i < this.myKeyWords.size()) {
            KeyWord tmpK = (KeyWord)this.myKeyWords.elementAt(i);
            if (firstKeyWord.equals(tmpK.getKeyWord())) {
                found = true;
                if (pos != -1) {
                    tmpK.insertSpecKeyWord(specKeyWordString.substring(pos + 1), relatedKeyWord);
                } else {
                    tmpK.setSpecKeyWord(relatedKeyWord, false);
                }
            }
            ++i;
        }
        if (!found) {
            int index = -1;
            i = 0;
            KeyWord newKeyWord2 = new KeyWord(firstKeyWord, this);
            IO.printDebug("new keyword " + firstKeyWord);
            if (pos == -1) {
                newKeyWord2.setSpecKeyWord(relatedKeyWord, true);
            } else {
                newKeyWord2.insertSpecKeyWord(specKeyWordString.substring(pos + 1), relatedKeyWord);
            }
            if (this.myKeyWords == null) {
                IO.printDebug("myKeyWords");
                this.myKeyWords = new Vector();
            }
            while (index == -1 && i < this.myKeyWords.size()) {
                KeyWord tmpK = (KeyWord)this.myKeyWords.elementAt(i);
                if (newKeyWord2.getKeyWord().toUpperCase().compareTo(tmpK.getKeyWord().toUpperCase()) < 0) {
                    index = i;
                } else if (newKeyWord2.getKeyWord().toUpperCase().compareTo(tmpK.getKeyWord().toUpperCase()) == 0 && newKeyWord2.getKeyWord().compareTo(tmpK.getKeyWord()) != 0) {
                    index = newKeyWord2.getKeyWord().compareTo(tmpK.getKeyWord()) > 0 ? i : i - 1;
                }
                ++i;
            }
            if (index != -1) {
                this.myKeyWords.insertElementAt(newKeyWord2, index);
            } else {
                this.myKeyWords.insertElementAt(newKeyWord2, this.myKeyWords.size());
            }
        }
    }

    private KeyWord createKeyWord(String key) {
        if (this.myKeyWords == null) {
            this.myKeyWords = new Vector();
            KeyWord newKeyWord = new KeyWord(key, this);
            this.myKeyWords.addElement(newKeyWord);
            return newKeyWord;
        }
        int index = -1;
        int i = 0;
        KeyWord newKeyWord2 = new KeyWord(key, this);
        while (index == -1 && i < this.myKeyWords.size()) {
            KeyWord tmpK = (KeyWord)this.myKeyWords.elementAt(i);
            if (newKeyWord2.getKeyWord().toUpperCase().compareTo(tmpK.getKeyWord().toUpperCase()) < 0) {
                index = i;
            } else if (newKeyWord2.getKeyWord().toUpperCase().compareTo(tmpK.getKeyWord().toUpperCase()) == 0) {
                if (newKeyWord2.getKeyWord().compareTo(tmpK.getKeyWord()) != 0) {
                    index = newKeyWord2.getKeyWord().compareTo(tmpK.getKeyWord()) < 0 ? i : i + 1;
                } else {
                    return tmpK;
                }
            }
            ++i;
        }
        if (index != -1) {
            this.myKeyWords.insertElementAt(newKeyWord2, index);
            return newKeyWord2;
        }
        this.myKeyWords.insertElementAt(newKeyWord2, this.myKeyWords.size());
        return newKeyWord2;
    }

    private void addDocument(Document doc) {
        doc.setKeyWord(this);
        if (this.myDocuments == null) {
            this.myDocuments = new Vector();
            this.myDocuments.addElement(doc);
        } else {
            int index = -1;
            int i = 0;
            while (index == -1 && i < this.myDocuments.size()) {
                Document tmpD = (Document)this.myDocuments.elementAt(i);
                if (doc.getTitle().compareTo(tmpD.getTitle()) < 0) {
                    index = i;
                }
                ++i;
            }
            if (index != -1) {
                this.myDocuments.insertElementAt(doc, index);
            } else {
                this.myDocuments.insertElementAt(doc, this.myDocuments.size());
            }
        }
    }

    public void print(OutputStreamWriter outP, int level) {
        if (outP == null) {
            System.err.println("KeyWord:print\n" + HelpMessages.BAD_OUTPUT_STREAM);
            return;
        }
        KeyWordIndexHelper.defObj.printStart(outP, level + 1);
        if (level == 0) {
            MiscStatic.print(outP, "<A NAME=\"" + this.keyWord + "\"> </A>");
        }
        MiscStatic.printSpace(outP, level * 4);
        if (level != 0) {
            MiscStatic.printSpace(outP, 2);
        }
        if (this.myDocuments != null) {
            if (!KeyWordIndexHelper.defObj.getShowDocumentTitle() && !KeyWordIndexHelper.defObj.getMulitDocumentKeyword()) {
                Document tmpD = (Document)this.myDocuments.elementAt(0);
                tmpD.setKeyWord(this);
                MiscStatic.print(outP, "<A HREF=\"" + tmpD.getUrl() + "\" TARGET=\"" + KeyWordIndexHelper.defObj.getTarget() + "\">" + this.keyWord + "</A>");
            } else if (!KeyWordIndexHelper.defObj.getMulitDocumentKeyword()) {
                MiscStatic.print(outP, this.keyWord);
                Document tmpD = (Document)this.myDocuments.elementAt(0);
                tmpD.setKeyWord(this);
                tmpD.print(outP);
            } else {
                MiscStatic.print(outP, this.keyWord);
                MiscStatic.printSpace(outP, 1);
                int i = 0;
                while (i < this.myDocuments.size()) {
                    Document tmpD = (Document)this.myDocuments.elementAt(i);
                    tmpD.setKeyWord(this);
                    tmpD.print(outP);
                    if (i != this.myDocuments.size() - 1) {
                        MiscStatic.print(outP, ", ");
                    }
                    MiscStatic.print(outP, "\n");
                    ++i;
                }
            }
        } else {
            MiscStatic.print(outP, this.keyWord);
        }
        if (this.mySpecKeyWord != null) {
            this.mySpecKeyWord.print(outP);
        }
        if (KeyWordIndexHelper.defObj.getStyleSheet(Def.DefaultStyle) == null) {
            MiscStatic.print(outP, "<BR>");
        }
        KeyWordIndexHelper.defObj.printEnd(outP, level + 1);
        if (this.myKeyWords != null) {
            int tmpL = level + 1;
            int i = 0;
            while (i < this.myKeyWords.size()) {
                KeyWord tmpK = (KeyWord)this.myKeyWords.elementAt(i);
                tmpK.print(outP, tmpL);
                ++i;
            }
        }
    }

    public String getAnchor(String part) {
        part = String.valueOf(this.keyWord.replace(' ', '_')) + part;
        if (this.parentM != null) {
            part = String.valueOf(KeyWordIndexHelper.defObj.getKeyWordLevelSeparator()) + part;
            return this.parentM.getAnchor(part);
        }
        part = String.valueOf(KeyWordIndexHelper.defObj.getKeyWordPrefix()) + part;
        return part;
    }
}

