/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.publishing.services.index;

import java.util.Vector;
import org.eclipse.epf.publishing.services.index.Document;
import org.eclipse.epf.publishing.services.index.HelpMessages;
import org.eclipse.epf.publishing.services.index.KeyWordIndexHelper;
import org.eclipse.epf.publishing.services.index.MiscStatic;

public class KeyWordFile {
    private String title = null;
    private String url = null;
    private int nextKeyWord = 0;
    private Vector keyWordVector = null;

    public KeyWordFile(String title, String url, String keyWords) {
        this.title = title;
        this.url = url;
        this.createKeyWordVector(keyWords);
    }

    public String getNextKeyWord() {
        if (this.nextKeyWord < this.keyWordVector.size()) {
            String next = (String)this.keyWordVector.elementAt(this.nextKeyWord);
            ++this.nextKeyWord;
            if (next != null) {
                return next;
            }
            return null;
        }
        return null;
    }

    public Document getDocument(String keyWord, int noOfDoc) {
        if (noOfDoc > 1) {
            return null;
        }
        return new Document(this.title, this.url);
    }

    private void createKeyWordVector(String key) {
        if (key == null) {
            System.err.println("KeyWordFile:createKeyWordVector\n" + HelpMessages.INPUT_PARAMETER_NULL);
            return;
        }
        this.keyWordVector = new Vector();
        int start = 0;
        while (start < key.length()) {
            int index = key.indexOf(KeyWordIndexHelper.defObj.keyWordSeparator, start);
            if (index == -1) {
                index = key.length();
            }
            this.keyWordVector.addElement(new String(key.substring(start, index).trim()));
            start = index + 1;
        }
    }

    private boolean matchKeyWord(String anchor) {
        int i = 0;
        while (i < this.keyWordVector.size()) {
            if (MiscStatic.getIndex(anchor, (String)this.keyWordVector.elementAt(i), 0) != -1) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

