/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.publishing.services.index;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.epf.publishing.services.index.HelpMessages;
import org.eclipse.epf.publishing.services.index.IO;
import org.eclipse.epf.publishing.services.index.KeyWordIndexHelper;

public class KeyWordStatic {
    public static final Pattern p_index_ref = Pattern.compile("<a.*?\\sname\\s*=\\s*\"(.*?)\">", 34);

    public static String getKeyWords(String realString) {
        if (realString == null) {
            System.err.println("KeyWordStatic:getKeyWords\n" + HelpMessages.INPUT_PARAMETER_NULL);
            return null;
        }
        StringBuffer anchors = new StringBuffer();
        Matcher m = p_index_ref.matcher(realString);
        while (m.find()) {
            String keyWord = m.group(1);
            if (!keyWord.startsWith(KeyWordIndexHelper.defObj.getKeyWordPrefix())) continue;
            if (anchors.length() > 0) {
                anchors.append(KeyWordIndexHelper.defObj.keyWordSeparator);
            }
            anchors.append(KeyWordStatic.convertKeyWord(keyWord));
        }
        return anchors.toString();
    }

    public static String convertKeyWord(String keyWord) {
        if (keyWord == null) {
            System.err.println("KeyWordStatic:convertKeyWord\n" + HelpMessages.INPUT_PARAMETER_NULL);
            return null;
        }
        IO.printDebug("convertKeyWord " + keyWord);
        if (!keyWord.startsWith(KeyWordIndexHelper.defObj.getKeyWordPrefix())) {
            System.out.println("KeyWordStatic:convertKeyWord\n" + keyWord + HelpMessages.KEYWORD_SYNTAX_ERROR + KeyWordIndexHelper.defObj.getKeyWordPrefix());
            return null;
        }
        String tmpK = keyWord.substring(3);
        String tmp = "";
        int i = 0;
        int pos = 0;
        while (i != -1) {
            i = tmpK.indexOf(KeyWordIndexHelper.defObj.getKeyWordLevelSeparator(), pos);
            if (i != -1) {
                tmp = String.valueOf(tmp) + tmpK.substring(pos, i);
                tmp = String.valueOf(tmp) + KeyWordIndexHelper.defObj.levelSeparatorReplace;
                pos = i + 2;
                continue;
            }
            tmp = String.valueOf(tmp) + tmpK.substring(pos);
        }
        return tmp.replace('_', ' ');
    }
}

