/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.publishing.services.search;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexWriter;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.epf.publishing.PublishingResources;
import org.eclipse.epf.publishing.services.search.DocumentFactory;
import org.eclipse.epf.publishing.services.search.JarCreator;
import org.eclipse.epf.publishing.services.search.StopWordReader;
import org.eclipse.epf.search.analysis.TextAnalyzer;

public class IndexManager {
    public static final String VERSION_FILE_NAME = "version.txt";
    public static final String VERSION_DELIMITER = "*";
    public static final String STOPWORDS_FILE = "search_stopwords.cfg";

    public static boolean createIndex(String publishDir, IProgressMonitor monitor) throws ClassNotFoundException, IOException {
        if (monitor != null && monitor.isCanceled()) {
            return false;
        }
        String siteName = publishDir.replace(File.separatorChar, '/');
        int index = siteName.length();
        if (siteName.endsWith("/")) {
            --index;
        }
        int index2 = siteName.lastIndexOf("/", index - 1);
        siteName = siteName.substring(index2 + 1, index);
        String searchFolder = publishDir;
        if (!searchFolder.endsWith(File.separator)) {
            searchFolder = String.valueOf(searchFolder) + File.separator;
        }
        searchFolder = String.valueOf(searchFolder) + "applet" + File.separator + "search";
        String indexFolder = String.valueOf(searchFolder) + File.separator + "index";
        if (monitor != null) {
            monitor.worked(1);
        }
        ArrayList activeFiles = new ArrayList();
        IndexManager.iterateFiles(new File(publishDir), activeFiles, monitor);
        if (monitor != null && monitor.isCanceled()) {
            return false;
        }
        IndexManager.index(publishDir, activeFiles, indexFolder, monitor, true);
        if (monitor != null && monitor.isCanceled()) {
            return false;
        }
        File stopwordsFile = new File(String.valueOf(searchFolder) + File.separator + STOPWORDS_FILE);
        FileReader reader = new FileReader(stopwordsFile);
        BufferedReader bReader = new BufferedReader(reader);
        File newStFile = new File(String.valueOf(indexFolder) + File.separator + STOPWORDS_FILE);
        FileWriter writer = new FileWriter(newStFile);
        BufferedWriter bWriter = new BufferedWriter(writer);
        String temp = bReader.readLine();
        while (temp != null) {
            bWriter.write(String.valueOf(temp) + "\n");
            temp = bReader.readLine();
        }
        bWriter.close();
        writer.close();
        bReader.close();
        reader.close();
        System.out.println("index created successfully");
        if (monitor != null && monitor.isCanceled()) {
            return false;
        }
        JarCreator.jarFolder(indexFolder);
        System.out.println("index Jarred successfully");
        File indexDir = new File(indexFolder);
        File[] files = indexDir.listFiles();
        int i = 0;
        while (i < files.length) {
            File tempFile = files[i];
            if (!tempFile.getName().equals("index.jar")) {
                tempFile.delete();
            }
            ++i;
        }
        Date today = new Date();
        long milliseconds = today.getTime();
        File newIndexJar = new File(String.valueOf(indexFolder) + File.separator + "index.jar");
        if (!newIndexJar.exists()) {
            throw new IOException(PublishingResources.getString("Publishing.createSearchIndexError.msg"));
        }
        String fileSize = "" + newIndexJar.length();
        FileWriter fw = new FileWriter(String.valueOf(indexFolder) + File.separator + VERSION_FILE_NAME);
        BufferedWriter bw = new BufferedWriter(fw);
        bw.write(String.valueOf(siteName) + VERSION_DELIMITER + milliseconds + VERSION_DELIMITER + fileSize + "\n");
        bw.close();
        fw.close();
        return true;
    }

    public static void index(String fileDirectory, List activeFiles, String indexName, IProgressMonitor monitor, boolean isNewIndex) {
        Iterator fileList = activeFiles.iterator();
        StopWordReader.getStopwords(String.valueOf(fileDirectory) + File.separator + "applet" + File.separator + "search", STOPWORDS_FILE);
        if (isNewIndex) {
            try {
                IndexWriter writer = new IndexWriter(indexName, (Analyzer)new TextAnalyzer(), isNewIndex);
                if (writer != null && fileList != null) {
                    IndexManager.indexDocs(writer, fileList, monitor);
                }
                writer.optimize();
                writer.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected static void indexDocs(IndexWriter writer, Iterator fileList, IProgressMonitor monitor) throws IOException {
        System.gc();
        while (fileList.hasNext()) {
            if (monitor != null && monitor.isCanceled()) {
                return;
            }
            File file = (File)fileList.next();
            try {
                Document doc = DocumentFactory.document(file);
                if (doc != null) {
                    writer.addDocument(doc);
                }
                if (monitor == null) continue;
                monitor.worked(1);
            }
            catch (Exception e1) {
                System.out.println(file.getName());
                e1.printStackTrace();
            }
        }
    }

    private static void iterateFiles(File f, List files, IProgressMonitor monitor) {
        if (monitor != null && monitor.isCanceled()) {
            return;
        }
        if (f.isDirectory()) {
            if (f.getName().equalsIgnoreCase("applet")) {
                return;
            }
            String[] kids = f.list();
            int i = 0;
            while (i < kids.length) {
                if (monitor != null && monitor.isCanceled()) {
                    return;
                }
                IndexManager.iterateFiles(new File(f, kids[i]), files, monitor);
                ++i;
            }
        } else {
            files.add(f);
        }
    }
}

