/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.importing.services;

import com.ibm.uma.MethodLibrary;
import java.io.File;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.epf.export.services.LibraryDocument;
import org.eclipse.epf.importing.ImportPlugin;
import org.eclipse.epf.importing.ImportResources;
import org.eclipse.epf.importing.services.ConfigSpecsImportManager;
import org.eclipse.epf.importing.services.ConfigurationImportData;
import org.eclipse.epf.importing.services.ElementDiffTree;
import org.eclipse.epf.importing.services.LibraryDiffManager;
import org.eclipse.epf.importing.services.LibraryImportManager;
import org.eclipse.epf.library.services.LibraryProcessor;
import org.eclipse.epf.library.util.LibraryUtil;

public class ConfigurationImportService {
    private ConfigurationImportData data;
    LibraryDocument importingLibDoc = null;
    LibraryDiffManager diffMgr = null;
    ConfigSpecsImportManager specsMgr = null;

    public ConfigurationImportService(ConfigurationImportData data) {
        this.data = data;
    }

    public void analyze(IProgressMonitor monitor) {
        try {
            File importingLibPath;
            if (monitor != null) {
                monitor.setTaskName(ImportResources.getString("Import.ConfigurationImportService.MSG0"));
            }
            this.data.getErrorInfo().clear();
            String path = this.data.llData.getParentFolder();
            if (path.indexOf(String.valueOf(File.separator) + "library.xmi") < 0) {
                path = String.valueOf(path) + File.separator + "library.xmi";
            }
            if (!(importingLibPath = new File(path)).exists()) {
                importingLibPath = new File(importingLibPath.getParentFile(), "export.xmi");
            }
            if (!importingLibPath.exists()) {
                this.data.getErrorInfo().addError(ImportResources.getString("Import.ConfigurationImportService.MSG1", importingLibPath.getParent()));
                return;
            }
            this.importingLibDoc = new LibraryDocument(importingLibPath);
            boolean isConfigSpecs = this.importingLibDoc.isConfigSpecsOnly();
            if (isConfigSpecs) {
                this.specsMgr = new ConfigSpecsImportManager();
                this.data.specs = this.specsMgr.getConfigSpecs(this.importingLibDoc);
            } else {
                this.data.specs = null;
                MethodLibrary importLibraty = LibraryUtil.loadLibrary((String)importingLibPath.getAbsolutePath());
                MethodLibrary baseLibrary = LibraryProcessor.getInstance().getLibrary();
                this.diffMgr = new LibraryDiffManager(baseLibrary, importLibraty);
                this.diffMgr.buildDiffTree();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public ConfigurationImportData getImportData() {
        return this.data;
    }

    public boolean isSpecsOnly() {
        return this.data.specs != null;
    }

    public ElementDiffTree getDiffTree() {
        return this.diffMgr.getDiffTree();
    }

    public MethodLibrary getImportingLibrary() {
        return this.diffMgr.getImportingLibrary();
    }

    public void performImport(IProgressMonitor monitor) {
        try {
            if (monitor != null) {
                monitor.setTaskName(ImportResources.getString("Import.ConfigurationImportService.MSG3"));
            }
            if (this.isSpecsOnly()) {
                this.specsMgr.doImport(this.data.specs);
            } else {
                LibraryImportManager importingMgr = new LibraryImportManager(this.diffMgr.getDiffTree(), this.diffMgr.getDiffTreeMap(), this.data.importList);
                importingMgr.doMerge(this.data.replaceExisting);
            }
            File libFile = new File(LibraryProcessor.getInstance().getLibraryURI().toFileString());
            LibraryProcessor.getInstance().openLibrary(libFile.getAbsolutePath());
        }
        catch (Exception e) {
            ImportPlugin.getDefault().getLogger().logError((Throwable)e);
        }
    }
}

