/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.importing.services;

import com.ibm.uma.MethodElement;
import com.ibm.uma.MethodLibrary;
import com.ibm.uma.MethodUnit;
import java.util.ArrayList;
import java.util.List;

public class ElementDiffTree {
    public static final int DIFF_STATE_SAME = 0;
    public static final int DIFF_STATE_NEW = 1;
    public static final int DIFF_STATE_CHANGED = 4;
    public static final int DIFF_STATE_OLD_ONLY = 5;
    private MethodElement e1;
    private MethodElement e2;
    private MethodElement e1_parent;
    private ElementDiffTree parent = null;
    private int diffState = 0;
    private List children = new ArrayList();
    private boolean hasDirtyChild = false;

    public ElementDiffTree(MethodElement e1, MethodElement e2) {
        this(e1, e2, null);
    }

    public ElementDiffTree(MethodElement e1, MethodElement e2, MethodElement e1_parent) {
        this.e1_parent = e1_parent;
        this.e1 = e1;
        this.e2 = e2;
        this.resolveDiffState();
    }

    public MethodElement getBaseElement() {
        return this.e1;
    }

    public MethodElement getBaseParentElement() {
        return this.e1_parent;
    }

    public MethodElement getImportElement() {
        return this.e2;
    }

    public boolean isNew() {
        return this.e1 == null && this.e2 != null;
    }

    public boolean isOldOnly() {
        return this.e1 != null && this.e2 == null;
    }

    public boolean isBoth() {
        return this.e1 != null && this.e2 != null;
    }

    public void addChild(ElementDiffTree child) {
        this.children.add(child);
        child.setParent(this);
    }

    public boolean hasDirtyChild() {
        return this.hasDirtyChild;
    }

    public void setDirtyChild(boolean flag) {
        boolean bl = this.hasDirtyChild = this.hasDirtyChild || flag;
        if (this.hasDirtyChild && this.parent != null) {
            this.parent.setDirtyChild(this.hasDirtyChild);
        }
    }

    private void setParent(ElementDiffTree parent) {
        this.parent = parent;
        if (this.diffState != 0 && parent != null) {
            parent.setDirtyChild(true);
        }
    }

    public ElementDiffTree getParent() {
        return this.parent;
    }

    public boolean hasChildren() {
        return this.children != null && this.children.size() > 0;
    }

    public List getChildren() {
        return this.children;
    }

    public int getDiffState() {
        return this.diffState;
    }

    public String getDiffMessage() {
        return "[" + this.getVersion(this.e1) + "] : [" + this.getVersion(this.e2) + "]";
    }

    private void resolveDiffState() {
        this.diffState = this.e1 == null ? 1 : (this.e2 == null ? 5 : (this.e1 instanceof MethodLibrary ? 0 : 4));
    }

    private String getVersion(MethodElement element) {
        if (element == null) {
            return "";
        }
        return this.getPackage(element).getVersion();
    }

    private MethodUnit getPackage(MethodElement element) {
        if (element instanceof MethodUnit) {
            return (MethodUnit)element;
        }
        return this.getPackage((MethodElement)element.eContainer());
    }

    public String getName() {
        if (this.e1 != null) {
            return this.e1.getName();
        }
        if (this.e2 != null) {
            return this.e2.getName();
        }
        return "";
    }

    public String getContentType() {
        MethodElement e = this.e1;
        if (e == null) {
            e = this.e2;
        }
        if (e != null) {
            return e.getType().getName();
        }
        return "";
    }
}

