/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.importing.services;

import com.ibm.uma.MethodElement;
import com.ibm.uma.MethodLibrary;
import com.ibm.uma.MethodPackage;
import com.ibm.uma.MethodPlugin;
import com.ibm.uma.provider.UmaItemProviderAdapterFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.epf.importing.ImportPlugin;
import org.eclipse.epf.importing.services.ElementDiffTree;
import org.eclipse.epf.library.layout.LayoutResources;
import org.eclipse.epf.library.services.LibraryProcessor;
import org.eclipse.epf.library.util.LibraryUtil;

public class LibraryImportManager {
    private ElementDiffTree rootTree;
    protected AdapterFactoryEditingDomain editingDomain = null;
    protected AdapterFactoryContentProvider afcp = null;
    private Map oldNewReplacedElementMap = new HashMap();

    public LibraryImportManager(ElementDiffTree rootTree, Map diffElementMap, List checkedList) {
        this.rootTree = rootTree;
        this.init();
    }

    private void init() {
        ArrayList<Object> factories = new ArrayList<Object>();
        factories.add(new ResourceItemProviderAdapterFactory());
        factories.add(new UmaItemProviderAdapterFactory());
        factories.add(new ReflectiveItemProviderAdapterFactory());
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(factories);
        this.afcp = new AdapterFactoryContentProvider((AdapterFactory)adapterFactory);
        BasicCommandStack commandStack = new BasicCommandStack();
        this.editingDomain = new AdapterFactoryEditingDomain((AdapterFactory)adapterFactory, (CommandStack)commandStack, new HashMap());
    }

    public void doMerge(boolean replaceExisting) throws Exception {
        MethodLibrary baseLibrary = (MethodLibrary)this.rootTree.getBaseElement();
        MethodLibrary importingLibrary = (MethodLibrary)this.rootTree.getImportElement();
        File srcDir = LibraryUtil.getLibraryRootPath((MethodLibrary)importingLibrary);
        File destDir = LibraryUtil.getLibraryRootPath((MethodLibrary)baseLibrary);
        LibraryUtil.loadAll((MethodLibrary)baseLibrary);
        LibraryUtil.loadAll((MethodLibrary)importingLibrary);
        LibraryUtil.detachFromResource((MethodLibrary)importingLibrary);
        this.processDiffTree(this.rootTree, replaceExisting);
        LibraryUtil.saveAll((MethodLibrary)baseLibrary);
        String includes = "*resources/*.*, **/resources/*.*";
        LayoutResources.copyDir((File)srcDir, (File)destDir, (String)includes, null);
    }

    private void processDiffTree(ElementDiffTree diffTree, boolean replaceExisting) {
        List children;
        if (diffTree == null) {
            return;
        }
        int state = diffTree.getDiffState();
        MethodElement base = diffTree.getBaseElement();
        MethodElement imp = diffTree.getImportElement();
        if (replaceExisting && state == 4 && base instanceof MethodPackage) {
            this.doReplacePackage((MethodPackage)base, (MethodPackage)imp);
        } else if (state == 1) {
            this.doAdd((EObject)diffTree.getBaseParentElement(), (EObject)diffTree.getImportElement());
        }
        if (state != 1 && (children = diffTree.getChildren()) != null && children.size() > 0) {
            Iterator it = children.iterator();
            while (it.hasNext()) {
                this.processDiffTree((ElementDiffTree)it.next(), replaceExisting);
            }
        }
    }

    private void doReplacePackage(MethodPackage oldObj, MethodPackage newObj) {
        this.doReplace((EObject)oldObj, (EObject)newObj);
        List pkgs = newObj.getChildPackages();
        pkgs.clear();
        pkgs.addAll(oldObj.getChildPackages());
    }

    private void doReplace(EObject oldObj, EObject newObj) {
        EObject oldContainer = oldObj.eContainer();
        EcoreUtil.replace((EObject)oldObj, (EObject)newObj);
        EObject newContainer2 = newObj.eContainer();
        if (newContainer2 == null || newContainer2 != oldContainer) {
            ImportPlugin.getDefault().getLogger().logError("Container is wrong!");
        }
        this.oldNewReplacedElementMap.put(oldObj, newObj);
    }

    private void doAdd(EObject owner, EObject newObj) {
        if (owner != null) {
            if (owner instanceof MethodLibrary && newObj instanceof MethodPlugin) {
                LibraryProcessor.getInstance().addMethodPlugin((MethodPlugin)newObj);
            } else {
                if (owner instanceof MethodPackage && owner.eContainer() == null) {
                    owner = (EObject)this.oldNewReplacedElementMap.get(owner);
                }
                if (owner != null) {
                    ImportPlugin.getDefault().getLogger().logError("Add Element: " + newObj);
                    Command cmd = AddCommand.create((EditingDomain)this.editingDomain, (Object)owner, null, (Object)newObj);
                    cmd.execute();
                } else {
                    ImportPlugin.getDefault().getLogger().logError("Unable to find owner for " + newObj);
                }
            }
        }
    }
}

