/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.command;

import com.ibm.uma.CustomCategory;
import com.ibm.uma.MethodElement;
import com.ibm.uma.util.AssociationHelper;
import com.ibm.uma.util.ContentDescriptionFactory;
import com.ibm.uma.util.IMethodLibraryPersister;
import com.ibm.uma.util.UmaUtil;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandWrapper;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.AbstractTreeIterator;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.epf.library.edit.IReferencer;
import org.eclipse.epf.library.edit.IStatefulItemProvider;
import org.eclipse.epf.library.edit.LibraryEditPlugin;
import org.eclipse.epf.library.edit.LibraryEditResources;
import org.eclipse.epf.library.edit.command.Reference;
import org.eclipse.epf.library.edit.ui.UserInteractionHelper;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.ecore.impl.MultiResourceEObject;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;

public class DeleteMethodElementCommand
extends CommandWrapper {
    protected Collection elements;
    private boolean refRemoved;
    public boolean executed = false;
    private Collection commandListeners;
    private IMethodLibraryPersister.FailSafeMethodLibraryPersister persister;
    protected ArrayList elementsToDeleteContent;
    protected Set modifiedResources;
    private HashMap elementToRemovedRefsMap;
    private ArrayList removedReferences;
    public boolean failed;

    public DeleteMethodElementCommand(Command command, Collection elements) {
        super(command);
        this.elements = elements;
        this.commandListeners = new ArrayList();
    }

    protected void superExecute() {
        super.execute();
    }

    public void execute() {
        Iterator iter;
        this.elementsToDeleteContent = new ArrayList();
        Iterator iter2 = this.elements.iterator();
        while (iter2.hasNext()) {
            Object element = TngUtil.unwrap(iter2.next());
            if (!(element instanceof CustomCategory)) continue;
            AbstractTreeIterator iter1 = new AbstractTreeIterator(element, false){

                protected Iterator getChildren(Object object) {
                    ArrayList children = new ArrayList();
                    List catElements = ((CustomCategory)object).getCategorizedElements();
                    Iterator iterator = catElements.iterator();
                    while (iterator.hasNext()) {
                        Object e = iterator.next();
                        if (!(e instanceof CustomCategory)) continue;
                        children.add(e);
                    }
                    return children.iterator();
                }
            };
            while (iter1.hasNext()) {
                this.elementsToDeleteContent.add(iter1.next());
            }
        }
        Object runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                DeleteMethodElementCommand.this.prepareRemovingReferences();
            }
        };
        UserInteractionHelper.runWithProgress(runnable, LibraryEditResources.getString("LibraryEdit.processingReferencesTask.name"));
        if (!this.elementToRemovedRefsMap.isEmpty()) {
            HashSet referencers = new HashSet();
            Iterator iter3 = this.elementToRemovedRefsMap.values().iterator();
            while (iter3.hasNext()) {
                Map referencerToFeaturesMap = (Map)iter3.next();
                referencers.addAll(referencerToFeaturesMap.keySet());
            }
            MultiStatus multiStatus = new MultiStatus(LibraryEditPlugin.INSTANCE.getSymbolicName(), 0, "", null);
            iter = referencers.iterator();
            while (iter.hasNext()) {
                MethodElement e = (MethodElement)iter.next();
                String msg = LibraryEditResources.formatString("LibraryEdit.elementType.text", e.eClass().getName(), TngUtil.getLabelWithPath(e));
                Status status = new Status(1, LibraryEditPlugin.INSTANCE.getSymbolicName(), 0, msg, null);
                multiStatus.add((IStatus)status);
            }
            if (LibraryEditPlugin.getDefault().getMsgDialog().displayConfirmation(LibraryEditResources.getString("LibraryEdit.deleteReferencesDialog.title"), LibraryEditResources.getString("LibraryEdit.deleteReferencesDialog.text"), (IStatus)multiStatus) == 1) {
                return;
            }
        }
        this.modifiedResources = new HashSet(this.getOwnerResources());
        this.superExecute();
        final Exception[] exceptions = new Exception[1];
        BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

            public void run() {
                try {
                    DeleteMethodElementCommand.this.removeReferences();
                }
                catch (Exception e) {
                    exceptions[0] = e;
                }
            }
        });
        if (exceptions[0] != null) {
            LibraryEditPlugin.getDefault().getMsgDialog().displayError(LibraryEditResources.getString("LibraryEdit.deleteDialog.title"), LibraryEditResources.getString("LibraryEdit.deleteElementError.msg"), LibraryEditResources.getString("LibraryEdit.deleteReferencesError.reason"), (Throwable)exceptions[0]);
            this.undo();
            return;
        }
        this.modifiedResources.addAll(this.getReferencingResources());
        IStatus status = UserInteractionHelper.checkModify(this.modifiedResources, null);
        if (!status.isOK()) {
            LibraryEditPlugin.getDefault().getMsgDialog().displayError(LibraryEditResources.getString("LibraryEdit.deleteDialog.title"), LibraryEditResources.getString("LibraryEdit.deleteElementError.msg"), status);
            this.undo();
            return;
        }
        iter = this.elementsToDeleteContent.iterator();
        while (iter.hasNext()) {
            EObject element = (EObject)iter.next();
            if (element.eContainer() == null) continue;
            iter.remove();
        }
        this.elementsToDeleteContent.addAll(this.elements);
        runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                DeleteMethodElementCommand.this.getPersister();
                try {
                    DeleteMethodElementCommand.this.deleteContent();
                    Iterator iter = DeleteMethodElementCommand.this.modifiedResources.iterator();
                    while (iter.hasNext()) {
                        Resource resource = (Resource)iter.next();
                        if (!resource.isLoaded()) continue;
                        DeleteMethodElementCommand.this.persister.save(resource);
                    }
                    DeleteMethodElementCommand.this.persister.commit();
                    DeleteMethodElementCommand.this.executed = true;
                    DeleteMethodElementCommand.this.removeAdapters();
                }
                catch (Exception e) {
                    LibraryEditPlugin.INSTANCE.log(e);
                    try {
                        DeleteMethodElementCommand.this.persister.rollback();
                    }
                    catch (Exception exception) {
                        DeleteMethodElementCommand.this.failed = true;
                    }
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    throw new WrappedException(e);
                }
            }
        };
        if (!UserInteractionHelper.runWithProgress(runnable, LibraryEditResources.getString("LibraryEdit.deletingElementsTask.name"))) {
            if (this.failed) {
                this.notifyFailure();
            } else {
                this.undo();
            }
            return;
        }
        if (this.executed) {
            this.notifyExecuted();
        }
    }

    private static void removeAdapters(EObject element) {
        Iterator iterator = new ArrayList(element.eAdapters()).iterator();
        while (iterator.hasNext()) {
            AdapterFactory adapterFactory;
            Object adapter = iterator.next();
            if (!(adapter instanceof IStatefulItemProvider)) continue;
            ((IStatefulItemProvider)adapter).dispose();
            if (!(adapter instanceof ItemProviderAdapter) || !((adapterFactory = ((ItemProviderAdapter)adapter).getAdapterFactory()) instanceof IReferencer)) continue;
            ((IReferencer)adapterFactory).remove(adapter);
        }
        element.eAdapters().clear();
    }

    protected void removeAdapters() {
        Iterator iter = this.elements.iterator();
        while (iter.hasNext()) {
            EObject element;
            Object obj = TngUtil.unwrap(iter.next());
            if (!(obj instanceof EObject) || (element = (EObject)obj).eContainer() != null) continue;
            TreeIterator iterator = element.eAllContents();
            while (iterator.hasNext()) {
                EObject e = (EObject)iterator.next();
                DeleteMethodElementCommand.removeAdapters(e);
            }
            DeleteMethodElementCommand.removeAdapters(element);
        }
    }

    private void notifyFailure() {
        EventObject eventObject = new EventObject((Object)this);
        Iterator iter = this.commandListeners.iterator();
        while (iter.hasNext()) {
            CommandListener listener = (CommandListener)iter.next();
            listener.notifyFailure(eventObject);
        }
    }

    protected IMethodLibraryPersister.FailSafeMethodLibraryPersister getPersister() {
        if (this.persister == null) {
            this.persister = ContentDescriptionFactory.getMethodLibraryPersister().getFailSafePersister();
        }
        return this.persister;
    }

    private void notifyExecuted() {
        EventObject eventObject = new EventObject((Object)this);
        Iterator iter = this.commandListeners.iterator();
        while (iter.hasNext()) {
            CommandListener listener = (CommandListener)iter.next();
            listener.notifyExecuted(eventObject);
        }
    }

    private Collection getReferencingResources() {
        HashSet<EObject> referrers = new HashSet<EObject>();
        Iterator iter = this.removedReferences.iterator();
        while (iter.hasNext()) {
            Reference ref = (Reference)iter.next();
            referrers.add(ref.owner);
        }
        HashSet<Resource> resources = new HashSet<Resource>();
        Iterator iter2 = referrers.iterator();
        while (iter2.hasNext()) {
            MethodElement element = (MethodElement)iter2.next();
            if (element.eResource() == null) continue;
            resources.add(element.eResource());
        }
        return resources;
    }

    private Collection getOwnerResources() {
        HashSet<Resource> resources = new HashSet<Resource>();
        Iterator iter = this.elements.iterator();
        while (iter.hasNext()) {
            EObject container;
            Object element = TngUtil.unwrap(iter.next());
            if (!(element instanceof MethodElement) || (container = ((MethodElement)element).eContainer()).eResource() == null) continue;
            resources.add(container.eResource());
        }
        return resources;
    }

    public void redo() {
        super.redo();
        this.removeReferences();
    }

    protected void deleteContent() throws Exception {
        Iterator iter = this.elementsToDeleteContent.iterator();
        while (iter.hasNext()) {
            MethodElement e;
            Object element = TngUtil.unwrap(iter.next());
            if (!(element instanceof MethodElement) || (e = (MethodElement)element).eContainer() != null) continue;
            this.persister.delete(e);
        }
    }

    private void saveContainerResource(EObject element) throws Exception {
        Resource resource;
        if (element.eContainer() != null && (resource = element.eContainer().eResource()) != null && resource.isModified()) {
            this.persister.save(resource);
        }
    }

    protected Collection getElementsToRemoveReferences() {
        ArrayList<Object> list = new ArrayList<Object>();
        Iterator iter = this.elements.iterator();
        while (iter.hasNext()) {
            Object element = TngUtil.unwrap(iter.next());
            if (!(element instanceof EObject)) continue;
            list.add(element);
        }
        return list;
    }

    protected boolean canRemoveReferences(MethodElement e) {
        Iterator iter = this.elements.iterator();
        while (iter.hasNext()) {
            Object obj = TngUtil.unwrap(iter.next());
            if (e != obj) continue;
            return e.eContainer() == null;
        }
        return true;
    }

    public List loadOppositeFeatures() {
        HashSet oppositeFeatures = new HashSet();
        HashSet<String> deletedGUIDs = new HashSet<String>();
        ArrayList elements = new ArrayList();
        Iterator iter = this.getElementsToRemoveReferences().iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (!(obj instanceof MethodElement)) continue;
            MethodElement e = (MethodElement)obj;
            TreeIterator iterator = e.eAllContents();
            while (iterator.hasNext()) {
                Object element = iterator.next();
                if (!(element instanceof MethodElement)) continue;
                elements.add(element);
                Map oppositeFeatureMap = ((MultiResourceEObject)element).getOppositeFeatureMap();
                if (oppositeFeatureMap == null || oppositeFeatureMap.isEmpty()) continue;
                oppositeFeatures.addAll(oppositeFeatureMap.keySet());
                deletedGUIDs.add(((MethodElement)element).getGuid());
            }
            elements.add(e);
            Map oppositeFeatureMap = ((MultiResourceEObject)e).getOppositeFeatureMap();
            if (oppositeFeatureMap == null || oppositeFeatureMap.isEmpty()) continue;
            oppositeFeatures.addAll(oppositeFeatureMap.keySet());
            deletedGUIDs.add(e.getGuid());
        }
        this.loadOppositeFeatures(new ArrayList(oppositeFeatures), deletedGUIDs);
        return elements;
    }

    private boolean isContainedByDeletedElement(EObject e) {
        Iterator iter = this.elements.iterator();
        while (iter.hasNext()) {
            Object deleted = TngUtil.unwrap(iter.next());
            if (!(deleted instanceof EObject) || !UmaUtil.isContainedBy((EObject)e, (Object)deleted)) continue;
            return true;
        }
        return false;
    }

    private boolean checkReferencer(EObject referencer) {
        return !this.elements.contains(referencer) && !this.isContainedByDeletedElement(referencer);
    }

    private void prepareRemovingReferences() {
        List elements = this.loadOppositeFeatures();
        this.elementToRemovedRefsMap = new HashMap();
        Iterator iter = elements.iterator();
        while (iter.hasNext()) {
            MethodElement element = (MethodElement)iter.next();
            Map refMap = AssociationHelper.getReferenceMap((MethodElement)element);
            if (refMap.isEmpty()) continue;
            Iterator iterator = refMap.keySet().iterator();
            while (iterator.hasNext()) {
                EObject referencer = (EObject)iterator.next();
                if (!elements.contains(referencer) && !this.isContainedByDeletedElement(referencer)) continue;
                iterator.remove();
            }
            if (refMap.isEmpty()) continue;
            this.elementToRemovedRefsMap.put(element, refMap);
        }
        if (TngUtil.DEBUG) {
            System.out.println("elementToRemovedRefsMap: size=" + this.elementToRemovedRefsMap.size());
        }
    }

    protected void removeReferences() {
        if (this.refRemoved) {
            return;
        }
        if (this.removedReferences == null) {
            this.removedReferences = new ArrayList();
        } else {
            this.removedReferences.clear();
        }
        Iterator iter = this.elementToRemovedRefsMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            MethodElement referenced = (MethodElement)entry.getKey();
            if (!this.canRemoveReferences(referenced)) continue;
            Map removedRefMap = (Map)entry.getValue();
            Iterator iterator = removedRefMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry ent = iterator.next();
                EObject referencer = (EObject)ent.getKey();
                Collection features = (Collection)ent.getValue();
                Iterator iter1 = features.iterator();
                block2: while (iter1.hasNext()) {
                    EStructuralFeature feature = (EStructuralFeature)iter1.next();
                    if (feature.isMany()) {
                        List list = (List)referencer.eGet(feature);
                        int index = list.indexOf(referenced);
                        if (index != -1) {
                            list.remove(index);
                            this.removedReferences.add(new Reference(referencer, feature, referenced, index));
                            continue;
                        }
                        if (TngUtil.DEBUG) {
                            System.out.println("DeleteMethodElementCommand.removeReferences(): index=" + index + ", size=" + list.size() + ", referencer=" + referencer + ", referenced=" + referenced + ", feature=" + feature);
                        }
                        String guid = referenced.getGuid();
                        int i = 0;
                        while (i < list.size()) {
                            InternalEObject ref = (InternalEObject)list.get(i);
                            URI uri = ref.eProxyURI();
                            if (uri != null && guid.equals(uri.fragment())) {
                                list.remove(i);
                                this.removedReferences.add(new Reference(referencer, feature, referenced, i));
                                continue block2;
                            }
                            ++i;
                        }
                        continue;
                    }
                    referencer.eSet(feature, null);
                    this.removedReferences.add(new Reference(referencer, feature, referenced, -1));
                }
            }
        }
        if (TngUtil.DEBUG) {
            System.out.println("removedReferences: size=" + this.removedReferences.size());
        }
        this.refRemoved = true;
    }

    protected void loadOppositeFeatures(List oppositeFeatures, Set deletedGUIDs) {
    }

    private void restoreReferences() {
        if (!this.refRemoved) {
            return;
        }
        int i = this.removedReferences.size() - 1;
        while (i > -1) {
            Reference ref = (Reference)this.removedReferences.get(i);
            if (ref.feature.isMany()) {
                List list = (List)ref.owner.eGet(ref.feature);
                if (ref.index != -1) {
                    if (!list.contains(ref.value)) {
                        if (ref.index < list.size()) {
                            list.add(ref.index, ref.value);
                        } else {
                            if (TngUtil.DEBUG) {
                                System.out.println("DeleteMethodElementCommand.removeReferences(): index=" + ref.index + ", size=" + list.size() + ", referencer=" + ref.owner + ", referenced=" + ref.value + ", feature=" + ref.feature);
                            }
                            list.add(ref.value);
                        }
                    } else if (TngUtil.DEBUG) {
                        System.out.println("DeleteMethodElementCommand.removeReferences(): reference already exists: referencer=" + ref.owner + ", referenced=" + ref.value + ", feature=" + ref.feature);
                    }
                } else {
                    list.add(ref.value);
                }
            } else {
                ref.owner.eSet(ref.feature, ref.value);
            }
            --i;
        }
        this.refRemoved = false;
    }

    public void undo() {
        try {
            super.undo();
            this.restoreReferences();
        }
        catch (Exception e) {
            LibraryEditPlugin.INSTANCE.log(e);
            this.notifyFailure();
        }
    }

    public Collection getAffectedObjects() {
        if (this.executed) {
            return super.getAffectedObjects();
        }
        return this.elements;
    }

    public void addCommandListener(CommandListener listener) {
        if (!this.commandListeners.contains(listener)) {
            this.commandListeners.add(listener);
        }
    }

    public void removeCommandListener(CommandListener listener) {
        this.commandListeners.remove(listener);
    }

    public static interface CommandListener {
        public void notifyExecuted(EventObject var1);

        public void notifyFailure(EventObject var1);
    }
}

