/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.configuration;

import com.ibm.uma.MethodConfiguration;
import com.ibm.uma.MethodPackage;
import com.ibm.uma.MethodPlugin;
import com.ibm.uma.Process;
import com.ibm.uma.ProcessComponent;
import com.ibm.uma.ProcessPackage;
import com.ibm.uma.util.UmaUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.epf.library.edit.IConfigurable;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.ILibraryItemProvider;

public class CategorizedProcessesItemProvider
extends ItemProviderAdapter
implements IEditingDomainItemProvider,
IStructuredItemContentProvider,
ITreeItemContentProvider,
IItemLabelProvider,
IItemPropertySource,
IConfigurable,
ILibraryItemProvider {
    List children;
    private String label;
    private Object parent;
    private String[] pkgPath;
    private IFilter filter;
    private Object image;
    private MethodConfiguration methodConfig;

    public CategorizedProcessesItemProvider(AdapterFactory adapterFactory, MethodConfiguration methodConfig, String name, Object image, String[] pkgPath) {
        super(adapterFactory);
        this.methodConfig = methodConfig;
        this.label = name;
        this.pkgPath = pkgPath;
        this.image = image;
    }

    public Collection getChildren(Object object) {
        if (this.children == null) {
            this.children = new ArrayList();
        } else {
            this.children.clear();
        }
        ArrayList<ProcessPackage> procPkgs = new ArrayList<ProcessPackage>();
        Iterator iter = this.methodConfig.getMethodPluginSelection().iterator();
        while (iter.hasNext()) {
            MethodPlugin plugin = (MethodPlugin)iter.next();
            MethodPackage pkg = UmaUtil.findMethodPackage((MethodPlugin)plugin, (String[])this.pkgPath);
            if (pkg == null || !this.methodConfig.getMethodPackageSelection().contains(pkg)) continue;
            Iterator iterator = pkg.getChildPackages().iterator();
            while (iterator.hasNext()) {
                Object element = iterator.next();
                if (!this.filter.accept(element)) continue;
                ProcessPackage procPkg = (ProcessPackage)element;
                if (procPkg instanceof ProcessComponent) {
                    Process proc = ((ProcessComponent)procPkg).getProcess();
                    if (proc == null || !this.filter.accept(proc)) continue;
                    this.children.add(proc);
                    continue;
                }
                procPkgs.add(procPkg);
            }
        }
        if (!procPkgs.isEmpty()) {
            this.children.addAll(0, procPkgs);
        }
        return this.children;
    }

    public Collection getNewChildDescriptors(Object object, EditingDomain editingDomain, Object sibling) {
        return super.getNewChildDescriptors((Object)this.methodConfig, editingDomain, sibling);
    }

    public Object getParent(Object object) {
        if (this.parent != null) {
            return this.parent;
        }
        if (object instanceof EObject) {
            return super.getParent(object);
        }
        return null;
    }

    public Object getImage(Object object) {
        return this.image;
    }

    public String getText(Object object) {
        if (this.label != null) {
            return this.label;
        }
        return super.getText(object);
    }

    public void setFilter(IFilter filter) {
        this.filter = filter;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setParent(Object parent) {
        this.parent = parent;
    }

    public Collection getChildrenFeatures(Object object) {
        return super.getChildrenFeatures(object);
    }
}

